/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import de.slikey.effectlib.EffectManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class SkillBaseGroundEffect
extends ActiveSkill {
    protected static final String HEIGHT_NODE = "height";

    public SkillBaseGroundEffect(Heroes plugin, String name) {
        super(plugin, name);
    }

    private void castGroundEffect(Hero hero, Location location, double radius, double height, GroundEffectActionsWithVisuals actions, AreaGroundEffectEffect effect, EffectManager effectManager) {
        this.cast(hero, location, radius, height, target -> actions.groundEffectTargetAction(hero, target, effect, effectManager));
    }

    private void castGroundEffect(Hero hero, Location location, double radius, double height, GroundEffectActions actions, AreaGroundEffectEffect effect) {
        this.cast(hero, location, radius, height, target -> actions.groundEffectTargetAction(hero, target, effect));
    }

    private void cast(final Hero hero, final Location location, final double radius, final double height, final CastTargetActionPredicate targetAction) {
        final Set<Entity> possibleTargets = SkillBaseGroundEffect.getEntitiesInChunks(location, (int)(radius + 16.0) / 16);
        Bukkit.getServer().getScheduler().runTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (Entity target : possibleTargets) {
                    if (!(target instanceof LivingEntity)) continue;
                    if (!SkillBaseGroundEffect.this.isAreaGroundEffectApplied(hero)) break;
                    Location targetLocation = target.getLocation();
                    double targetY = targetLocation.getY();
                    targetLocation.setY(location.getY());
                    if (!(location.distanceSquared(targetLocation) <= radius * radius && targetY <= location.getY() + height && targetY >= location.getY() - height)) continue;
                    targetAction.cast((LivingEntity)target);
                }
            }
        });
    }

    private static Set<Entity> getEntitiesInChunks(Location l, int chunkRadius) {
        HashSet<Entity> entities = new HashSet<Entity>();
        Chunk origin = l.getChunk();
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                Collections.addAll(entities, origin.getWorld().getChunkAt(origin.getX() + x, origin.getZ() + z).getEntities());
            }
        }
        return entities;
    }

    protected void applyAreaGroundEffectEffect(Hero hero, long period, long duration, Location location, double radius, double height, GroundEffectActions sphereActions, String applyText, String expireText, EffectType ... effectTypes) {
        AreaGroundEffectEffect effect = new AreaGroundEffectEffect(hero.getPlayer(), period, duration, location, radius, height, sphereActions, applyText, expireText);
        Collections.addAll(effect.types, effectTypes);
        hero.addEffect(effect);
    }

    protected void applyAreaGroundEffectEffect(Hero hero, long period, long duration, Location location, double radius, double height, GroundEffectActionsWithVisuals sphereActions, String applyText, String expireText, EffectType ... effectTypes) {
        AreaGroundEffectEffect effect = new AreaGroundEffectEffect(hero.getPlayer(), period, duration, location, radius, height, sphereActions, applyText, expireText);
        Collections.addAll(effect.types, effectTypes);
        hero.addEffect(effect);
    }

    protected void applyAreaGroundEffectEffect(Hero hero, long period, long duration, Location location, double radius, double height, GroundEffectActions sphereActions, EffectType ... effectTypes) {
        this.applyAreaGroundEffectEffect(hero, period, duration, location, radius, height, sphereActions, (String)null, (String)null, effectTypes);
    }

    protected void applyAreaGroundEffectEffect(Hero hero, long period, long duration, Location location, double radius, double height, GroundEffectActionsWithVisuals sphereActions, EffectType ... effectTypes) {
        this.applyAreaGroundEffectEffect(hero, period, duration, location, radius, height, sphereActions, (String)null, (String)null, effectTypes);
    }

    protected boolean isAreaGroundEffectApplied(Hero hero) {
        return hero.hasEffect(this.getName());
    }

    public static interface GroundEffectActionsWithVisuals {
        public void groundEffectTickAction(Hero var1, AreaGroundEffectEffect var2, EffectManager var3);

        public void groundEffectTargetAction(Hero var1, LivingEntity var2, AreaGroundEffectEffect var3, EffectManager var4);
    }

    protected final class AreaGroundEffectEffect
    extends PeriodicExpirableEffect {
        private EffectManager effectManager;
        private GroundEffectActionsWithVisuals actionsWithVisuals;
        private GroundEffectActions actions;
        private Location location;
        private double radius;
        private double height;

        public AreaGroundEffectEffect(Player applier, long period, long duration, Location location, double radius, double height, GroundEffectActionsWithVisuals actions, String applyText, String expireText) {
            this(applier, period, duration, location, radius, height, applyText, expireText);
            this.actionsWithVisuals = actions;
            this.effectManager = new EffectManager((Plugin)this.plugin);
        }

        public AreaGroundEffectEffect(Player applier, long period, long duration, Location location, double radius, double height, GroundEffectActions actions, String applyText, String expireText) {
            this(applier, period, duration, location, radius, height, applyText, expireText);
            this.actions = actions;
        }

        private AreaGroundEffectEffect(Player applier, long period, long duration, Location location, double radius, double height, String applyText, String expireText) {
            super((Skill)SkillBaseGroundEffect.this, SkillBaseGroundEffect.this.getName(), applier, period, duration, applyText, expireText);
            this.effectManager = null;
            this.actionsWithVisuals = null;
            this.actions = null;
            this.location = location;
            this.radius = radius;
            this.height = height;
            this.types.add(EffectType.AREA_OF_EFFECT);
            this.types.add(EffectType.BENEFICIAL);
        }

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }

        public double getRadius() {
            return this.radius;
        }

        public void setRadius(double radius) {
            this.radius = radius;
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double height) {
            this.height = height;
        }

        @Override
        public void tickHero(Hero hero) {
            if (this.actions != null) {
                this.actions.groundEffectTickAction(hero, this);
                SkillBaseGroundEffect.this.castGroundEffect(hero, this.location, this.radius, this.height, this.actions, this);
            } else if (this.actionsWithVisuals != null) {
                this.actionsWithVisuals.groundEffectTickAction(hero, this, this.effectManager);
                SkillBaseGroundEffect.this.castGroundEffect(hero, this.location, this.radius, this.height, this.actionsWithVisuals, this, this.effectManager);
            } else {
                Heroes.log(Level.WARNING, "The Ground effect skill (" + this.skill.getName() + ") passed a null ground effect actions interface.");
            }
        }

        @Override
        public void tickMonster(Monster monster) {
            throw new UnsupportedOperationException("Area Sphere tick on monster");
        }

        @Override
        public void removeFromHero(Hero hero) {
            super.removeFromHero(hero);
            if (this.effectManager != null) {
                this.effectManager.dispose();
            }
        }
    }

    private static interface CastTargetActionPredicate {
        public void cast(LivingEntity var1);
    }

    public static interface GroundEffectActions {
        public void groundEffectTickAction(Hero var1, AreaGroundEffectEffect var2);

        public void groundEffectTargetAction(Hero var1, LivingEntity var2, AreaGroundEffectEffect var3);
    }
}

