/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.util.Messaging;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class SkillBaseForgeItem
extends ActiveSkill {
    protected int defaultAmount;
    protected Material deafultItem;

    public SkillBaseForgeItem(Heroes plugin, String name) {
        super(plugin, name);
    }

    public SkillBaseForgeItem(Heroes plugin) {
        this(plugin, "ForgeItem");
        this.setDescription("You forge an item!");
        this.setUsage("/skill forgeitem");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("skill forgeitem");
        this.setTypes(SkillType.ITEM_CREATION);
        this.defaultAmount = 1;
        this.deafultItem = Material.LEATHER_BOOTS;
    }

    @Override
    public String getDescription(Hero hero) {
        int amount = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.AMOUNT, this.defaultAmount, false);
        return this.getDescription().replace("$1", "" + amount);
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection node = super.getDefaultConfig();
        node.set(SkillSetting.AMOUNT.node(), (Object)1);
        return node;
    }

    @Override
    public SkillResult use(Hero hero, String[] args) {
        Player player = hero.getPlayer();
        ItemStack forgedItem = new ItemStack(this.deafultItem, SkillConfigManager.getUseSetting(hero, (Skill)this, "amount", 1, false));
        ItemMeta metaData = forgedItem.getItemMeta();
        PlayerInventory inventory = player.getInventory();
        HashMap leftOvers = inventory.addItem(new ItemStack[]{forgedItem});
        for (Map.Entry entry : leftOvers.entrySet()) {
            player.getWorld().dropItemNaturally(player.getLocation(), (ItemStack)entry.getValue());
            Messaging.send((CommandSender)player, "Items have been dropped at your feet!", new Object[0]);
        }
        this.broadcastExecuteText(hero);
        hero.getPlayer().getWorld().playSound(hero.getPlayer().getLocation(), Sound.BLOCK_ANVIL_USE, 0.6f, 1.0f);
        return SkillResult.NORMAL;
    }
}

