/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.util.Util;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public abstract class SkillBaseConeShot
extends ActiveSkill {
    public SkillBaseConeShot(Heroes plugin, String name) {
        super(plugin, name);
        this.setTypes(SkillType.AREA_OF_EFFECT);
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection config = super.getDefaultConfig();
        config.set(SkillSetting.MAX_DISTANCE.node(), (Object)6.0);
        config.set(SkillSetting.RADIUS.node(), (Object)3.0);
        config.set("cone-travel-delay", (Object)1);
        return config;
    }

    @Override
    public SkillResult use(final Hero hero, String[] args) {
        Block tempMiddleRowBlock;
        int distance;
        final Player player = hero.getPlayer();
        BlockIterator blockIterator = this.getLineBlockIterator(player, distance = SkillConfigManager.getUseSettingInt(hero, (Skill)this, SkillSetting.MAX_DISTANCE, false));
        if (blockIterator == null) {
            return SkillResult.INVALID_TARGET_NO_MSG;
        }
        boolean isXDirection = this.isXDirection(player);
        int delay = SkillConfigManager.getUseSettingInt(hero, (Skill)this, "cone-travel-delay", false);
        double radius = SkillConfigManager.getUseSettingDouble(hero, (Skill)this, SkillSetting.RADIUS, false);
        final double radiusSquared = radius * radius;
        final List nearbyEntities = player.getNearbyEntities((double)(distance * 2), (double)distance, (double)(distance * 2));
        final ArrayList hitEnemies = new ArrayList();
        this.broadcastExecuteText(hero);
        this.applySoundEffects(player.getWorld(), player.getLocation());
        final SkillBaseConeShot skill = this;
        int numBlocks = 0;
        while (blockIterator.hasNext() && this.continueForwardThroughBlock(tempMiddleRowBlock = blockIterator.next())) {
            final List<Location> locations = this.getNewRowBlockLocations(isXDirection, tempMiddleRowBlock);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    SkillBaseConeShot.this.doParticlesAtLocations(player.getWorld(), locations);
                    for (Entity entity : nearbyEntities) {
                        LivingEntity livingEntity;
                        if (!(entity instanceof LivingEntity) || hitEnemies.contains(entity) || !SkillBaseConeShot.this.isEntityInRangeOfAnyLocation(livingEntity = (LivingEntity)entity, radiusSquared, locations) || !Skill.damageCheck(player, livingEntity)) continue;
                        CharacterTemplate target = SkillBaseConeShot.this.plugin.getCharacterManager().getCharacter(livingEntity);
                        SkillBaseConeShot.this.effectTarget(hero, skill, target);
                        hitEnemies.add(entity);
                    }
                }
            }, (long)(numBlocks * delay));
            ++numBlocks;
        }
        return SkillResult.NORMAL;
    }

    protected abstract void effectTarget(Hero var1, Skill var2, CharacterTemplate var3);

    protected abstract void spawnParticleEffects(World var1, Location var2);

    protected abstract void applySoundEffects(World var1, Location var2);

    protected void doParticlesAtLocations(World world, List<Location> locations) {
        for (Location location : locations) {
            this.spawnParticleEffects(world, location);
        }
    }

    protected boolean continueForwardThroughBlock(Block block) {
        return Util.transparentBlocks.contains(block.getType());
    }

    protected boolean isEntityInRangeOfAnyLocation(LivingEntity entity, double radiusSquared, List<Location> locations) {
        boolean inRange = false;
        for (Location location : locations) {
            if (!(entity.getLocation().distanceSquared(location) <= radiusSquared)) continue;
            inRange = true;
            break;
        }
        return inRange;
    }

    protected List<Location> getNewRowBlockLocations(boolean isXDirection, Block middleLocationBlock) {
        ArrayList<Location> locations = new ArrayList<Location>();
        if (isXDirection) {
            for (int xDir = -1; xDir < 2; ++xDir) {
                Block radiusBlocks = middleLocationBlock.getRelative(xDir, 0, 0);
                if (!this.continueForwardThroughBlock(radiusBlocks)) continue;
                locations.add(radiusBlocks.getLocation().clone().add(new Vector(0.5, 0.0, 0.5)));
            }
        } else {
            for (int zDir = -1; zDir < 2; ++zDir) {
                Block radiusBlocks = middleLocationBlock.getRelative(0, 0, zDir);
                if (!this.continueForwardThroughBlock(radiusBlocks)) continue;
                locations.add(radiusBlocks.getLocation().clone().add(new Vector(0.5, 0.0, 0.5)));
            }
        }
        return locations;
    }

    @Nullable
    protected BlockIterator getLineBlockIterator(Player player, int distance) {
        BlockIterator blockIterator;
        try {
            blockIterator = new BlockIterator((LivingEntity)player, distance);
        }
        catch (IllegalStateException e) {
            return null;
        }
        return blockIterator;
    }

    protected boolean isXDirection(Player player) {
        Vector u = player.getLocation().getDirection();
        u = new Vector(u.getX(), 0.0, u.getZ()).normalize();
        Vector v = new Vector(0, 0, -1);
        double magU = Math.sqrt(Math.pow(u.getX(), 2.0) + Math.pow(u.getZ(), 2.0));
        double magV = Math.sqrt(Math.pow(v.getX(), 2.0) + Math.pow(v.getZ(), 2.0));
        double angle = Math.acos(u.dot(v) / (magU * magV));
        angle = angle * 180.0 / Math.PI;
        return (angle = Math.abs(angle - 180.0)) <= 45.0 || angle > 135.0;
    }
}

