/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.nms.physics.collision.AABB;
import com.herocraftonline.heroes.nms.physics.collision.ColliderVolume;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public abstract class SkillBaseBlockWave
extends ActiveSkill {
    protected static final String HEIGHT_NODE = "height";
    protected static final String DEPTH_NODE = "depth";
    protected static final String EXPANSION_RATE_NODE = "expansion-rate";
    protected static final String LAUNCH_FORCE_NODE = "launch-force";
    protected static final String WAVE_ARC_NODE = "wave-arc";
    protected static final String HIT_LIMIT_NODE = "hit-limit";
    private static final String FALLING_BLOCK_METADATA_KEY = "block-launch";
    private static final Set<FallingBlock> waveBlocks = new HashSet<FallingBlock>();

    public SkillBaseBlockWave(Heroes plugin, String name) {
        super(plugin, name);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new BlockFallListener(), (Plugin)plugin);
    }

    protected void castBlockWave(Hero hero, Block centerBlock, WaveTargetAction targetAction) {
        if (centerBlock != null) {
            World world = centerBlock.getWorld();
            Location center = centerBlock.getLocation().add(0.5, 0.5, 0.5);
            Location playerLoc = hero.getPlayer().getEyeLocation();
            playerLoc.setPitch(0.0f);
            Vector direction = playerLoc.getDirection();
            double radius = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.RADIUS, 5.0, false);
            double expansionRate = SkillConfigManager.getUseSetting(hero, (Skill)this, EXPANSION_RATE_NODE, 1.0, false);
            double launchForce = SkillConfigManager.getUseSetting(hero, (Skill)this, LAUNCH_FORCE_NODE, 0.2, false);
            double waveArc = Math.toRadians(SkillConfigManager.getUseSetting(hero, (Skill)this, WAVE_ARC_NODE, 360.0, false)) / 2.0;
            int hitLimit = SkillConfigManager.getUseSetting(hero, (Skill)this, HIT_LIMIT_NODE, 1, false);
            int blockDepth = Math.max(centerBlock.getY() - SkillConfigManager.getUseSetting(hero, (Skill)this, DEPTH_NODE, 5, false), 0);
            int blockHeight = Math.min(centerBlock.getY() + SkillConfigManager.getUseSetting(hero, (Skill)this, HEIGHT_NODE, 0, false), hero.getPlayer().getWorld().getMaxHeight());
            int xMin = Location.locToBlock((double)(center.getX() - radius));
            int xMax = Location.locToBlock((double)(center.getX() + radius));
            int zMin = Location.locToBlock((double)(center.getZ() - radius));
            int zMax = Location.locToBlock((double)(center.getZ() + radius));
            final ArrayList<WaveBlock> wave = new ArrayList<WaveBlock>();
            HashMap<UUID, Integer> hitTracker = new HashMap<UUID, Integer>();
            for (int x = xMin; x <= xMax; ++x) {
                for (int y = blockDepth; y <= blockHeight; ++y) {
                    for (int z = zMin; z <= zMax; ++z) {
                        Location blockCenter;
                        double distance;
                        Block block = world.getBlockAt(x, y, z);
                        if (block == null) continue;
                        Block aboveBlock = block.getRelative(BlockFace.UP);
                        if (!block.getType().isSolid() || aboveBlock == null || aboveBlock.getType().isSolid() || block.getY() < blockDepth || block.getY() > blockHeight || !((distance = this.distanceXZ(blockCenter = block.getLocation().add(0.5, 0.5, 0.5), center)) < radius)) continue;
                        if (waveArc < 180.0) {
                            Vector blockDirection = blockCenter.toVector().subtract(center.toVector());
                            blockDirection.setY(0);
                            if ((block.getX() != centerBlock.getX() || block.getZ() != centerBlock.getZ()) && (double)direction.angle(blockDirection) > waveArc) continue;
                        }
                        long launchTime = (long)(distance / expansionRate);
                        WaveBlock waveBlock = new WaveBlock(hero, center, block, launchTime, launchForce, targetAction, hitTracker, hitLimit);
                        wave.add(waveBlock);
                    }
                }
            }
            Collections.sort(wave);
            new BukkitRunnable(){
                long tick = 0L;
                Iterator<WaveBlock> iterator = wave.iterator();
                WaveBlock waveBlock;
                {
                    if (this.iterator.hasNext()) {
                        this.waveBlock = this.iterator.next();
                        this.runTaskTimer((Plugin)SkillBaseBlockWave.this.plugin, 0L, 1L);
                    }
                }

                public void run() {
                    do {
                        this.waveBlock.launch();
                    } while (this.advance());
                    ++this.tick;
                }

                private boolean advance() {
                    if (this.iterator.hasNext()) {
                        this.waveBlock = this.iterator.next();
                        return this.waveBlock.getLaunchTime() <= this.tick;
                    }
                    this.waveBlock = null;
                    this.cancel();
                    return false;
                }
            };
        }
    }

    private double distanceXZ(Location l1, Location l2) {
        return Math.sqrt(NumberConversions.square((double)(l1.getX() - l2.getX())) + NumberConversions.square((double)(l1.getZ() - l2.getZ())));
    }

    private class BlockFallListener
    implements Listener {
        private BlockFallListener() {
        }

        @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
        private void onBlockWaveFall(EntityChangeBlockEvent event) {
            if (!(event.getEntity() instanceof FallingBlock) || !event.getEntity().hasMetadata(SkillBaseBlockWave.FALLING_BLOCK_METADATA_KEY)) {
                return;
            }
            FallingBlock block = (FallingBlock)event.getEntity();
            event.setCancelled(true);
            event.getEntity().remove();
            waveBlocks.remove(block);
        }

        @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
        public void onPluginDisable(PluginDisableEvent event) {
            if (event.getPlugin() != SkillBaseBlockWave.this.plugin) {
                return;
            }
            for (FallingBlock waveBlock : waveBlocks) {
                waveBlock.remove();
            }
        }
    }

    private class WaveBlock
    implements Comparable<WaveBlock> {
        private final Hero hero;
        private final Location center;
        private final Block block;
        private final long launchTime;
        private final double launchForce;
        private final WaveTargetAction targetAction;
        private final Map<UUID, Integer> hitTracker;
        private final int hitLimit;

        public WaveBlock(Hero hero, Location center, Block block, long launchTime, double launchForce, WaveTargetAction targetAction, Map<UUID, Integer> hitTracker, int hitLimit) {
            this.hero = hero;
            this.center = center;
            this.block = block;
            this.launchTime = launchTime;
            this.launchForce = launchForce;
            this.targetAction = targetAction;
            this.hitTracker = hitTracker;
            this.hitLimit = hitLimit;
        }

        public void launch() {
            FallingBlock fb = this.block.getWorld().spawnFallingBlock(this.block.getRelative(BlockFace.UP).getLocation(), this.block.getType(), this.block.getData());
            fb.setDropItem(false);
            fb.setVelocity(new Vector(0.0, this.launchForce, 0.0));
            fb.setMetadata(SkillBaseBlockWave.FALLING_BLOCK_METADATA_KEY, (MetadataValue)new FixedMetadataValue((Plugin)SkillBaseBlockWave.this.plugin, new Object()));
            waveBlocks.add(fb);
            NMSPhysics physics = NMSHandler.getInterface().getNMSPhysics();
            AABB aabb = physics.createAABB(this.block.getX(), this.block.getY(), this.block.getZ(), this.block.getX() + 1, this.block.getY() + 3, this.block.getZ() + 1);
            for (Entity target : physics.getEntitiesInVolume(this.block.getWorld(), (Entity)this.hero.getPlayer(), (ColliderVolume)aabb, new Predicate<Entity>(){

                @Override
                public boolean test(Entity entity) {
                    if (!(entity instanceof LivingEntity)) {
                        return false;
                    }
                    Integer hitCount = WaveBlock.this.hitTracker.get(entity.getUniqueId());
                    if (hitCount == null) {
                        hitCount = 0;
                    }
                    Integer n = hitCount;
                    hitCount = hitCount + 1;
                    boolean hit = n < WaveBlock.this.hitLimit;
                    WaveBlock.this.hitTracker.put(entity.getUniqueId(), hitCount);
                    return hit;
                }
            })) {
                this.targetAction.onTarget(this.hero, (LivingEntity)target, this.center);
            }
        }

        public long getLaunchTime() {
            return this.launchTime;
        }

        @Override
        public int compareTo(WaveBlock o) {
            return Long.compare(this.launchTime, o.launchTime);
        }
    }

    protected static interface WaveTargetAction {
        public void onTarget(Hero var1, LivingEntity var2, Location var3);
    }
}

