/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.nms.physics.RayCastFlag;
import com.herocraftonline.heroes.nms.physics.RayCastHit;
import com.herocraftonline.heroes.nms.physics.collision.AABB;
import com.herocraftonline.heroes.nms.physics.collision.Capsule;
import com.herocraftonline.heroes.nms.physics.collision.ColliderVolume;
import de.slikey.effectlib.EffectManager;
import de.slikey.effectlib.effect.CylinderEffect;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public abstract class SkillBaseBeamShot
extends ActiveSkill {
    protected static final String VELOCITY_NODE = "velocity";
    protected static final String PENETRATION_NODE = "penetration";
    private static NMSPhysics physics = NMSHandler.getInterface().getNMSPhysics();

    public SkillBaseBeamShot(Heroes plugin, String name) {
        super(plugin, name);
    }

    protected void fireBeamShot(final Hero hero, final double range, final double radius, final double velocity, final double penetration, final BeamShotHit hitAction, final Predicate<Block> blockFilter, EnumSet<RayCastFlag> flags) {
        new BukkitRunnable(){
            private World world;
            private Vector origin;
            private Location originLocation;
            private Vector directionNormal;
            private Vector direction;
            private Capsule shot;
            private boolean firstTick = true;
            private boolean finalTick = false;
            private int frame = 1;
            private Set<UUID> hits = new HashSet<UUID>();
            {
                Vector shotEnd;
                this.world = hero.getPlayer().getWorld();
                this.origin = hero.getPlayer().getEyeLocation().toVector();
                this.directionNormal = hero.getPlayer().getEyeLocation().getDirection();
                this.originLocation = this.origin.toLocation(this.world).setDirection(this.directionNormal);
                this.direction = this.directionNormal.clone().multiply(velocity);
                if (velocity < range) {
                    shotEnd = this.origin.clone().add(this.direction);
                } else {
                    shotEnd = this.origin.clone().add(this.directionNormal.clone().multiply(range));
                    this.finalTick = true;
                }
                RayCastHit blockHit = physics.rayCastBlocks(this.world, this.origin, shotEnd, blockFilter);
                if (blockHit != null) {
                    shotEnd = blockHit.getPoint();
                    this.finalTick = true;
                }
                this.shot = physics.createCapsule(this.origin, shotEnd, radius);
                this.runTaskTimer((Plugin)SkillBaseBeamShot.this.plugin, 1L, 1L);
            }

            public void run() {
                List<Entity> possibleTargets = physics.getEntitiesInVolume(this.world, (Entity)hero.getPlayer(), (ColliderVolume)this.shot, new Predicate<Entity>(){

                    @Override
                    public boolean test(Entity entity) {
                        return entity instanceof LivingEntity && !hits.contains(entity.getUniqueId());
                    }
                });
                TreeSet<PossibleHit> possibleHits = new TreeSet<PossibleHit>();
                for (Entity possibleTarget : possibleTargets) {
                    AABB entityAABB = physics.getEntityAABB(possibleTarget);
                    Vector shotRay = this.shot.getPoint2().subtract(this.shot.getPoint1());
                    double lengthSq = shotRay.lengthSquared();
                    double dot = shotRay.dot(entityAABB.getCenter().subtract(this.shot.getPoint1()));
                    if (dot < 0.0) continue;
                    Vector shotPoint = dot == 0.0 ? this.shot.getPoint1() : (dot >= lengthSq ? this.shot.getPoint2() : this.shot.getPoint1().add(shotRay.multiply(dot / lengthSq)));
                    double shotLengthSq = shotRay.lengthSquared();
                    if (physics.rayCastBlocks(this.world, shotPoint, entityAABB.getCenter(), blockFilter) != null) continue;
                    double distanceSq = shotRay.clone().multiply(dot / shotLengthSq).lengthSquared();
                    possibleHits.add(new PossibleHit((LivingEntity)possibleTarget, distanceSq, shotPoint));
                }
                for (PossibleHit possibleHit : possibleHits) {
                    this.hits.add(possibleHit.getTarget().getUniqueId());
                    if ((double)this.hits.size() > penetration) {
                        hitAction.onHit(hero, possibleHit.getTarget(), this.originLocation.clone(), this.shot, this.hits.size(), this.hits.size() == 1, true);
                        this.shot = physics.createCapsule(this.shot.getPoint1(), possibleHit.getShotPoint(), this.shot.getRadius());
                        this.finalTick = true;
                        break;
                    }
                    hitAction.onHit(hero, possibleHit.getTarget(), this.originLocation.clone(), this.shot, this.hits.size(), this.hits.size() == 1, false);
                }
                hitAction.onRenderShot(this.originLocation.clone(), this.shot, this.frame++, this.firstTick, this.finalTick);
                this.firstTick = false;
                if (this.finalTick) {
                    this.cancel();
                } else {
                    RayCastHit blockHit;
                    Vector newShotEnd = this.shot.getPoint2().add(this.direction);
                    if (this.origin.distanceSquared(newShotEnd) > NumberConversions.square((double)range)) {
                        newShotEnd = this.origin.clone().add(this.directionNormal.clone().multiply(range));
                        this.finalTick = true;
                    }
                    if ((blockHit = physics.rayCast(this.world, this.shot.getPoint2(), newShotEnd, blockFilter, e -> true)) != null) {
                        newShotEnd = blockHit.getPoint();
                        this.finalTick = true;
                    }
                    this.shot = physics.createCapsule(this.shot.getPoint2(), newShotEnd, radius);
                }
            }
        };
    }

    protected void renderBeamShotFrame(Location origin, Capsule shot, Particle particle, Color color, int particles, int iterations, float visibleRange, double radiusScale, double startOffset) {
        boolean render = false;
        Vector originV = origin.toVector();
        Vector start = null;
        Vector end = null;
        if (originV.distanceSquared(shot.getPoint1()) >= NumberConversions.square((double)startOffset)) {
            start = shot.getPoint1();
            end = shot.getPoint2();
            render = true;
        } else if (originV.distanceSquared(shot.getPoint2()) >= NumberConversions.square((double)startOffset)) {
            start = shot.getPoint1().add(shot.getPoint2().subtract(shot.getPoint1()).normalize());
            end = shot.getPoint2();
            render = true;
        }
        if (render) {
            EffectManager em = new EffectManager((Plugin)this.plugin);
            CylinderEffect cyl = new CylinderEffect(em);
            cyl.setLocation(start.clone().add(end.clone().subtract(start).multiply(0.5)).toLocation(origin.getWorld()));
            cyl.asynchronous = true;
            cyl.radius = (float)(shot.getRadius() * radiusScale);
            cyl.height = (float)start.distance(end);
            cyl.particle = particle;
            cyl.color = color;
            cyl.particles = particles;
            cyl.solid = true;
            cyl.rotationX = Math.toRadians(origin.getPitch() + 90.0f);
            cyl.rotationY = -Math.toRadians(origin.getYaw());
            cyl.angularVelocityX = 0.0;
            cyl.angularVelocityY = 0.0;
            cyl.angularVelocityZ = 0.0;
            cyl.iterations = iterations;
            cyl.visibleRange = visibleRange;
            cyl.start();
            em.disposeOnTermination();
        }
    }

    protected static interface BeamShotHit {
        public void onHit(Hero var1, LivingEntity var2, Location var3, Capsule var4, int var5, boolean var6, boolean var7);

        public void onRenderShot(Location var1, Capsule var2, int var3, boolean var4, boolean var5);
    }

    private class PossibleHit
    implements Comparable<PossibleHit> {
        private LivingEntity target;
        private double distanceSq;
        private Vector shotPoint;

        public PossibleHit(LivingEntity target, double distanceSq, Vector shotPoint) {
            this.target = target;
            this.distanceSq = distanceSq;
            this.shotPoint = shotPoint;
        }

        public LivingEntity getTarget() {
            return this.target;
        }

        public Vector getShotPoint() {
            return this.shotPoint;
        }

        @Override
        public int compareTo(PossibleHit o) {
            return Double.compare(this.distanceSq, o.distanceSq);
        }
    }
}

