/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.skills;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.nms.physics.RayCastHit;
import de.slikey.effectlib.EffectManager;
import de.slikey.effectlib.effect.CylinderEffect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public abstract class SkillBaseBeam
extends ActiveSkill {
    protected static final String BEAM_MAX_LENGTH_NODE = "beam-max-length";
    protected static final String BEAM_RADIUS_NODE = "beam-radius";

    public SkillBaseBeam(Heroes plugin, String name) {
        super(plugin, name);
    }

    protected final void castBeam(final Hero hero, final Beam beam, final TargetHandler targetHandler) {
        final Set<Entity> possibleTargets = SkillBaseBeam.getEntitiesInChunks(beam.midPoint().toLocation(hero.getPlayer().getWorld()), beam.chunkRadius);
        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ArrayList targets = new ArrayList();
                for (Entity possibleTarget : possibleTargets) {
                    LivingEntity target;
                    Optional<Beam.PointData> pointData;
                    if (!(possibleTarget instanceof LivingEntity) || possibleTarget.equals(hero.getPlayer()) || !(pointData = beam.calculatePointData((target = (LivingEntity)possibleTarget).getEyeLocation().toVector())).isPresent()) continue;
                    Bukkit.getServer().getScheduler().runTask((Plugin)SkillBaseBeam.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            targetHandler.handle(hero, target, (Beam.PointData)pointData.get());
                        }
                    });
                }
            }
        });
    }

    private static Set<Entity> getEntitiesInChunks(Location l, int chunkRadius) {
        HashSet<Entity> entities = new HashSet<Entity>();
        Chunk origin = l.getChunk();
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                Collections.addAll(entities, origin.getWorld().getChunkAt(origin.getX() + x, origin.getZ() + z).getEntities());
            }
        }
        return entities;
    }

    protected void renderBeam(Location start, Beam beam, Particle particle, Color color, int particles, int iterations, float visibleRange, double radiusScale, double startOffset) {
        EffectManager em = new EffectManager((Plugin)this.plugin);
        CylinderEffect cyl = new CylinderEffect(em);
        cyl.setLocation(beam.midPoint().toLocation(start.getWorld()).add(beam.getTrajectory().normalize().multiply(startOffset / 2.0)));
        cyl.asynchronous = true;
        cyl.radius = (float)(beam.radius() * radiusScale);
        cyl.height = (float)(beam.length() - startOffset);
        cyl.particle = particle;
        cyl.color = color;
        cyl.particles = particles;
        cyl.solid = true;
        cyl.rotationX = Math.toRadians(start.getPitch() + 90.0f);
        cyl.rotationY = -Math.toRadians(start.getYaw());
        cyl.angularVelocityX = 0.0;
        cyl.angularVelocityY = 0.0;
        cyl.angularVelocityZ = 0.0;
        cyl.iterations = iterations;
        cyl.visibleRange = visibleRange;
        cyl.start();
        em.disposeOnTermination();
    }

    protected void renderBeam(Location start, Beam beam, Particle particle, int particles, int iterations, float visibleRange, double radiusScale, double startOffset) {
        this.renderBeam(start, beam, particle, Color.WHITE, particles, iterations, visibleRange, radiusScale, startOffset);
    }

    protected void renderEyeBeam(Player player, Beam beam, Particle particle, Color color, int particles, int iterations, float visibleRange, double radiusScale, double eyeOffset) {
        this.renderBeam(player.getEyeLocation(), beam, particle, color, particles, iterations, visibleRange, radiusScale, eyeOffset);
    }

    protected void renderEyeBeam(Player player, Beam beam, Particle particle, int particles, int iterations, float visibleRange, double radiusScale, double eyeOffset) {
        this.renderEyeBeam(player, beam, particle, Color.WHITE, particles, iterations, visibleRange, radiusScale, eyeOffset);
    }

    protected static Beam createBeam(Vector origin, Vector trajectory, double radius) {
        return new Beam(origin, trajectory, radius);
    }

    protected static Beam createBeam(Vector origin, Vector direction, double length, double radius) {
        return SkillBaseBeam.createBeam(origin, origin.add(direction.normalize().multiply(length)), radius);
    }

    protected static Beam createBeam(Location origin, double length, double radius) {
        return SkillBaseBeam.createBeam(origin.toVector(), origin.getDirection().multiply(length), radius);
    }

    protected static Beam createObstructedBeam(World world, Vector origin, Vector direction, int maxLength, double radius) {
        Vector start = origin;
        Vector end = direction.clone().normalize().multiply(maxLength).add(start);
        RayCastHit hit = NMSHandler.getInterface().getNMSPhysics().rayCastBlocks(world, start, end);
        Vector trajectory = hit != null ? hit.getPoint().subtract(start) : end.subtract(start);
        return SkillBaseBeam.createBeam(start, trajectory, radius);
    }

    protected static Beam createObstructedBeam(Location origin, int maxLength, double radius) {
        Vector start = origin.toVector();
        Vector end = origin.getDirection().multiply(maxLength).add(start);
        RayCastHit hit = NMSHandler.getInterface().getNMSPhysics().rayCastBlocks(origin.getWorld(), start, end);
        Vector trajectory = hit != null ? hit.getPoint().subtract(start) : end.subtract(start);
        return SkillBaseBeam.createBeam(start, trajectory, radius);
    }

    private static Block getTargetBlock(BlockIterator blockIterator, Set<Material> transparent) {
        Block block = null;
        while (blockIterator.hasNext()) {
            block = blockIterator.next();
            if (!(transparent != null ? !transparent.contains(block.getType()) : block.getType() == Material.AIR)) continue;
            return block;
        }
        return block;
    }

    protected static final class Beam {
        private final double ox;
        private final double oy;
        private final double oz;
        private final double tx;
        private final double ty;
        private final double tz;
        private final double length;
        private final double radius;
        private final int chunkRadius;

        private Beam(double ox, double oy, double oz, double tx, double ty, double tz, double length, double radius) {
            Preconditions.checkArgument((length > 0.0 ? 1 : 0) != 0, (Object)"Beam length must be greater than 0");
            Preconditions.checkArgument((radius > 0.0 ? 1 : 0) != 0, (Object)"Beam radius must be greater than 0");
            this.ox = ox;
            this.oy = oy;
            this.oz = oz;
            this.tx = tx;
            this.ty = ty;
            this.tz = tz;
            this.length = length;
            this.radius = radius;
            this.chunkRadius = (int)((Math.sqrt(tx * tx + tz * tz) / 2.0 + radius + 16.0) / 16.0);
        }

        private Beam(Vector origin, Vector trajectory, double radius) {
            this(origin.getX(), origin.getY(), origin.getZ(), trajectory.getX(), trajectory.getY(), trajectory.getZ(), trajectory.length(), radius);
        }

        public double getOriginX() {
            return this.ox;
        }

        public double getOriginY() {
            return this.oy;
        }

        public double getOriginZ() {
            return this.oz;
        }

        public Vector getOrigin() {
            return new Vector(this.getOriginX(), this.getOriginY(), this.getOriginZ());
        }

        public double getTrajectoryX() {
            return this.tx;
        }

        public double getTrajectoryY() {
            return this.ty;
        }

        public double getTrajectoryZ() {
            return this.tz;
        }

        public Vector getTrajectory() {
            return new Vector(this.getTrajectoryX(), this.getTrajectoryY(), this.getTrajectoryZ());
        }

        public Vector midPoint() {
            return this.getOrigin().midpoint(this.getOrigin().add(this.getTrajectory()));
        }

        public double length() {
            return this.length;
        }

        public double lengthSquared() {
            return this.length * this.length;
        }

        public double radius() {
            return this.radius;
        }

        public double radiusSquared() {
            return this.radius * this.radius;
        }

        public Optional<PointData> calculatePointData(Vector point, boolean roundedCap) {
            double pdz;
            double pdy;
            double pdx = point.getX() - this.ox;
            double dot = pdx * this.tx + (pdy = point.getY() - this.oy) * this.ty + (pdz = point.getZ() - this.oz) * this.tz;
            if (dot < 0.0 || dot > this.lengthSquared()) {
                if (roundedCap) {
                    double d;
                    double d2;
                    Vector refPoint = this.getOrigin();
                    double refDistanceSq = refPoint.distanceSquared(point);
                    if (d2 <= this.radiusSquared()) {
                        return Optional.of((Object)new PointData(point, pdx, pdy, pdz, refDistanceSq, dot, PointLocation.ORIGIN_CAP));
                    }
                    refDistanceSq = refPoint.add(this.getTrajectory()).distanceSquared(point);
                    if (d <= this.lengthSquared()) {
                        return Optional.of((Object)new PointData(point, pdx, pdy, pdz, refDistanceSq, dot, PointLocation.END_CAP));
                    }
                }
                return Optional.absent();
            }
            double dsq = pdx * pdx + pdy * pdy + pdz * pdz - dot * dot / this.lengthSquared();
            if (dsq <= this.radiusSquared()) {
                return Optional.of((Object)new PointData(point, pdx, pdy, pdz, dsq, dot, PointLocation.BEAM_SHAFT));
            }
            return Optional.absent();
        }

        public Optional<PointData> calculatePointData(Vector point) {
            return this.calculatePointData(point, false);
        }

        public final class PointData {
            private final double px;
            private final double py;
            private final double pz;
            private final double pdx;
            private final double pdy;
            private final double pdz;
            private final double distanceFromBeamSq;
            private final double dotProduct;
            private final PointLocation pointLocation;

            private PointData(Vector point, double pdx, double pdy, double pdz, double distanceFromBeamSq, double dotProduct, PointLocation pointLocation) {
                this.px = point.getX();
                this.py = point.getY();
                this.pz = point.getZ();
                this.pdx = pdx;
                this.pdy = pdy;
                this.pdz = pdz;
                this.distanceFromBeamSq = distanceFromBeamSq;
                this.dotProduct = dotProduct;
                this.pointLocation = pointLocation;
            }

            public Beam getBeam() {
                return Beam.this;
            }

            public double getPointX() {
                return this.px;
            }

            public double getPointY() {
                return this.py;
            }

            public double getPointZ() {
                return this.pz;
            }

            public Vector getPoint() {
                return new Vector(this.getPointX(), this.getPointY(), this.getPointZ());
            }

            public double getDirectionX() {
                return this.pdx;
            }

            public double getDirectionY() {
                return this.pdy;
            }

            public double getDirectionZ() {
                return this.pdz;
            }

            public Vector getDirection() {
                return new Vector(this.getDirectionX(), this.getDirectionY(), this.getDirectionZ());
            }

            public double getDistanceFromBeamSquared() {
                return this.distanceFromBeamSq;
            }

            public double calculateDistanceFromBeam() {
                return Math.sqrt(this.getDistanceFromBeamSquared());
            }

            public double dotProduct() {
                return this.dotProduct;
            }

            public Vector calculateVectorAlongBeam() {
                return Beam.this.getTrajectory().multiply(this.dotProduct() / Beam.this.lengthSquared());
            }

            public double calculateDistanceAlongBeam() {
                return Beam.this.length() * (this.dotProduct() / Beam.this.lengthSquared());
            }

            public Vector calculateClosestPointOnBeam() {
                switch (this.getPointLocation()) {
                    case BEAM_SHAFT: {
                        return Beam.this.getOrigin().add(this.calculateVectorAlongBeam());
                    }
                    case ORIGIN_CAP: {
                        return Beam.this.getOrigin();
                    }
                    case END_CAP: {
                        return Beam.this.getOrigin().add(Beam.this.getTrajectory());
                    }
                }
                throw new RuntimeException("This shouldn't happen");
            }

            public Vector calculateVectorFromBeam() {
                return this.getPoint().subtract(this.calculateClosestPointOnBeam());
            }

            public PointLocation getPointLocation() {
                return this.pointLocation;
            }
        }

        public static enum PointLocation {
            BEAM_SHAFT,
            ORIGIN_CAP,
            END_CAP;

        }
    }

    public static interface TargetHandler {
        public void handle(Hero var1, LivingEntity var2, Beam.PointData var3);
    }
}

