/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.runes;

import com.herocraftonline.heroes.characters.skill.runes.Rune;

public class RuneQueue {
    private int capacity = 0;
    private final int size;
    private Rune head = null;
    private Rune current;

    public RuneQueue() {
        this.size = 3;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getSize() {
        return this.size;
    }

    public Rune getHead() {
        return this.head;
    }

    public boolean isFull() {
        return this.capacity == this.size;
    }

    public boolean isEmpty() {
        return this.capacity == 0 || this.head == null;
    }

    public void pop() {
        if (!this.isEmpty()) {
            if (this.head.next == null) {
                this.head = null;
                --this.capacity;
            } else {
                this.head = this.head.next;
                --this.capacity;
            }
        }
    }

    public void push(Rune rune) {
        if (this.isEmpty()) {
            this.head = rune;
            ++this.capacity;
        } else if (this.isFull()) {
            this.pop();
            this.setCurrentToLast();
            this.current.next = rune;
            ++this.capacity;
        } else {
            this.setCurrentToLast();
            this.current.next = rune;
            ++this.capacity;
        }
        this.current = null;
    }

    public void setCurrentToLast() {
        if (this.head != null) {
            this.current = this.head;
        } else {
            return;
        }
        while (this.current.next != null) {
            this.current = this.current.next;
        }
    }

    public String[] getRuneNameList() {
        if (this.isEmpty()) {
            return null;
        }
        String[] list = new String[this.capacity];
        this.current = this.head;
        for (int i = 0; i < this.capacity; ++i) {
            list[i] = this.current.name;
            this.current = this.current.next;
        }
        this.current = null;
        return list;
    }

    public String[] getColoredRuneNameList() {
        if (this.isEmpty()) {
            return null;
        }
        String[] list = new String[this.capacity];
        this.current = this.head;
        for (int i = 0; i < this.capacity; ++i) {
            list[i] = this.current.chatColor + this.current.name;
            this.current = this.current.next;
        }
        this.current = null;
        return list;
    }
}

