/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill.ncp;

import com.google.common.collect.Lists;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.skill.ncp.NCPFunction;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NCPUtils {
    private static final String NO_CHEAT_PLUGIN = "NoCheatPlus";

    public static boolean isPlayerExempt(Object target) {
        return target instanceof Player && !((Player)target).isOp();
    }

    public static boolean isNotPlayerExempt(Object target) {
        return !NCPUtils.isPlayerExempt(target);
    }

    public static boolean isEnabled() {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin(NO_CHEAT_PLUGIN);
        return plugin != null && plugin.isEnabled();
    }

    public static boolean isNotEnabled() {
        return !NCPUtils.isEnabled();
    }

    public static void exempt(Player player, String type) {
        NCPUtils.exempt((Entity)player, Lists.newArrayList((Object[])new String[]{type}));
    }

    public static void exempt(Entity entity, Collection<String> types) {
        if (NCPUtils.isNotEnabled() || NCPUtils.isNotPlayerExempt(entity)) {
            return;
        }
        Player player = (Player)entity;
        for (String type : types) {
            NCPExemptionManager.exemptPermanently((Player)player, (CheckType)CheckType.valueOf((String)type));
        }
    }

    public static void unexempt(Player player, String type, long delay) {
        NCPUtils.unexempt((Entity)player, Lists.newArrayList((Object[])new String[]{type}), delay);
    }

    public static void unexempt(Entity entity, Collection<String> types, long duration) {
        if (NCPUtils.isNotEnabled() || NCPUtils.isNotPlayerExempt(entity)) {
            return;
        }
        final Player player = (Player)entity;
        for (final String type : types) {
            if (duration > 0L) {
                long delay = duration > 50L ? duration * 20L / 1000L : 1L;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Heroes.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        NCPExemptionManager.unexempt((Player)player, (CheckType)CheckType.valueOf((String)type));
                    }
                }, delay);
                continue;
            }
            NCPExemptionManager.unexempt((Player)player, (CheckType)CheckType.valueOf((String)type));
        }
    }

    public static void applyExemptions(Entity entity, NCPFunction function, Collection<String> types, long duration) {
        if (NCPUtils.isEnabled()) {
            NCPUtils.exempt(entity, types);
        }
        function.execute();
        if (NCPUtils.isEnabled()) {
            NCPUtils.unexempt(entity, types, duration);
        }
    }
}

