/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.api.events.HeroEnterCombatEvent;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.CustomNameManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.CombatEffect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.DelayedTargettedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.characters.skill.TargetingFlag;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.nms.physics.RayCastHit;
import com.herocraftonline.heroes.nms.physics.RayCastInfo;
import com.herocraftonline.heroes.nms.physics.collision.AABB;
import com.herocraftonline.heroes.nms.physics.collision.Capsule;
import com.herocraftonline.heroes.nms.physics.collision.ColliderVolume;
import com.herocraftonline.heroes.nms.physics.collision.Sphere;
import com.herocraftonline.heroes.util.Messaging;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public abstract class TargettedSkill
extends ActiveSkill {
    private static final NMSPhysics physics = NMSHandler.getInterface().getNMSPhysics();
    private Predicate<LivingEntity> targetFilter = t -> true;
    private Predicate<Block> blockFilter = b -> true;

    public TargettedSkill(Heroes plugin, String name) {
        super(plugin, name);
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection section = super.getDefaultConfig();
        section.set(SkillSetting.USE_TEXT.node(), (Object)(ChatComponents.GENERIC_SKILL + "%hero% used %skill% on %target%!"));
        section.set(SkillSetting.MAX_DISTANCE.node(), (Object)16);
        section.set(SkillSetting.TARGET_HIT_TOLERANCE.node(), (Object)0.4);
        return section;
    }

    @Override
    public void init() {
        String delayText = SkillConfigManager.getRaw((Skill)this, SkillSetting.DELAY_TEXT, ChatComponents.GENERIC_SKILL + "%hero% begins to use %skill% on %target%!");
        this.setDelayText(delayText.replace("%hero%", "$1").replace("%skill%", "$2").replace("%target%", "$3"));
        String interruptText = SkillConfigManager.getRaw((Skill)this, SkillSetting.INTERRUPT_TEXT, ChatComponents.GENERIC_SKILL + "%hero% stopped using %skill%!");
        this.setInterruptText(interruptText.replace("%hero%", "$1").replace("%skill%", "$2"));
        String useText = SkillConfigManager.getRaw((Skill)this, SkillSetting.USE_TEXT, ChatComponents.GENERIC_SKILL + "%hero% used %skill% on %target%!");
        this.setUseText(useText.replace("%hero%", "$1").replace("%skill%", "$2").replace("%target%", "$3"));
    }

    public Predicate<LivingEntity> getTargetFilter() {
        return this.targetFilter;
    }

    protected void setTargetFilter(Predicate<LivingEntity> entityFilter) {
        this.targetFilter = entityFilter != null ? entityFilter : t -> true;
    }

    @Deprecated
    public Predicate<Block> getBlockFilter() {
        return this.blockFilter;
    }

    @Deprecated
    protected void setBlockFilter(Predicate<Block> blockFilter) {
        this.blockFilter = blockFilter != null ? blockFilter : b -> true;
    }

    public abstract SkillResult use(Hero var1, LivingEntity var2, String[] var3);

    @Override
    public SkillResult use(Hero hero, String[] args) {
        Player player = hero.getPlayer();
        EnumSet<TargetingFlag> flags = EnumSet.noneOf(TargetingFlag.class);
        ArrayList<String> flaglessArgs = new ArrayList<String>(args.length);
        for (String arg : args) {
            TargetingFlag flag = TargetingFlag.parseFlag(arg);
            if (flag != null) {
                flags.add(flag);
                continue;
            }
            flaglessArgs.add(arg);
        }
        args = new String[flaglessArgs.size()];
        flaglessArgs.toArray(args);
        if (args.length < this.getMinArguments() || args.length > this.getMaxArguments()) {
            player.sendMessage(ChatColor.GRAY + "    Invalid argument range!");
            return SkillResult.INVALID_TARGET_NO_MSG;
        }
        LivingEntity target = null;
        NAMED_TARGETING_TYPE nameBindType = this.determineNamedTargetType(args);
        target = nameBindType != NAMED_TARGETING_TYPE.DISABLED ? this.getTarget(hero, flags, nameBindType, args[0]) : this.getTarget(hero, flags, nameBindType, null);
        if (target == null) {
            return SkillResult.INVALID_TARGET_NO_MSG;
        }
        SkillResult result = this.use(hero, target, args);
        if (result.equals(SkillResult.NORMAL)) {
            this.performPostSkillUseChecks(hero, target);
        }
        return result;
    }

    @Nonnull
    private NAMED_TARGETING_TYPE determineNamedTargetType(String[] args) {
        NAMED_TARGETING_TYPE nameBindType = NAMED_TARGETING_TYPE.DISABLED;
        if (args.length == 1) {
            boolean neutralEnabled = this.isType(SkillType.NAME_TARGETTING_ENABLED);
            boolean offensiveEnabled = this.isType(SkillType.OFFENSIVE_NAME_TARGETTING_ENABLED);
            boolean defensiveEnabled = this.isType(SkillType.DEFENSIVE_NAME_TARGETTING_ENABLED);
            if (neutralEnabled || offensiveEnabled && defensiveEnabled) {
                nameBindType = NAMED_TARGETING_TYPE.NEUTRAL;
            } else if (offensiveEnabled) {
                nameBindType = NAMED_TARGETING_TYPE.OFFENSIVE;
            } else if (defensiveEnabled) {
                nameBindType = NAMED_TARGETING_TYPE.DEFENSIVE;
            }
        }
        return nameBindType;
    }

    @Override
    protected boolean addDelayedSkill(Hero hero, int delay, String identifier, String[] args) {
        Player player = hero.getPlayer();
        EnumSet<TargetingFlag> flags = EnumSet.noneOf(TargetingFlag.class);
        ArrayList<String> flaglessArgs = new ArrayList<String>(args.length);
        for (String arg : args) {
            TargetingFlag flag = TargetingFlag.parseFlag(arg);
            if (flag != null) {
                flags.add(flag);
                continue;
            }
            flaglessArgs.add(arg);
        }
        args = new String[flaglessArgs.size()];
        flaglessArgs.toArray(args);
        if (args.length < this.getMinArguments() || args.length > this.getMaxArguments()) {
            player.sendMessage(ChatColor.GRAY + "    Invalid argument range!");
            return false;
        }
        LivingEntity target = null;
        NAMED_TARGETING_TYPE nameBindType = this.determineNamedTargetType(args);
        target = args.length == 1 ? this.getTarget(hero, flags, nameBindType, args[0]) : this.getTarget(hero, flags, nameBindType, null);
        if (target == null) {
            return false;
        }
        DelayedTargettedSkill skill = new DelayedTargettedSkill(identifier, hero, delay, this, target, args, flags);
        String text = this.getDelayText();
        if (text != null && !text.isEmpty()) {
            if (hero.hasEffectType(EffectType.SILENT_ACTIONS)) {
                Messaging.send((CommandSender)player, "    " + text, player.getName(), this.getName(), CustomNameManager.getName((Entity)target));
            } else {
                this.broadcast(player.getLocation(), "    " + text, player.getName(), this.getName(), CustomNameManager.getName((Entity)target));
            }
        }
        this.plugin.getCharacterManager().queueDelayedSkill(skill);
        hero.setDelayedSkill(skill);
        return true;
    }

    private LivingEntity getNamedTarget(Hero hero, EnumSet<TargetingFlag> flags, NAMED_TARGETING_TYPE nameBindType, String name) {
        Player player = hero.getPlayer();
        Player namedTarget = this.plugin.getServer().getPlayer(name);
        if (namedTarget != null) {
            if (!player.getWorld().equals(namedTarget.getWorld())) {
                return null;
            }
            boolean canNameBindThisTarget = false;
            if (nameBindType == NAMED_TARGETING_TYPE.NEUTRAL) {
                canNameBindThisTarget = true;
            } else {
                boolean isAlliedTarget = hero.isAlliedTo((LivingEntity)namedTarget);
                boolean bl = canNameBindThisTarget = nameBindType == NAMED_TARGETING_TYPE.OFFENSIVE && !isAlliedTarget || nameBindType == NAMED_TARGETING_TYPE.DEFENSIVE && isAlliedTarget;
            }
            if (!canNameBindThisTarget) {
                return null;
            }
            double maxDist = this.calculateMaxDistance(hero);
            double maxDistSquared = maxDist * maxDist;
            if (player.getLocation().distanceSquared(namedTarget.getLocation()) <= maxDistSquared && this.getTargetFilter(hero, flags).test((Entity)namedTarget)) {
                return namedTarget;
            }
        }
        return null;
    }

    public SkillResult useDelayed(Hero hero, LivingEntity target, String[] args, EnumSet<TargetingFlag> flags) {
        if (!this.targetValidAfterDelay(hero, target, flags)) {
            return SkillResult.INVALID_TARGET_NO_MSG;
        }
        SkillResult result = this.use(hero, target, args);
        if (result.equals(SkillResult.NORMAL)) {
            this.performPostSkillUseChecks(hero, target);
        }
        return result;
    }

    private void performPostSkillUseChecks(Hero hero, LivingEntity target) {
        Hero tHero;
        CombatEffect.CombatReason reason;
        Player player = hero.getPlayer();
        if (this.isType(SkillType.AGGRESSIVE)) {
            if (hero.isInCombatWith(target)) {
                hero.refreshCombat();
            } else {
                CombatEffect.CombatReason reason2 = target instanceof Player ? CombatEffect.CombatReason.ATTACKED_PLAYER : CombatEffect.CombatReason.ATTACKED_MOB;
                this.plugin.getServer().getPluginManager().callEvent((Event)new HeroEnterCombatEvent(hero, target, reason2));
                hero.enterCombatWith(target, reason2);
            }
            if (target instanceof Player) {
                Hero targetHero = this.plugin.getCharacterManager().getHero((Player)target);
                if (targetHero.isInCombatWith((LivingEntity)player)) {
                    targetHero.refreshCombat();
                } else {
                    reason = CombatEffect.CombatReason.DAMAGED_BY_PLAYER;
                    this.plugin.getServer().getPluginManager().callEvent((Event)new HeroEnterCombatEvent(targetHero, (LivingEntity)player, reason));
                    targetHero.enterCombatWith((LivingEntity)player, reason);
                }
            }
        }
        if (this.isType(SkillType.MULTI_GRESSIVE)) {
            boolean aggressiveAction;
            boolean bl = aggressiveAction = !hero.isAlliedTo(target);
            if (aggressiveAction) {
                if (hero.isInCombatWith(target)) {
                    hero.refreshCombat();
                } else {
                    reason = target instanceof Player ? CombatEffect.CombatReason.ATTACKED_PLAYER : CombatEffect.CombatReason.ATTACKED_MOB;
                    this.plugin.getServer().getPluginManager().callEvent((Event)new HeroEnterCombatEvent(hero, target, reason));
                    hero.enterCombatWith(target, reason);
                }
                if (target instanceof Player) {
                    Hero targetHero = this.plugin.getCharacterManager().getHero((Player)target);
                    if (targetHero.isInCombatWith((LivingEntity)player)) {
                        targetHero.refreshCombat();
                    } else {
                        CombatEffect.CombatReason reason3 = CombatEffect.CombatReason.DAMAGED_BY_PLAYER;
                        this.plugin.getServer().getPluginManager().callEvent((Event)new HeroEnterCombatEvent(targetHero, (LivingEntity)player, reason3));
                        targetHero.enterCombatWith((LivingEntity)player, reason3);
                    }
                }
            }
        }
        if ((this.isType(SkillType.HEALING) || this.isType(SkillType.BUFFING)) && target instanceof Player && (tHero = this.plugin.getCharacterManager().getHero((Player)target)).isInCombat()) {
            Map<LivingEntity, CombatEffect.CombatReason> combatants = tHero.getCombatants();
            for (Map.Entry<LivingEntity, CombatEffect.CombatReason> combatant : combatants.entrySet()) {
                if (hero.isInCombatWith(combatant.getKey())) {
                    hero.refreshCombat();
                    continue;
                }
                CombatEffect.CombatReason originalReason = combatant.getValue();
                CombatEffect.CombatReason newReason = switch (originalReason) {
                    case CombatEffect.CombatReason.ATTACKED_PLAYER, CombatEffect.CombatReason.ATTACKED_MOB -> CombatEffect.CombatReason.BENEFIT_ATTACKER;
                    case CombatEffect.CombatReason.DAMAGED_BY_PLAYER, CombatEffect.CombatReason.DAMAGED_BY_MOB -> CombatEffect.CombatReason.BENEFIT_DEFENDER;
                    default -> CombatEffect.CombatReason.CUSTOM;
                };
                this.plugin.getServer().getPluginManager().callEvent((Event)new HeroEnterCombatEvent(hero, combatant.getKey(), newReason));
                hero.enterCombatWith(combatant.getKey(), newReason);
            }
        }
        if (this.isType(SkillType.INTERRUPTING) && target instanceof Player) {
            Hero tHero2 = this.plugin.getCharacterManager().getHero((Player)target);
            long interruptCooldown = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.ON_INTERRUPT_FORCE_COOLDOWN, 0, false);
            tHero2.interruptDelayedSkill(interruptCooldown);
        }
    }

    private double calculateMaxDistance(Hero hero) {
        double maxDistance = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE, 16.0, false);
        double agiDistBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE_INCREASE_PER_DEXTERITY, 0.0, false);
        double chaDistBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE_INCREASE_PER_CHARISMA, 0.0, false);
        double intDistBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE_INCREASE_PER_INTELLECT, 0.0, false);
        double strDistBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE_INCREASE_PER_STRENGTH, 0.0, false);
        double wisDistBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE_INCREASE_PER_WISDOM, 0.0, false);
        if (agiDistBonus > 0.0) {
            maxDistance += (double)hero.getAttributeValue(AttributeType.DEXTERITY) * agiDistBonus;
        }
        if (chaDistBonus > 0.0) {
            maxDistance += (double)hero.getAttributeValue(AttributeType.CHARISMA) * chaDistBonus;
        }
        if (intDistBonus > 0.0) {
            maxDistance += (double)hero.getAttributeValue(AttributeType.INTELLECT) * intDistBonus;
        }
        if (strDistBonus > 0.0) {
            maxDistance += (double)hero.getAttributeValue(AttributeType.STRENGTH) * strDistBonus;
        }
        if (wisDistBonus > 0.0) {
            maxDistance += (double)hero.getAttributeValue(AttributeType.WISDOM) * wisDistBonus;
        }
        return maxDistance;
    }

    private double calculateHitTolerance(Hero hero) {
        double hitTolerance = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.TARGET_HIT_TOLERANCE, 0.4, false);
        double agiTolBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.TARGET_HIT_TOLERANCE_INCREASE_PER_DEXTERITY, 0.0, false);
        double chaTolBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.TARGET_HIT_TOLERANCE_INCREASE_PER_CHARISMA, 0.0, false);
        double intTolBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.TARGET_HIT_TOLERANCE_INCREASE_PER_INTELLECT, 0.0, false);
        double strTolBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.TARGET_HIT_TOLERANCE_INCREASE_PER_STRENGTH, 0.0, false);
        double wisTolBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.TARGET_HIT_TOLERANCE_INCREASE_PER_WISDOM, 0.0, false);
        if (agiTolBonus > 0.0) {
            hitTolerance += (double)hero.getAttributeValue(AttributeType.DEXTERITY) * agiTolBonus;
        }
        if (chaTolBonus > 0.0) {
            hitTolerance += (double)hero.getAttributeValue(AttributeType.CHARISMA) * chaTolBonus;
        }
        if (intTolBonus > 0.0) {
            hitTolerance += (double)hero.getAttributeValue(AttributeType.INTELLECT) * intTolBonus;
        }
        if (strTolBonus > 0.0) {
            hitTolerance += (double)hero.getAttributeValue(AttributeType.STRENGTH) * strTolBonus;
        }
        if (wisTolBonus > 0.0) {
            hitTolerance += (double)hero.getAttributeValue(AttributeType.WISDOM) * wisTolBonus;
        }
        return hitTolerance;
    }

    private static LivingEntity rayCastTarget(Player player, double maxDistance, double hitTolerance, Set<TargetingFlag> flags, RayCastInfo rayCastInfo, boolean replaceEntityFilter) {
        RayCastInfo appliedRayCastInfo;
        if (maxDistance <= 0.0) {
            return null;
        }
        World world = player.getWorld();
        Location eyeLocation = player.getEyeLocation();
        Vector normal = eyeLocation.getDirection();
        Vector start = eyeLocation.toVector();
        Vector end = normal.clone().multiply(maxDistance).add(start);
        if (replaceEntityFilter) {
            appliedRayCastInfo = rayCastInfo.copy();
            appliedRayCastInfo.setEntityFilter(new Predicate<Entity>(){
                final Predicate<Entity> originalEntityFilter;
                {
                    this.originalEntityFilter = appliedRayCastInfo.getEntityFilter();
                }

                @Override
                public boolean test(Entity possibleTarget) {
                    if (possibleTarget instanceof LivingEntity) {
                        return (possibleTarget.isDead() || ((LivingEntity)possibleTarget).getHealth() == 0.0) && this.originalEntityFilter.test(possibleTarget);
                    }
                    return false;
                }
            });
        } else {
            appliedRayCastInfo = rayCastInfo;
        }
        if (hitTolerance <= 0.0) {
            RayCastHit hit = physics.rayCast(world, (Entity)player, start, end, appliedRayCastInfo);
            if (hit != null) {
                if (hit.isEntity()) {
                    return (LivingEntity)hit.getEntity();
                }
                return null;
            }
            return null;
        }
        RayCastHit hit = physics.rayCast(world, (Entity)player, start, end, appliedRayCastInfo);
        if (hit != null) {
            if (hit.isEntity() && hit.getEntity() != player) {
                return (LivingEntity)hit.getEntity();
            }
            if (!hit.isEntity()) {
                end = hit.getPoint();
            }
        }
        Capsule capsule = physics.createCapsule(start, end, hitTolerance);
        final Capsule offsetCapsule = capsule.offset(normal.clone().multiply(hitTolerance));
        final Sphere maxDistanceSphere = physics.createSphere(start, maxDistance);
        List<Entity> possibleTargets = physics.getEntitiesInVolume(world, (Entity)player, (ColliderVolume)capsule, new Predicate<Entity>(){

            @Override
            public boolean test(Entity entity) {
                AABB entityAABB = physics.getEntityAABB(entity);
                return maxDistanceSphere.overlapsWithAABB(entityAABB, true) && offsetCapsule.overlapsWithAABB(entityAABB, true) && appliedRayCastInfo.getEntityFilter().test(entity);
            }
        });
        Entity currentTarget = null;
        double currentDistanceSq = 2.147483647E9;
        Vector origin = capsule.getPoint1();
        Vector capsuleRay = capsule.getPoint2().subtract(origin);
        double capsuleLengthSq = capsuleRay.lengthSquared();
        boolean canTargetSelf = appliedRayCastInfo.getEntityFilter().test((Entity)player);
        for (Entity possibleTarget : possibleTargets) {
            Vector closestPoint;
            if (canTargetSelf && possibleTarget.equals(player)) continue;
            AABB entityAABB = physics.getEntityAABB(possibleTarget);
            Vector entityCenter = entityAABB.getCenter();
            Vector entityRay = entityCenter.clone().subtract(origin);
            double dot = capsuleRay.dot(entityRay);
            Vector vector = dot < capsuleLengthSq ? capsuleRay.clone().multiply(dot / capsuleLengthSq) : capsuleRay.clone();
            Vector closestPointRay = vector;
            double distanceSq = closestPointRay.lengthSquared();
            if (!(distanceSq < currentDistanceSq) || (hit = physics.rayCastBlocks(world, entityCenter, closestPoint = closestPointRay.clone().add(origin), appliedRayCastInfo)) != null && !hit.getPoint().equals((Object)closestPoint)) continue;
            currentTarget = possibleTarget;
            currentDistanceSq = distanceSq;
        }
        if (currentTarget != null) {
            return (LivingEntity)currentTarget;
        }
        return canTargetSelf ? player : null;
    }

    public static LivingEntity rayCastTarget(Player player, double maxDistance, double hitTolerance, Set<TargetingFlag> flags, RayCastInfo rayCastInfo) {
        return TargettedSkill.rayCastTarget(player, maxDistance, hitTolerance, flags, rayCastInfo, true);
    }

    private LivingEntity getRaycastedTarget(Hero hero, EnumSet<TargetingFlag> flags) {
        double maxDistance = this.calculateMaxDistance(hero);
        double hitTolerance = this.calculateHitTolerance(hero);
        RayCastInfo rayCastInfo = new RayCastInfo();
        rayCastInfo.setBlockFilter(this.blockFilter);
        rayCastInfo.setEntityFilter(this.getTargetFilter(hero, flags));
        return TargettedSkill.rayCastTarget(hero.getPlayer(), maxDistance, hitTolerance, flags, rayCastInfo, false);
    }

    private Predicate<Entity> getTargetFilter(final Hero hero, final EnumSet<TargetingFlag> flags) {
        return new Predicate<Entity>(){

            @Override
            public boolean test(Entity possibleTarget) {
                HumanEntity humanTarget;
                if (TargettedSkill.this.isType(SkillType.NO_SELF_TARGETTING) && possibleTarget.equals(hero.getPlayer())) {
                    return false;
                }
                if (possibleTarget instanceof ArmorStand) {
                    return false;
                }
                if (possibleTarget instanceof HumanEntity && ((humanTarget = (HumanEntity)possibleTarget).getGameMode() == GameMode.SPECTATOR || humanTarget.getGameMode() == GameMode.CREATIVE)) {
                    return false;
                }
                if (possibleTarget instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)possibleTarget;
                    if (target.isDead() || target.getHealth() == 0.0) {
                        return false;
                    }
                    CharacterTemplate targetCharacter = TargettedSkill.this.plugin.getCharacterManager().getCharacter(target);
                    if (targetCharacter.hasEffectType(EffectType.UNTARGETABLE)) {
                        return false;
                    }
                    boolean isAlly = hero.isAlliedTo(target);
                    if (isAlly && (flags.contains((Object)TargetingFlag.TARGET_ENEMY) || TargettedSkill.this.isType(SkillType.AGGRESSIVE))) {
                        return false;
                    }
                    if (!isAlly && (TargettedSkill.this.isType(SkillType.HEALING) || TargettedSkill.this.isType(SkillType.BUFFING) || flags.contains((Object)TargetingFlag.TARGET_ALLY))) {
                        return false;
                    }
                    return TargettedSkill.this.targetFilter.test(target);
                }
                return false;
            }
        };
    }

    private LivingEntity getTarget(Hero hero, EnumSet<TargetingFlag> flags, NAMED_TARGETING_TYPE nameBindType, String nameTargetOverride) {
        Player target;
        Player player = hero.getPlayer();
        if (this.targetingParadox(player, flags)) {
            return null;
        }
        this.redundantTargeting(player, flags);
        if (flags.contains((Object)TargetingFlag.TARGET_SELF)) {
            target = player;
        } else {
            target = nameTargetOverride != null ? this.getNamedTarget(hero, flags, nameBindType, nameTargetOverride) : this.getRaycastedTarget(hero, flags);
            if (target == null && !flags.contains((Object)TargetingFlag.TARGET_OTHER) && this.isType(SkillType.NO_SELF_TARGETTING) && this.isType(SkillType.AGGRESSIVE)) {
                target = player;
            }
        }
        if (target != null) {
            if (!player.equals(target) && hero.hasEffectType(EffectType.BLIND)) {
                player.sendMessage(ChatColor.GRAY + "    You can't target anything while blinded!");
                return null;
            }
            boolean damageCheck = false;
            if (this.isType(SkillType.AGGRESSIVE)) {
                damageCheck = true;
            } else if (this.isType(SkillType.MULTI_GRESSIVE)) {
                boolean bl = damageCheck = !hero.isAlliedTo((LivingEntity)target);
            }
            if (damageCheck) {
                if (hero.hasEffectType(EffectType.INVULNERABILITY)) {
                    player.sendMessage(ChatColor.GRAY + "    You cannot damage that target while invulnerable!");
                    return null;
                }
                if (!TargettedSkill.damageCheck(player, (LivingEntity)target)) {
                    player.sendMessage(ChatColor.GRAY + "    You cannot damage that target right now!");
                    return null;
                }
            }
        }
        return target;
    }

    private boolean targetingParadox(Player player, EnumSet<TargetingFlag> flags) {
        boolean paradox = false;
        if (flags.contains((Object)TargetingFlag.TARGET_SELF) && flags.contains((Object)TargetingFlag.TARGET_OTHER)) {
            player.sendMessage(ChatColor.RED + "    Targeting paradox( flag-" + TargetingFlag.TARGET_SELF + " : flag-" + TargetingFlag.TARGET_OTHER + " )!");
            paradox = true;
        }
        if (flags.contains((Object)TargetingFlag.TARGET_SELF) && flags.contains((Object)TargetingFlag.TARGET_ENEMY)) {
            player.sendMessage(ChatColor.RED + "    Targeting paradox( flag-" + TargetingFlag.TARGET_SELF + " : flag-" + TargetingFlag.TARGET_ENEMY + " )!");
            paradox = true;
        }
        if (flags.contains((Object)TargetingFlag.TARGET_ALLY) && flags.contains((Object)TargetingFlag.TARGET_ENEMY)) {
            player.sendMessage(ChatColor.RED + "    Targeting paradox( flag-" + TargetingFlag.TARGET_ALLY + " : flag-" + TargetingFlag.TARGET_ENEMY + " )!");
            paradox = true;
        }
        if (flags.contains((Object)TargetingFlag.TARGET_SELF) && this.isType(SkillType.AGGRESSIVE)) {
            player.sendMessage(ChatColor.RED + "    Targeting paradox( flag-" + TargetingFlag.TARGET_SELF + " : type-" + SkillType.AGGRESSIVE + " )!");
            paradox = true;
        }
        if (flags.contains((Object)TargetingFlag.TARGET_SELF) && this.isType(SkillType.NO_SELF_TARGETTING)) {
            player.sendMessage(ChatColor.RED + "    Targeting paradox( flag-" + TargetingFlag.TARGET_SELF + " : type-" + SkillType.NO_SELF_TARGETTING + " )!");
            paradox = true;
        }
        return paradox;
    }

    private void redundantTargeting(Player player, EnumSet<TargetingFlag> flags) {
        if (flags.contains((Object)TargetingFlag.POINT_PRIORITY) && flags.contains((Object)TargetingFlag.TARGET_SELF)) {
            player.sendMessage(ChatColor.GRAY + "    Redundant targeting ( flag-" + TargetingFlag.POINT_PRIORITY + " : flag-" + TargetingFlag.TARGET_SELF + " )!");
        }
        if (flags.contains((Object)TargetingFlag.TARGET_ALLY) && flags.contains((Object)TargetingFlag.TARGET_SELF)) {
            player.sendMessage(ChatColor.GRAY + "    Redundant targeting ( flag-" + TargetingFlag.TARGET_ALLY + " : flag-" + TargetingFlag.TARGET_SELF + " )!");
        }
        if (flags.contains((Object)TargetingFlag.TARGET_OTHER) && flags.contains((Object)TargetingFlag.TARGET_ENEMY)) {
            player.sendMessage(ChatColor.GRAY + "    Redundant targeting ( flag-" + TargetingFlag.TARGET_OTHER + " : flag-" + TargetingFlag.TARGET_ENEMY + " )!");
        }
    }

    private boolean targetValidAfterDelay(Hero hero, LivingEntity target, EnumSet<TargetingFlag> flags) {
        Player player = hero.getPlayer();
        if (target.isDead() || target.getHealth() == 0.0) {
            player.sendMessage(ChatColor.GRAY + "    The target has died!");
            return false;
        }
        if (!player.equals(target)) {
            if (hero.hasEffectType(EffectType.BLIND)) {
                player.sendMessage(ChatColor.GRAY + "    You can't target anything while blinded!");
                return false;
            }
            if (!target.getLocation().getWorld().equals(player.getLocation().getWorld())) {
                player.sendMessage(ChatColor.GRAY + "    Target is no longer in the same dimension!");
                return false;
            }
            AABB targetAABB = physics.getEntityAABB((Entity)target);
            Sphere maxRangeSphere = physics.createSphere(player.getEyeLocation().toVector(), this.calculateMaxDistance(hero));
            if (!maxRangeSphere.overlapsWithAABB(targetAABB)) {
                player.sendMessage(ChatColor.GRAY + "    Target is no longer in range!");
                return false;
            }
            CharacterTemplate targetCharacter = this.plugin.getCharacterManager().getCharacter(target);
            if (targetCharacter.hasEffectType(EffectType.UNTARGETABLE)) {
                player.sendMessage(ChatColor.GRAY + "    Target is no longer targetable!");
            }
            if (target instanceof Player) {
                Hero targetHero = (Hero)targetCharacter;
                if (hero.hasParty() && hero.getParty().isPartyMember(targetHero)) {
                    if (flags.contains((Object)TargetingFlag.TARGET_ENEMY)) {
                        player.sendMessage(ChatColor.GRAY + "    Target player is no longer an enemy!");
                        return false;
                    }
                    if (hero.getParty().isNoPvp().booleanValue() && this.isType(SkillType.AGGRESSIVE)) {
                        player.sendMessage(ChatColor.GRAY + "    You can no longer damage target player!");
                        return false;
                    }
                } else if (flags.contains((Object)TargetingFlag.TARGET_ALLY)) {
                    player.sendMessage(ChatColor.GRAY + "    Target player is no longer in your party!");
                    return false;
                }
            }
        }
        boolean damageCheck = false;
        if (this.isType(SkillType.AGGRESSIVE)) {
            damageCheck = true;
        } else if (this.isType(SkillType.MULTI_GRESSIVE)) {
            boolean bl = damageCheck = !hero.isAlliedTo(target);
        }
        if (damageCheck) {
            if (hero.hasEffectType(EffectType.INVULNERABILITY)) {
                player.sendMessage(ChatColor.GRAY + "    You cannot harm that " + (target instanceof Player ? "player" : "target") + " while invulnerable!");
                return false;
            }
            if (!TargettedSkill.damageCheck(player, target)) {
                player.sendMessage(ChatColor.GRAY + "    You cannot harm that " + (target instanceof Player ? "player" : "target") + " right now!");
                return false;
            }
        }
        return true;
    }

    protected void broadcastExecuteText(Hero hero, LivingEntity target) {
        Player player = hero.getPlayer();
        String text = this.getUseText();
        if (text != null && !text.isEmpty()) {
            if (hero.hasEffectType(EffectType.SILENT_ACTIONS)) {
                Messaging.send((CommandSender)player, "    " + text, player.getName(), this.getName(), target.equals(player) ? "themself" : CustomNameManager.getName((Entity)target));
            } else {
                this.broadcast(player.getLocation(), "    " + text, player.getName(), this.getName(), target.equals(player) ? "themself" : CustomNameManager.getName((Entity)target));
            }
        }
    }

    public static enum NAMED_TARGETING_TYPE {
        DISABLED,
        NEUTRAL,
        DEFENSIVE,
        OFFENSIVE;

    }
}

