/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.nms.physics.RayCastHit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public abstract class TargettedLocationSkill
extends ActiveSkill {
    protected final NMSPhysics physics = NMSPhysics.instance();
    public static final String ALLOW_TARGET_AIR_BLOCK_NODE = "target-air-block-is-allowed";
    public static final String TRY_GET_SOLID_BELOW_BLOCK_NODE = "try-get-solid-below-block";
    public static final String MAXIMUM_FIND_SOLID_BELOW_BLOCK_HEIGHT_NODE = "maximum-find-solid-below-block-height";
    public static final String IF_HIT_SOLID_GET_AIR_ABOVE = "if-hit-solid-get-air-above";

    public TargettedLocationSkill(Heroes plugin, String name) {
        super(plugin, name);
    }

    @Override
    public String getDescription(Hero hero) {
        return super.getDescription();
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection config = super.getDefaultConfig();
        config.set(SkillSetting.MAX_DISTANCE.node(), (Object)12.0);
        config.set(ALLOW_TARGET_AIR_BLOCK_NODE, (Object)true);
        config.set(TRY_GET_SOLID_BELOW_BLOCK_NODE, (Object)false);
        config.set(IF_HIT_SOLID_GET_AIR_ABOVE, (Object)true);
        config.set(MAXIMUM_FIND_SOLID_BELOW_BLOCK_HEIGHT_NODE, (Object)0.0);
        return config;
    }

    @Override
    public SkillResult use(Hero hero, String[] args) {
        Block aboveSolid;
        Player player = hero.getPlayer();
        if (args.length < this.getMinArguments() || args.length > this.getMaxArguments()) {
            player.sendMessage(ChatColor.GRAY + "    Invalid argument range!");
            return SkillResult.INVALID_TARGET_NO_MSG;
        }
        if (hero.hasEffectType(EffectType.BLIND)) {
            player.sendMessage(ChatColor.GRAY + "    You can't target anything while blinded!");
            return SkillResult.FAIL;
        }
        double maxDist = this.calculateMaxDistance(hero);
        boolean tryGetSolidBelowBlock = SkillConfigManager.getUseSetting(hero, (Skill)this, TRY_GET_SOLID_BELOW_BLOCK_NODE, false);
        boolean getAboveBlock = SkillConfigManager.getUseSetting(hero, (Skill)this, IF_HIT_SOLID_GET_AIR_ABOVE, false);
        boolean allowEmptyBlocks = SkillConfigManager.getUseSetting(hero, (Skill)this, ALLOW_TARGET_AIR_BLOCK_NODE, true);
        Block targetBlock = null;
        if (tryGetSolidBelowBlock) {
            targetBlock = this.getTarget(player, maxDist, true);
            if (targetBlock == null) {
                return SkillResult.INVALID_TARGET;
            }
            if (targetBlock.isEmpty()) {
                double searchDist = SkillConfigManager.getUseSetting(hero, (Skill)this, MAXIMUM_FIND_SOLID_BELOW_BLOCK_HEIGHT_NODE, 6.0, false);
                Block belowSolid = this.getSolidBlockBeneathTarget(player, targetBlock, (int)searchDist);
                if (belowSolid == null || belowSolid.isEmpty() && !allowEmptyBlocks) {
                    return SkillResult.INVALID_TARGET;
                }
                targetBlock = belowSolid;
            }
        } else {
            targetBlock = this.getTarget(player, maxDist, allowEmptyBlocks);
        }
        if (targetBlock == null || targetBlock.isEmpty() && !allowEmptyBlocks) {
            return SkillResult.INVALID_TARGET;
        }
        if (!targetBlock.isEmpty() && getAboveBlock && (aboveSolid = targetBlock.getRelative(BlockFace.UP)).isEmpty()) {
            targetBlock = aboveSolid;
        }
        return this.use(hero, targetBlock.getLocation(), args);
    }

    public abstract SkillResult use(Hero var1, Location var2, String[] var3);

    private double calculateMaxDistance(Hero hero) {
        double maxDistance = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE, 12.0, false);
        double agiDistBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE_INCREASE_PER_DEXTERITY, 0.0, false);
        double chaDistBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE_INCREASE_PER_CHARISMA, 0.0, false);
        double intDistBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE_INCREASE_PER_INTELLECT, 0.0, false);
        double strDistBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE_INCREASE_PER_STRENGTH, 0.0, false);
        double wisDistBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE_INCREASE_PER_WISDOM, 0.0, false);
        if (agiDistBonus > 0.0) {
            maxDistance += (double)hero.getAttributeValue(AttributeType.DEXTERITY) * agiDistBonus;
        }
        if (chaDistBonus > 0.0) {
            maxDistance += (double)hero.getAttributeValue(AttributeType.CHARISMA) * chaDistBonus;
        }
        if (intDistBonus > 0.0) {
            maxDistance += (double)hero.getAttributeValue(AttributeType.INTELLECT) * intDistBonus;
        }
        if (strDistBonus > 0.0) {
            maxDistance += (double)hero.getAttributeValue(AttributeType.STRENGTH) * strDistBonus;
        }
        if (wisDistBonus > 0.0) {
            maxDistance += (double)hero.getAttributeValue(AttributeType.WISDOM) * wisDistBonus;
        }
        return maxDistance;
    }

    protected Block getTarget(Player player, double maxDist, boolean allowEmpty) {
        World world = player.getWorld();
        Location eyeLocation = player.getEyeLocation();
        Vector normal = eyeLocation.getDirection();
        Vector start = eyeLocation.toVector();
        Vector end = normal.clone().multiply(maxDist).add(start);
        RayCastHit hit = this.physics.rayCast(world, (Entity)player, start, end);
        return this.convertHitToBlock(hit, world, end, allowEmpty);
    }

    protected Block getTarget(Block castLocation, Vector direction, double maxDist, boolean allowEmpty) {
        World world = castLocation.getWorld();
        Vector start = castLocation.getLocation().toVector();
        Vector end = direction.clone().multiply(maxDist).add(start);
        RayCastHit hit = this.physics.rayCast(world, start, end);
        return this.convertHitToBlock(hit, world, end, allowEmpty);
    }

    protected Block getSolidBlockBeneathTarget(Player player, Block startBlock, int height) {
        if (startBlock.isEmpty()) {
            Block targetBlock = this.getTarget(startBlock, new Vector(0, -1, 0), height, false);
            if (targetBlock == null) {
                return null;
            }
            return targetBlock;
        }
        return startBlock;
    }

    private Block convertHitToBlock(RayCastHit hit, World world, Vector end, boolean allowEmpty) {
        Block targetBlock;
        if (hit == null) {
            targetBlock = world.getBlockAt(end.getBlockX(), end.getBlockY(), end.getBlockZ());
        } else {
            Block block = targetBlock = hit.isEntity() ? hit.getEntity().getLocation().getBlock() : hit.getBlock(world);
        }
        if (targetBlock == null) {
            return null;
        }
        if (!allowEmpty && targetBlock.isEmpty()) {
            return null;
        }
        return targetBlock;
    }
}

