/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillRegistrar;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.PotionSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SkillManager
extends URLClassLoader {
    private final Map<String, Skill> skills = new LinkedHashMap<String, Skill>();
    private final Map<String, Skill> identifiers = new HashMap<String, Skill>();
    private final Map<String, File> skillFiles = new HashMap<String, File>();
    private final Heroes plugin;
    private final File dir;

    public SkillManager(Heroes plugin) {
        super(((URLClassLoader)((Object)((Object)plugin)).getClass().getClassLoader()).getURLs(), ((Object)((Object)plugin)).getClass().getClassLoader());
        this.plugin = plugin;
        this.dir = new File(plugin.getDataFolder(), "skills");
        this.dir.mkdir();
        if (this.getClass().getConstructors().length > 1) {
            return;
        }
        for (String skillFile : this.dir.list()) {
            if (!skillFile.contains(".jar")) continue;
            File file = new File(this.dir, skillFile);
            String name = skillFile.toLowerCase().replace(".jar", "").replace("skill", "");
            if (this.skillFiles.containsKey(name)) {
                Heroes.log(Level.SEVERE, "Duplicate skill jar found! Please remove " + skillFile + " or " + this.skillFiles.get(name).getName());
                continue;
            }
            this.skillFiles.put(name, file);
            try {
                this.addURL(file.toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public void addSkill(Skill skill) {
        this.skills.put(skill.getName().toLowerCase().replace("skill", ""), skill);
        for (String ident : skill.getIdentifiers()) {
            this.identifiers.put(ident.toLowerCase(), skill);
        }
    }

    public Skill getSkill(String name) {
        if (name == null) {
            return null;
        }
        if (!this.isLoaded(name = name.toLowerCase()) && this.skillFiles.containsKey(name)) {
            this.loadSkill(name);
        }
        return this.skills.get(name);
    }

    public boolean loadOutsourcedSkill(String name) {
        if (name == null || this.skills.get(name.toLowerCase()) != null) {
            return true;
        }
        OutsourcedSkill skill = new OutsourcedSkill(this.plugin, name);
        ConfigurationSection config = SkillConfigManager.outsourcedSkillConfig.getConfigurationSection(skill.getName());
        List perms = new ArrayList();
        if (config != null) {
            perms = config.getStringList("permissions");
        }
        if (perms.isEmpty()) {
            Heroes.log(Level.SEVERE, "There are no permissions defined for " + skill.getName());
            return false;
        }
        skill.setPermissions(perms.toArray(new String[perms.size()]));
        skill.setUsage(config.getString("usage"));
        skill.setDescription(config.getString("usage"));
        this.skills.put(name.toLowerCase(), skill);
        return true;
    }

    public boolean loadPotionSkill(String name) {
        if (name == null) {
            return false;
        }
        if (!(this.skills.get(name.toLowerCase()) instanceof PotionSkill)) {
            Heroes.log(Level.WARNING, "Potion skill of " + name + " has same name as other skill! Skipping loading..");
            return false;
        }
        ConfigurationSection config = SkillConfigManager.potionSkillConfig.getConfigurationSection(name);
        List potionEffectStrings = new ArrayList();
        if (config != null) {
            potionEffectStrings = config.getStringList("potions");
        }
        if (config == null || potionEffectStrings.isEmpty()) {
            Heroes.log(Level.SEVERE, "There are no potion effects defined for " + name);
            return false;
        }
        long period = config.getInt("period", 60000);
        int periodTicks = (int)(20.0 * ((double)period / 1000.0));
        boolean ambient = config.getBoolean("is-ambient", true);
        boolean hasParticles = config.getBoolean("has-particles", true);
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        for (String potionEffectString : potionEffectStrings) {
            String[] values = potionEffectString.split(":");
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)values[0]);
            if (potionEffectType == null) {
                Heroes.log(Level.WARNING, "Invalid potion effect type '" + values[0] + "' defined for " + name + ". Skipping potion effect.");
                continue;
            }
            int amplifier = 1;
            if (values.length > 1) {
                try {
                    amplifier = Integer.parseInt(values[1]);
                }
                catch (NumberFormatException e) {
                    Heroes.log(Level.WARNING, "Invalid amplifier defined for potion effect '" + potionEffectType.getName() + "' for " + name + ". Using default amplifier of 1.");
                }
            }
            potionEffects.add(new PotionEffect(potionEffectType, periodTicks, amplifier, ambient, hasParticles));
        }
        if (potionEffects.isEmpty()) {
            Heroes.log(Level.SEVERE, "There are no valid potion effects defined for " + name);
            return false;
        }
        PotionSkill skill = new PotionSkill(this.plugin, name, period, potionEffects);
        skill.setDescription(config.getString(String.valueOf((Object)SkillSetting.DESCRIPTION)));
        this.skills.put(name.toLowerCase(), skill);
        return true;
    }

    public Skill getSkillFromIdent(String identifier, CommandSender executor) {
        if (this.identifiers.get(identifier.toLowerCase()) == null) {
            for (Skill skill : this.skills.values()) {
                if (!skill.isIdentifier(executor, identifier)) continue;
                return skill;
            }
        }
        return this.identifiers.get(identifier.toLowerCase());
    }

    public Collection<Skill> getSkills() {
        return Collections.unmodifiableCollection(this.skills.values());
    }

    public boolean isLoaded(String name) {
        return this.skills.containsKey(name.toLowerCase());
    }

    private String internSkillErrorMessage(String className, String helpfulError) {
        return String.format("Unable to load skill in %s -- %s Was there a Heroes update?", className, helpfulError);
    }

    private String externSkillErrorMessage(String classSimpleName, Plugin plugin, String helpfulError) {
        return String.format("Unable to load skill %s from plugin %s v%s -- %s", classSimpleName, plugin.getName(), plugin.getDescription().getVersion(), helpfulError);
    }

    public Skill loadSkill(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            String mainClass = null;
            String skillVersion = null;
            while (entries.hasMoreElements()) {
                JarEntry element = entries.nextElement();
                if (!element.getName().equalsIgnoreCase("skill.info")) continue;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(element)));){
                    String[] splittedLine = reader.readLine().split(",");
                    mainClass = splittedLine[0].substring(12);
                    if (splittedLine.length <= 1) break;
                    skillVersion = splittedLine[1].substring(9);
                    break;
                }
            }
            if (mainClass != null) {
                Class<?> clazz = Class.forName(mainClass, true, this);
                if (Modifier.isAbstract(clazz.getModifiers())) {
                    jarFile.close();
                    return null;
                }
                Class<Skill> skillClass = clazz.asSubclass(Skill.class);
                Constructor<Skill> ctor = skillClass.getConstructor(((Object)((Object)this.plugin)).getClass());
                Skill skill = ctor.newInstance(new Object[]{this.plugin});
                this.plugin.getSkillConfigs().loadSkillDefaults(skill);
                skill.init();
                jarFile.close();
                if (skillVersion != null && !skillVersion.isEmpty()) {
                    skill.setVersion(skillVersion);
                }
                return skill;
            }
            jarFile.close();
            throw new IllegalArgumentException();
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            Heroes.log(Level.WARNING, "Unable to load " + file.getName() + " skill was written for a previous Heroes version, please check the debug.log for more information!");
            if (Heroes.properties.debug) {
                Heroes.debugThrow(this.getClass().toString(), "loadSkill", e);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            Heroes.log(Level.SEVERE, "Could not detect the proper Skill class to load for: " + file.getName());
            return null;
        }
        catch (Exception e) {
            Heroes.log(Level.WARNING, "The skill " + file.getName() + " failed to load for an unknown reason.");
            if (Heroes.properties.debug) {
                Heroes.debugLog.getLogger().throwing(this.getClass().getName(), "loadSkill", e);
            }
            return null;
        }
    }

    public Skill loadExternSkill(Plugin registeringPlugin, Class<? extends Skill> clazz) {
        try {
            return this.initSkill(clazz);
        }
        catch (InstantiationException e) {
            Heroes.log(Level.WARNING, this.externSkillErrorMessage(clazz.getSimpleName(), registeringPlugin, "Exception in constructor, or proper constructor not found."));
            Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
            Heroes.debugThrow(this.getClass().toString(), "loadSkills", e);
        }
        catch (InvocationTargetException e) {
            Heroes.log(Level.WARNING, this.externSkillErrorMessage(clazz.getSimpleName(), registeringPlugin, "Exception in constructor."));
            Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
            Heroes.debugThrow(this.getClass().toString(), "loadSkills", e);
        }
        catch (NoSuchMethodException e) {
            Heroes.log(Level.WARNING, this.externSkillErrorMessage(clazz.getSimpleName(), registeringPlugin, "Proper skill constructor not found. Was there a Heroes update?"));
            Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
            Heroes.debugThrow(this.getClass().toString(), "loadSkills", e);
        }
        catch (NoClassDefFoundError e) {
            Heroes.log(Level.WARNING, this.externSkillErrorMessage(clazz.getSimpleName(), registeringPlugin, "Skill is expecting different Heroes version"));
            Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
            Heroes.debugThrow(this.getClass().toString(), "loadSkills", e);
        }
        catch (Exception e) {
            Heroes.log(Level.WARNING, this.externSkillErrorMessage(clazz.getSimpleName(), registeringPlugin, String.format("Unknown error (%s: %s)", e.getClass().getName(), e.getMessage())));
            Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
            Heroes.debugThrow(this.getClass().toString(), "loadSkills", e);
        }
        return null;
    }

    private Skill initSkill(Class<? extends Skill> skillClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Constructor<? extends Skill> ctor = skillClass.getConstructor(((Object)((Object)this.plugin)).getClass());
        Skill skill = ctor.newInstance(new Object[]{this.plugin});
        this.plugin.getSkillConfigs().loadSkillDefaults(skill);
        skill.init();
        return skill;
    }

    public void loadSkills() {
        Skill skill;
        for (Map.Entry<String, File> entry : this.skillFiles.entrySet()) {
            if (this.isLoaded(entry.getKey()) || (skill = this.loadSkill(entry.getValue())) == null) continue;
            this.addSkill(skill);
            if (!Heroes.properties.debug) continue;
            Heroes.debugLog(Level.INFO, "Skill " + skill.getName() + " Loaded");
        }
        for (SkillRegistrar.Pair pair : SkillRegistrar.getRegisteredSkillClasses()) {
            skill = this.loadExternSkill((Plugin)pair.getLeft(), (Class)pair.getRight());
            if (skill == null) continue;
            this.addSkill(skill);
            if (!Heroes.properties.debug) continue;
            Heroes.debugLog(Level.INFO, "Skill " + skill.getName() + " Loaded");
        }
        SkillRegistrar.stopRegistration();
    }

    public void removeSkill(Skill skill) {
        this.skills.put(skill.getName().toLowerCase().replace("skill", ""), skill);
        for (String identifier : skill.getIdentifiers()) {
            this.identifiers.remove(identifier.toLowerCase());
        }
    }

    private boolean loadSkill(String name) {
        if (this.isLoaded(name)) {
            return true;
        }
        Skill skill = this.loadSkill(this.skillFiles.get(name.toLowerCase()));
        if (skill == null) {
            return false;
        }
        this.addSkill(skill);
        return true;
    }
}

