/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.Skill;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class SkillListInfo {
    protected final HeroClass heroClass;
    protected final Skill skill;

    public SkillListInfo(HeroClass heroClass, Skill skill) {
        this.heroClass = heroClass;
        this.skill = skill;
    }

    public int hashCode() {
        return 3 + this.heroClass.hashCode() * 17 + this.skill.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SkillListInfo)) {
            return false;
        }
        SkillListInfo that = (SkillListInfo)other;
        return that.heroClass.equals(this.heroClass) && that.skill.equals(this.skill);
    }

    public HeroClass getHeroClass() {
        return this.heroClass;
    }

    public Skill getSkill() {
        return this.skill;
    }

    public static SortedSet<Map.Entry<SkillListInfo, Integer>> entriesSortedByValues(Map<SkillListInfo, Integer> map) {
        TreeSet<Map.Entry<SkillListInfo, Integer>> sortedEntries = new TreeSet<Map.Entry<SkillListInfo, Integer>>(new Comparator<Map.Entry<SkillListInfo, Integer>>(){

            @Override
            public int compare(Map.Entry<SkillListInfo, Integer> e1, Map.Entry<SkillListInfo, Integer> e2) {
                int res = e1.getValue().compareTo(e2.getValue());
                if (res == 0) {
                    return e1.getKey().skill.getName().compareTo(e2.getKey().skill.getName());
                }
                return res;
            }
        });
        sortedEntries.addAll(map.entrySet());
        return sortedEntries;
    }
}

