/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.items.ComplexItemMatcher;
import com.herocraftonline.heroes.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;

public class SkillConfigManager {
    public static Configuration outsourcedSkillConfig;
    public static Configuration potionSkillConfig;
    public static Configuration standardSkillConfig;
    public static Configuration defaultSkillConfig;
    public static File dataFolder;
    public static Map<String, Configuration> classSkillConfigs;
    public static File skillConfigFile;
    public static File outsourcedSkillConfigFile;
    public static File potionSkillConfigFile;

    public SkillConfigManager(Heroes plugin) {
        dataFolder = plugin.getDataFolder();
        skillConfigFile = new File(dataFolder, "skills.yml");
        outsourcedSkillConfigFile = new File(dataFolder, "permission-skills.yml");
        plugin.getConfigManager().checkForConfig(outsourcedSkillConfigFile);
        potionSkillConfigFile = new File(dataFolder, "potion-skills.yml");
        plugin.getConfigManager().checkForConfig(potionSkillConfigFile);
    }

    public void reload() {
        standardSkillConfig = null;
        outsourcedSkillConfig = null;
        potionSkillConfig = null;
        this.load();
    }

    public void load() {
        standardSkillConfig = YamlConfiguration.loadConfiguration((File)skillConfigFile);
        standardSkillConfig.setDefaults(defaultSkillConfig);
        standardSkillConfig.options().copyDefaults(true);
        outsourcedSkillConfig = YamlConfiguration.loadConfiguration((File)outsourcedSkillConfigFile);
        outsourcedSkillConfig.setDefaults(standardSkillConfig);
        potionSkillConfig = YamlConfiguration.loadConfiguration((File)potionSkillConfigFile);
        potionSkillConfig.setDefaults(standardSkillConfig);
        for (String key : standardSkillConfig.getKeys(true)) {
            if (standardSkillConfig.isConfigurationSection(key)) continue;
            outsourcedSkillConfig.set(key, standardSkillConfig.get(key));
            potionSkillConfig.set(key, standardSkillConfig.get(key));
        }
    }

    public static void saveSkillConfig() {
        try {
            ((YamlConfiguration)standardSkillConfig).save(skillConfigFile);
        }
        catch (IOException e) {
            Heroes.log(Level.WARNING, "Unable to save default skills file!");
        }
    }

    public Configuration getClassConfig(String name) {
        return classSkillConfigs.get(name);
    }

    public void addClassSkillSettings(String className, String skillName, ConfigurationSection section) {
        Configuration config = classSkillConfigs.get(className);
        if (config == null) {
            config = new MemoryConfiguration();
            classSkillConfigs.put(className, config);
        }
        if (section == null) {
            return;
        }
        ConfigurationSection classSection = config.getConfigurationSection(skillName);
        if (classSection == null) {
            classSection = config.createSection(skillName);
        }
        for (String key : section.getKeys(true)) {
            if (!section.isConfigurationSection(key)) continue;
            classSection.createSection(key);
        }
        for (String key : section.getKeys(true)) {
            if (section.isConfigurationSection(key)) continue;
            classSection.set(key, section.get(key));
        }
    }

    public void loadSkillDefaults(Skill skill) {
        if (skill instanceof OutsourcedSkill) {
            return;
        }
        ConfigurationSection dSection = skill.getDefaultConfig();
        ConfigurationSection newSection = defaultSkillConfig.createSection(skill.getName());
        for (String key : dSection.getKeys(true)) {
            if (!dSection.isConfigurationSection(key)) continue;
            newSection.createSection(key);
        }
        for (String key : dSection.getKeys(true)) {
            if (dSection.isConfigurationSection(key)) continue;
            Object o = dSection.get(key);
            if (o instanceof List) {
                newSection.set(key, new ArrayList((List)o));
                continue;
            }
            newSection.set(key, o);
        }
    }

    public static void setClassDefaults() {
        for (Configuration config : classSkillConfigs.values()) {
            config.setDefaults(outsourcedSkillConfig);
        }
    }

    public static String getRaw(Skill skill, String setting, String def) {
        return outsourcedSkillConfig.getString(skill.getName() + "." + setting, def);
    }

    public static String getRaw(Skill skill, SkillSetting setting, String def) {
        return SkillConfigManager.getRaw(skill, setting.node(), def);
    }

    public static Boolean getRaw(Skill skill, SkillSetting setting, boolean def) {
        return SkillConfigManager.getRaw(skill, setting.node(), def);
    }

    public static Boolean getRaw(Skill skill, String setting, boolean def) {
        return Boolean.valueOf(outsourcedSkillConfig.getString(skill.getName() + "." + setting));
    }

    public static Set<String> getRawKeys(Skill skill, String setting) {
        Object path = skill.getName();
        if (setting != null) {
            path = (String)path + "." + setting;
        }
        if (!outsourcedSkillConfig.isConfigurationSection((String)path)) {
            return new HashSet<String>();
        }
        return outsourcedSkillConfig.getConfigurationSection((String)path).getKeys(false);
    }

    public static Object getSetting(HeroClass hc, Skill skill, String setting) {
        Configuration config = classSkillConfigs.get(hc.getName());
        if (config == null || !config.isConfigurationSection(skill.getName())) {
            return null;
        }
        return config.get(skill.getName() + "." + setting);
    }

    public static int getSetting(HeroClass hc, Skill skill, String setting, int def) {
        Object val = SkillConfigManager.getSetting(hc, skill, setting);
        if (val == null) {
            return def;
        }
        Integer i = Util.toInt(val);
        return i != null ? i : def;
    }

    public static double getSetting(HeroClass hc, Skill skill, String setting, double def) {
        Object val = SkillConfigManager.getSetting(hc, skill, setting);
        if (val == null) {
            return def;
        }
        Double d = Util.toDouble(val);
        return d != null ? d : def;
    }

    public static String getSetting(HeroClass hc, Skill skill, String setting, String def) {
        Object val = SkillConfigManager.getSetting(hc, skill, setting);
        if (val == null) {
            return def;
        }
        return val.toString();
    }

    public static boolean getSetting(HeroClass hc, Skill skill, String setting, boolean def) {
        Object val = SkillConfigManager.getSetting(hc, skill, setting);
        if (val == null) {
            return def;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return Boolean.valueOf((String)val);
        }
        return def;
    }

    public static List<String> getSetting(HeroClass hc, Skill skill, String setting, List<String> def) {
        Configuration config = classSkillConfigs.get(hc.getName());
        if (config == null || !config.isConfigurationSection(skill.getName())) {
            return def;
        }
        List val = config.getStringList(skill.getName() + "." + setting);
        return val != null && !val.isEmpty() ? val : def;
    }

    public static Set<String> getSettingKeys(HeroClass hc, Skill skill, String setting) {
        Configuration config;
        Object path = skill.getName();
        if (setting != null) {
            path = (String)path + "." + setting;
        }
        if ((config = classSkillConfigs.get(hc.getName())) == null || !config.isConfigurationSection((String)path)) {
            return new HashSet<String>();
        }
        return config.getConfigurationSection((String)path).getKeys(false);
    }

    public static Set<String> getUseSettingKeys(Hero hero, Skill skill, String setting) {
        ConfigurationSection section;
        HashSet<String> vals = new HashSet<String>();
        Object path = skill.getName();
        if (setting != null) {
            path = (String)path + "." + setting;
        }
        if ((section = outsourcedSkillConfig.getConfigurationSection((String)path)) != null) {
            vals.addAll(section.getKeys(false));
        }
        if (hero.canPrimaryUseSkill(skill)) {
            vals.addAll(SkillConfigManager.getSettingKeys(hero.getHeroClass(), skill, setting));
        }
        if (hero.canSecondaryUseSkill(skill)) {
            vals.addAll(SkillConfigManager.getSettingKeys(hero.getSecondaryClass(), skill, setting));
        }
        if (hero.canRaceUseSkill(skill)) {
            vals.addAll(SkillConfigManager.getSettingKeys(hero.getRaceClass(), skill, setting));
        }
        if (hero.canGlobalUseSkill(skill)) {
            vals.addAll(SkillConfigManager.getSettingKeys(Heroes.getInstance().getClassManager().getGlobalSkillset(), skill, setting));
        }
        return vals;
    }

    public static List<String> getUseSettingKeys(Hero hero, Skill skill) {
        HashSet<String> keys = new HashSet<String>();
        ConfigurationSection section = outsourcedSkillConfig.getConfigurationSection(skill.getName());
        if (section != null) {
            keys.addAll(section.getKeys(false));
        }
        if (hero.canPrimaryUseSkill(skill)) {
            keys.addAll(SkillConfigManager.getSettingKeys(hero.getHeroClass(), skill, null));
        }
        if (hero.canSecondaryUseSkill(skill)) {
            keys.addAll(SkillConfigManager.getSettingKeys(hero.getSecondaryClass(), skill, null));
        }
        if (hero.canRaceUseSkill(skill)) {
            keys.addAll(SkillConfigManager.getSettingKeys(hero.getRaceClass(), skill, null));
        }
        if (hero.canGlobalUseSkill(skill)) {
            keys.addAll(SkillConfigManager.getSettingKeys(Heroes.getInstance().getClassManager().getGlobalSkillset(), skill, null));
        }
        return new ArrayList<String>(keys);
    }

    public static int getLevel(Hero hero, Skill skill, int def) {
        String name = skill.getName();
        if (hero == null) {
            return outsourcedSkillConfig.getInt(name + "." + SkillSetting.LEVEL.node(), def);
        }
        int val1 = -1;
        int val2 = -1;
        if (hero.getHeroClass().hasSkill(name)) {
            val1 = SkillConfigManager.getSetting(hero.getHeroClass(), skill, SkillSetting.LEVEL.node(), def);
        }
        if (hero.getSecondaryClass() != null && hero.getSecondaryClass().hasSkill(name)) {
            val2 = SkillConfigManager.getSetting(hero.getSecondaryClass(), skill, SkillSetting.LEVEL.node(), def);
        }
        if (hero.getRaceClass() != null && hero.getRaceClass().hasSkill(name)) {
            val2 = SkillConfigManager.getSetting(hero.getRaceClass(), skill, SkillSetting.LEVEL.node(), def);
        }
        if (val1 != -1 && val2 != -1) {
            return val1 < val2 ? val1 : val2;
        }
        if (val1 != -1) {
            return val1;
        }
        if (val2 != -1) {
            return val2;
        }
        return outsourcedSkillConfig.getInt(name + "." + SkillSetting.LEVEL.node(), def);
    }

    public static int getUseSettingInt(Hero hero, Skill skill, SkillSetting setting, boolean lower) {
        return SkillConfigManager.getUseSetting(hero, skill, setting, 0, lower);
    }

    public static int getUseSetting(Hero hero, Skill skill, SkillSetting setting, int def, boolean lower) {
        if (setting == SkillSetting.LEVEL) {
            return SkillConfigManager.getLevel(hero, skill, def);
        }
        return SkillConfigManager.getUseSetting(hero, skill, setting.node(), def, lower);
    }

    public static String getUseSettingString(Hero hero, Skill skill, SkillSetting setting) {
        return SkillConfigManager.getUseSetting(hero, skill, setting.node(), "");
    }

    public static String getUseSetting(Hero hero, Skill skill, SkillSetting setting, String def) {
        return SkillConfigManager.getUseSetting(hero, skill, setting.node(), def);
    }

    public static double getUseSettingDouble(Hero hero, Skill skill, SkillSetting setting, boolean lower) {
        return SkillConfigManager.getUseSetting(hero, skill, setting.node(), 0.0, lower);
    }

    public static double getUseSetting(Hero hero, Skill skill, SkillSetting setting, double def, boolean lower) {
        return SkillConfigManager.getUseSetting(hero, skill, setting.node(), def, lower);
    }

    public static boolean getUseSettingBool(Hero hero, Skill skill, SkillSetting setting) {
        return SkillConfigManager.getUseSetting(hero, skill, setting.node(), false);
    }

    public static boolean getUseSetting(Hero hero, Skill skill, SkillSetting setting, boolean def) {
        return SkillConfigManager.getUseSetting(hero, skill, setting.node(), def);
    }

    public static int getUseSettingInt(Hero hero, Skill skill, String setting, boolean lower) {
        return SkillConfigManager.getUseSetting(hero, skill, setting, 0, lower);
    }

    public static int getUseSetting(Hero hero, Skill skill, String setting, int def, boolean lower) {
        if (setting.equalsIgnoreCase("level")) {
            throw new IllegalArgumentException("Do not use getSetting() for grabbing a hero level!");
        }
        String name = skill.getName();
        if (hero == null) {
            return outsourcedSkillConfig.getInt(name + "." + setting, def);
        }
        int val1 = -1;
        int val2 = -1;
        int val3 = -1;
        if (hero.canPrimaryUseSkill(skill)) {
            val1 = SkillConfigManager.getSetting(hero.getHeroClass(), skill, setting, def);
        }
        if (hero.canSecondaryUseSkill(skill)) {
            val2 = SkillConfigManager.getSetting(hero.getSecondaryClass(), skill, setting, def);
        }
        if (hero.canRaceUseSkill(skill)) {
            val2 = SkillConfigManager.getSetting(hero.getRaceClass(), skill, setting, def);
        }
        if (hero.canGlobalUseSkill(skill)) {
            val3 = SkillConfigManager.getSetting(Heroes.getInstance().getClassManager().getGlobalSkillset(), skill, setting, def);
        }
        if (val1 != -1 && val2 != -1 && val3 != -1) {
            int result;
            if (lower) {
                result = val1 < val2 ? val1 : val2;
                result = result < val3 ? result : val3;
            } else {
                result = val1 > val2 ? val1 : val2;
                result = result > val3 ? result : val3;
            }
            return result;
        }
        if (val1 != -1 && val2 != -1) {
            if (lower) {
                return val1 < val2 ? val1 : val2;
            }
            return val1 > val2 ? val1 : val2;
        }
        if (val1 != -1) {
            return val1;
        }
        if (val2 != -1) {
            return val2;
        }
        if (val3 != -1) {
            return val3;
        }
        return outsourcedSkillConfig.getInt(name + "." + setting, def);
    }

    public static double getUseSettingDouble(Hero hero, Skill skill, String setting, boolean lower) {
        return SkillConfigManager.getUseSetting(hero, skill, setting, 0.0, lower);
    }

    public static double getUseSetting(Hero hero, Skill skill, String setting, double def, boolean lower) {
        String name = skill.getName();
        if (hero == null) {
            return outsourcedSkillConfig.getDouble(name + "." + setting, def);
        }
        double val1 = -1.0;
        double val2 = -1.0;
        double val3 = -1.0;
        if (hero.canPrimaryUseSkill(skill)) {
            val1 = SkillConfigManager.getSetting(hero.getHeroClass(), skill, setting, def);
        }
        if (hero.canSecondaryUseSkill(skill)) {
            val2 = SkillConfigManager.getSetting(hero.getSecondaryClass(), skill, setting, def);
        }
        if (hero.canRaceUseSkill(skill)) {
            val2 = SkillConfigManager.getSetting(hero.getRaceClass(), skill, setting, def);
        }
        if (hero.canGlobalUseSkill(skill)) {
            val3 = SkillConfigManager.getSetting(Heroes.getInstance().getClassManager().getGlobalSkillset(), skill, setting, def);
        }
        if (val1 != -1.0 && val2 != -1.0 && val3 != -1.0) {
            double result;
            if (lower) {
                result = val1 < val2 ? val1 : val2;
                result = result < val3 ? result : val3;
            } else {
                result = val1 > val2 ? val1 : val2;
                result = result > val3 ? result : val3;
            }
            return result;
        }
        if (val1 != -1.0 && val2 != -1.0) {
            if (lower) {
                return val1 < val2 ? val1 : val2;
            }
            return val1 > val2 ? val1 : val2;
        }
        if (val1 != -1.0) {
            return val1;
        }
        if (val2 != -1.0) {
            return val2;
        }
        if (val3 != -1.0) {
            return val3;
        }
        return outsourcedSkillConfig.getDouble(name + "." + setting, def);
    }

    public static boolean getUseSettingBool(Hero hero, Skill skill, String setting) {
        return SkillConfigManager.getUseSetting(hero, skill, setting, false);
    }

    public static boolean getUseSetting(Hero hero, Skill skill, String setting, boolean def) {
        if (hero == null) {
            return outsourcedSkillConfig.getBoolean(skill.getName() + "." + setting, def);
        }
        boolean val = false;
        if (hero.canPrimaryUseSkill(skill)) {
            val = SkillConfigManager.getSetting(hero.getHeroClass(), skill, setting, def);
        }
        if (hero.canSecondaryUseSkill(skill)) {
            boolean bl = val = val || SkillConfigManager.getSetting(hero.getSecondaryClass(), skill, setting, def);
        }
        if (hero.canRaceUseSkill(skill)) {
            boolean bl = val = val || SkillConfigManager.getSetting(hero.getRaceClass(), skill, setting, def);
        }
        if (hero.canGlobalUseSkill(skill)) {
            val = val || SkillConfigManager.getSetting(Heroes.getInstance().getClassManager().getGlobalSkillset(), skill, setting, def);
        }
        return val;
    }

    public static String getUseSettingString(Hero hero, Skill skill, String setting) {
        return SkillConfigManager.getUseSetting(hero, skill, setting, "");
    }

    public static String getUseSetting(Hero hero, Skill skill, String setting, String def) {
        if (hero == null) {
            return outsourcedSkillConfig.getString(skill.getName() + "." + setting, def);
        }
        if (hero.canPrimaryUseSkill(skill)) {
            return SkillConfigManager.getSetting(hero.getHeroClass(), skill, setting, def);
        }
        if (hero.canSecondaryUseSkill(skill)) {
            return SkillConfigManager.getSetting(hero.getSecondaryClass(), skill, setting, def);
        }
        if (hero.canRaceUseSkill(skill)) {
            return SkillConfigManager.getSetting(hero.getRaceClass(), skill, setting, def);
        }
        if (hero.canGlobalUseSkill(skill)) {
            return SkillConfigManager.getSetting(Heroes.getInstance().getClassManager().getGlobalSkillset(), skill, setting, def);
        }
        return outsourcedSkillConfig.getString(skill.getName() + "." + setting, def);
    }

    public static List<String> getUseSettingStringList(Hero hero, Skill skill, String setting) {
        return SkillConfigManager.getUseSetting(hero, skill, setting, Collections.emptyList());
    }

    public static List<String> getUseSetting(Hero hero, Skill skill, String setting, List<String> def) {
        List list;
        if (hero == null) {
            List list2 = outsourcedSkillConfig.getStringList(skill.getName() + "." + setting);
            return list2 != null ? list2 : def;
        }
        ArrayList<String> vals = new ArrayList<String>();
        if (hero.canPrimaryUseSkill(skill)) {
            list = SkillConfigManager.getSetting(hero.getHeroClass(), skill, setting, new ArrayList<String>());
            vals.addAll(list);
        }
        if (hero.canSecondaryUseSkill(skill)) {
            list = SkillConfigManager.getSetting(hero.getSecondaryClass(), skill, setting, new ArrayList<String>());
            vals.addAll(list);
        }
        if (hero.canRaceUseSkill(skill)) {
            list = SkillConfigManager.getSetting(hero.getRaceClass(), skill, setting, new ArrayList<String>());
            vals.addAll(list);
        }
        if (hero.canGlobalUseSkill(skill)) {
            list = SkillConfigManager.getSetting(Heroes.getInstance().getClassManager().getGlobalSkillset(), skill, setting, new ArrayList<String>());
            vals.addAll(list);
        }
        if (!vals.isEmpty()) {
            return vals;
        }
        list = outsourcedSkillConfig.getStringList(skill.getName() + "." + setting);
        return list != null && !list.isEmpty() ? list : def;
    }

    public static int getScaledUseSettingInt(Hero hero, Skill skill, SkillSetting setting, boolean lower) {
        return (int)SkillConfigManager.getScaledUseSettingDouble(hero, skill, setting, 0.0, lower);
    }

    public static int getScaledUseSettingInt(Hero hero, Skill skill, SkillSetting setting, int def, boolean lower) {
        return (int)SkillConfigManager.getScaledUseSettingDouble(hero, skill, setting, (double)def, lower);
    }

    public static int getScaledUseSettingInt(Hero hero, Skill skill, String setting, boolean lower) {
        return (int)SkillConfigManager.getScaledUseSettingDouble(hero, skill, setting, 0.0, lower);
    }

    public static int getScaledUseSettingInt(Hero hero, Skill skill, String setting, int def, boolean lower) {
        return (int)SkillConfigManager.getScaledUseSettingDouble(hero, skill, setting, (double)def, lower);
    }

    public static double getScaledUseSettingDouble(Hero hero, Skill skill, String setting, boolean lower) {
        return SkillConfigManager.getScaledUseSettingDouble(hero, skill, setting, 0.0, lower);
    }

    public static double getScaledUseSettingDouble(Hero hero, Skill skill, String setting, double def, boolean lower) {
        double baseValue = SkillConfigManager.getUseSetting(hero, skill, setting, def, lower);
        double increasePerLevel1 = SkillConfigManager.getUseSetting(hero, skill, setting + "-per-level", 0.0, lower);
        double increasePerLevel2 = SkillConfigManager.getUseSetting(hero, skill, setting + "-increase-per-level", 0.0, lower);
        double totalValue = baseValue + (increasePerLevel1 + increasePerLevel2) * (double)hero.getHeroLevel(skill);
        double chaValue1 = SkillConfigManager.getUseSetting(hero, skill, setting + "-per-charisma", 0.0, lower);
        double chaValue2 = SkillConfigManager.getUseSetting(hero, skill, setting + "-increase-per-charisma", 0.0, lower);
        if (chaValue1 > 0.0 || chaValue2 > 0.0) {
            totalValue += (double)hero.getAttributeValue(AttributeType.CHARISMA) * (chaValue1 + chaValue2);
        }
        double dexValue1 = SkillConfigManager.getUseSetting(hero, skill, setting + "-per-dexterity", 0.0, lower);
        double dexValue2 = SkillConfigManager.getUseSetting(hero, skill, setting + "-increase-per-dexterity", 0.0, lower);
        if (dexValue1 > 0.0 || dexValue2 > 0.0) {
            totalValue += (double)hero.getAttributeValue(AttributeType.DEXTERITY) * (dexValue1 + dexValue2);
        }
        double intValue1 = SkillConfigManager.getUseSetting(hero, skill, setting + "-per-intellect", 0.0, lower);
        double intValue2 = SkillConfigManager.getUseSetting(hero, skill, setting + "-increase-per-intellect", 0.0, lower);
        if (intValue1 > 0.0 || intValue2 > 0.0) {
            totalValue += (double)hero.getAttributeValue(AttributeType.INTELLECT) * (intValue1 + intValue2);
        }
        double strValue1 = SkillConfigManager.getUseSetting(hero, skill, setting + "-per-strength", 0.0, lower);
        double strValue2 = SkillConfigManager.getUseSetting(hero, skill, setting + "-increase-per-strength", 0.0, lower);
        if (strValue1 > 0.0 || strValue2 > 0.0) {
            totalValue += (double)hero.getAttributeValue(AttributeType.STRENGTH) * (strValue1 + strValue2);
        }
        double wisValue1 = SkillConfigManager.getUseSetting(hero, skill, setting + "-per-wisdom", 0.0, lower);
        double wisValue2 = SkillConfigManager.getUseSetting(hero, skill, setting + "-increase-per-wisdom", 0.0, lower);
        if (wisValue1 > 0.0 || wisValue2 > 0.0) {
            totalValue += (double)hero.getAttributeValue(AttributeType.WISDOM) * (wisValue1 + wisValue2);
        }
        return totalValue;
    }

    public static double getScaledUseSettingDouble(Hero hero, Skill skill, SkillSetting setting, boolean lower) {
        return SkillConfigManager.getScaledUseSettingDouble(hero, skill, setting, 0.0, lower);
    }

    public static double getScaledUseSettingDouble(Hero hero, Skill skill, SkillSetting setting, double def, boolean lower) {
        double baseValue = SkillConfigManager.getUseSetting(hero, skill, setting, def, lower);
        double increasePerLevel1 = SkillConfigManager.getUseSetting(hero, skill, setting.node() + "-per-level", 0.0, lower);
        double increasePerLevel2 = SkillConfigManager.getUseSetting(hero, skill, setting.node() + "-increase-per-level", 0.0, lower);
        double totalValue = baseValue + (increasePerLevel1 + increasePerLevel2) * (double)hero.getHeroLevel(skill);
        double chaValue1 = SkillConfigManager.getUseSetting(hero, skill, setting.node() + "-per-charisma", 0.0, lower);
        double chaValue2 = SkillConfigManager.getUseSetting(hero, skill, setting.node() + "-increase-per-charisma", 0.0, lower);
        if (chaValue1 > 0.0 || chaValue2 > 0.0) {
            totalValue += (double)hero.getAttributeValue(AttributeType.CHARISMA) * (chaValue1 + chaValue2);
        }
        double dexValue1 = SkillConfigManager.getUseSetting(hero, skill, setting.node() + "-per-dexterity", 0.0, lower);
        double dexValue2 = SkillConfigManager.getUseSetting(hero, skill, setting.node() + "-increase-per-dexterity", 0.0, lower);
        if (dexValue1 > 0.0 || dexValue2 > 0.0) {
            totalValue += (double)hero.getAttributeValue(AttributeType.DEXTERITY) * (dexValue1 + dexValue2);
        }
        double intValue1 = SkillConfigManager.getUseSetting(hero, skill, setting.node() + "-per-intellect", 0.0, lower);
        double intValue2 = SkillConfigManager.getUseSetting(hero, skill, setting.node() + "-increase-per-intellect", 0.0, lower);
        if (intValue1 > 0.0 || intValue2 > 0.0) {
            totalValue += (double)hero.getAttributeValue(AttributeType.INTELLECT) * (intValue1 + intValue2);
        }
        double strValue1 = SkillConfigManager.getUseSetting(hero, skill, setting.node() + "-per-strength", 0.0, lower);
        double strValue2 = SkillConfigManager.getUseSetting(hero, skill, setting.node() + "-increase-per-strength", 0.0, lower);
        if (strValue1 > 0.0 || strValue2 > 0.0) {
            totalValue += (double)hero.getAttributeValue(AttributeType.STRENGTH) * (strValue1 + strValue2);
        }
        double wisValue1 = SkillConfigManager.getUseSetting(hero, skill, setting.node() + "-per-wisdom", 0.0, lower);
        double wisValue2 = SkillConfigManager.getUseSetting(hero, skill, setting.node() + "-increase-per-wisdom", 0.0, lower);
        if (wisValue1 > 0.0 || wisValue2 > 0.0) {
            totalValue += (double)hero.getAttributeValue(AttributeType.WISDOM) * (wisValue1 + wisValue2);
        }
        return totalValue;
    }

    public static <T extends ConfigurationSerializable> T getUseSettingObject(Hero hero, Skill skill, String setting) {
        Player player = hero.getPlayer();
        ConfigurationSection skillSection = SkillConfigManager.getSectionForSkillIfAble(hero, skill);
        if (skillSection == null) {
            player.sendMessage("Null Section");
            return null;
        }
        ConfigurationSection matchSetting = skillSection.getConfigurationSection(setting);
        if (matchSetting == null) {
            player.sendMessage("Null setting");
            return null;
        }
        ConfigurationSerializable obj = ConfigurationSerialization.deserializeObject((Map)matchSetting.getValues(false));
        if (obj == null) {
            player.sendMessage("Failed Deserialization.");
            return null;
        }
        try {
            ConfigurationSerializable actualObj = obj;
            player.sendMessage("WE GOT EM BOYS");
            return (T)actualObj;
        }
        catch (Exception e) {
            player.sendMessage("RIP");
            return null;
        }
    }

    public static ComplexItemMatcher getUseSettingItemMatcher(Hero hero, Skill skill, String setting) {
        ConfigurationSection skillSection = SkillConfigManager.getSectionForSkillIfAble(hero, skill);
        if (skillSection == null) {
            return null;
        }
        ConfigurationSection matchSetting = skillSection.getConfigurationSection(setting);
        if (matchSetting == null) {
            return null;
        }
        return new ComplexItemMatcher(matchSetting.get("name-match").toString(), matchSetting.get("type-match").toString());
    }

    public static List<ComplexItemMatcher> getUseSettingItemMatcherList(Hero hero, Skill skill, String setting) {
        ConfigurationSection skillSection = SkillConfigManager.getSectionForSkillIfAble(hero, skill);
        if (skillSection == null) {
            return null;
        }
        ArrayList<ComplexItemMatcher> matchers = new ArrayList<ComplexItemMatcher>();
        skillSection.getMapList(setting).forEach(obj -> matchers.add(new ComplexItemMatcher(obj.get("name-match").toString(), obj.get("type-match").toString())));
        return matchers;
    }

    public static ConfigurationSection getSectionForSkillIfAble(Hero hero, Skill skill) {
        Configuration config;
        ConfigurationSection skillSection = null;
        if (hero.canPrimaryUseSkill(skill) && (config = classSkillConfigs.get(hero.getHeroClass().getName())) != null) {
            skillSection = config.getConfigurationSection(skill.getName());
        }
        if (skillSection == null && hero.canSecondaryUseSkill(skill) && (config = classSkillConfigs.get(hero.getSecondaryClass().getName())) != null) {
            skillSection = config.getConfigurationSection(skill.getName());
        }
        if (skillSection == null && hero.canRaceUseSkill(skill) && (config = classSkillConfigs.get(hero.getRaceClass().getName())) != null) {
            skillSection = config.getConfigurationSection(skill.getName());
        }
        if (skillSection == null && hero.canGlobalUseSkill(skill) && (config = classSkillConfigs.get(Heroes.getInstance().getClassManager().getGlobalSkillset().getName())) != null) {
            skillSection = config.getConfigurationSection(skill.getName());
        }
        return skillSection;
    }

    static {
        defaultSkillConfig = new MemoryConfiguration();
        classSkillConfigs = new HashMap<String, Configuration>();
    }
}

