/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Passive;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.characters.skill.TargettedSkill;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.util.MaterialUtil;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public abstract class Skill
extends BasicCommand {
    private static boolean skillDamage = false;
    public final Heroes plugin;
    private final Configuration defaultConfig = new MemoryConfiguration();
    private final Set<SkillType> types = EnumSet.noneOf(SkillType.class);
    private String version = null;

    public static boolean isSkillDamage() {
        return skillDamage;
    }

    public Skill(Heroes plugin, String name) {
        super(name);
        this.plugin = plugin;
    }

    public abstract String getDescription(Hero var1);

    public String getDescriptionMetadata(Hero hero) {
        double healthCost = SkillConfigManager.getUseSetting(hero, this, SkillSetting.HEALTH_COST, 0.0, false) - SkillConfigManager.getUseSetting(hero, this, SkillSetting.HEALTH_COST_REDUCE, 0.0, false);
        int stamCost = SkillConfigManager.getUseSetting(hero, this, SkillSetting.STAMINA, 0, false) - SkillConfigManager.getUseSetting(hero, this, SkillSetting.STAMINA_REDUCE, 0, false);
        int manaCost = SkillConfigManager.getUseSetting(hero, this, SkillSetting.MANA, 0, true);
        double manaReduce = SkillConfigManager.getUseSetting(hero, this, SkillSetting.MANA_REDUCE_PER_LEVEL, 0.0, false) * (double)hero.getHeroLevel(this);
        manaCost -= (int)manaReduce;
        int warmup = SkillConfigManager.getUseSetting(hero, this, SkillSetting.DELAY, 0, false);
        double maxDistance = SkillConfigManager.getUseSetting(hero, this, SkillSetting.MAX_DISTANCE, 0.0, false);
        long cooldown = SkillConfigManager.getUseSetting(hero, this, SkillSetting.COOLDOWN, 0, false);
        ItemStack reagentCost = this.getReagentCost(hero);
        String reagentName = "";
        if (reagentCost != null) {
            ItemMeta itemMeta = reagentCost.getItemMeta();
            reagentName = itemMeta.hasDisplayName() ? itemMeta.getDisplayName() : MaterialUtil.getFriendlyName(reagentCost.getType());
        }
        Object metaDataDescrip = "";
        if (healthCost > 0.0) {
            metaDataDescrip = (String)metaDataDescrip + this.toCastDescriptor("Health Cost: ", healthCost);
        }
        if (stamCost > 0) {
            metaDataDescrip = (String)metaDataDescrip + this.toCastDescriptor("Stamina Cost: ", stamCost);
        }
        if (manaCost > 0) {
            metaDataDescrip = (String)metaDataDescrip + this.toCastDescriptor("Mana Cost: ", manaCost);
        }
        if (maxDistance > 0.0) {
            metaDataDescrip = (String)metaDataDescrip + this.toCastDescriptor("Cast Range: ", maxDistance + " blocks");
        }
        if (warmup > 0) {
            metaDataDescrip = (String)metaDataDescrip + this.toCastDescriptor("Cast Time: ", Util.decFormat.format((double)warmup / 1000.0) + " second(s)");
        }
        if (cooldown > 0L) {
            metaDataDescrip = (String)metaDataDescrip + this.toCastDescriptor("Cooldown: ", Util.decFormat.format((double)cooldown / 1000.0) + " second(s)");
        }
        if (reagentCost != null && reagentCost.getAmount() > 0) {
            metaDataDescrip = (String)metaDataDescrip + this.toCastDescriptor("Reagent: ", reagentCost.getAmount() + " x " + reagentName);
        }
        if (this instanceof Passive) {
            metaDataDescrip = (String)metaDataDescrip + this.toPropertyDescriptor("-Has Passive Effects");
        } else if (this instanceof TargettedSkill) {
            metaDataDescrip = (String)metaDataDescrip + this.toPropertyDescriptor("-Requires Targetting");
        }
        Set<SkillType> types = this.getTypes();
        if (types.contains((Object)SkillType.SILENCEABLE)) {
            metaDataDescrip = (String)metaDataDescrip + this.toPropertyDescriptor("-Silenceable");
        }
        if (types.contains((Object)SkillType.INTERRUPTING)) {
            metaDataDescrip = (String)metaDataDescrip + this.toPropertyDescriptor("-Interrupting");
            long interruptCd = SkillConfigManager.getUseSetting(hero, this, SkillSetting.ON_INTERRUPT_FORCE_COOLDOWN, 0, false);
            if (interruptCd > 0L) {
                metaDataDescrip = (String)metaDataDescrip + this.toCastDescriptor("-Interrupt Cooldown: ", Util.decFormat.format((double)interruptCd / 1000.0) + " second(s)");
            }
        }
        if (types.contains((Object)SkillType.NO_SELF_TARGETTING)) {
            metaDataDescrip = (String)metaDataDescrip + this.toPropertyDescriptor("-No Self Targetting");
        }
        if (types.contains((Object)SkillType.AGGRESSIVE)) {
            metaDataDescrip = (String)metaDataDescrip + this.toPropertyDescriptor("-Enemies Only");
        }
        if (types.contains((Object)SkillType.HEALING)) {
            metaDataDescrip = (String)metaDataDescrip + this.toPropertyDescriptor("-Allies Only");
        }
        if (types.contains((Object)SkillType.ABILITY_PROPERTY_SONG)) {
            metaDataDescrip = (String)metaDataDescrip + this.toPropertyDescriptor("-No Cast Slowness");
        }
        if (types.contains((Object)SkillType.NAME_TARGETTING_ENABLED) || types.contains((Object)SkillType.OFFENSIVE_NAME_TARGETTING_ENABLED) || types.contains((Object)SkillType.DEFENSIVE_NAME_TARGETTING_ENABLED)) {
            metaDataDescrip = (String)metaDataDescrip + this.toPropertyDescriptor("-Can target players by name");
        }
        return metaDataDescrip;
    }

    private String toCastDescriptor(String descriptor, double value) {
        return this.toCastDescriptor(descriptor, "" + value);
    }

    private String toCastDescriptor(String descriptor, String valueText) {
        return System.lineSeparator() + ChatColor.AQUA + descriptor + ChatColor.RESET + ChatColor.UNDERLINE + valueText;
    }

    private String toPropertyDescriptor(String descriptor) {
        return System.lineSeparator() + ChatColor.GOLD + ChatColor.ITALIC + descriptor;
    }

    @Override
    public void setDescription(String def) {
        super.setDescription(SkillConfigManager.getRaw(this, SkillSetting.DESCRIPTION, def));
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public String getVersion() {
        return this.version;
    }

    public void addSpellTarget(Entity entity, Hero hero) {
        this.plugin.getDamageManager().addSpellTarget(entity, hero, this);
    }

    public void broadcast(Location source, String message, Object ... args) {
        if (message == null || message.isEmpty() || message.equalsIgnoreCase("off")) {
            return;
        }
        Collection players = source.getWorld().getNearbyEntities(source, 10.0, 10.0, 10.0, entity -> entity instanceof Player);
        players.forEach(player -> {
            Hero hero = this.plugin.getCharacterManager().getHero((Player)player);
            if (!hero.isSuppressing(this) && hero.isVerboseSkills()) {
                Messaging.send((CommandSender)player, message, args);
            }
        });
    }

    public static boolean damageCheck(Player attacker, LivingEntity defender) {
        if (attacker.equals(defender) || Skill.isInvalidEntity((LivingEntity)attacker, defender)) {
            return false;
        }
        EntityDamageByEntityEvent event = new EntityDamageByEntityEvent((Entity)attacker, (Entity)defender, EntityDamageEvent.DamageCause.CUSTOM, 0.0);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static boolean damageCheck(LivingEntity attacker, Player defender) {
        if (defender.equals(attacker) || Skill.isInvalidEntity(attacker, (LivingEntity)defender)) {
            return false;
        }
        EntityDamageByEntityEvent event = new EntityDamageByEntityEvent((Entity)attacker, (Entity)defender, EntityDamageEvent.DamageCause.CUSTOM, 0.0);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    private static boolean isInvalidEntity(LivingEntity attacker, LivingEntity defender) {
        HumanEntity humanTarget;
        if (attacker instanceof ArmorStand || defender instanceof ArmorStand) {
            return true;
        }
        if (attacker instanceof HumanEntity && ((humanTarget = (HumanEntity)attacker).getGameMode() == GameMode.SPECTATOR || humanTarget.getGameMode() == GameMode.CREATIVE)) {
            return true;
        }
        return defender instanceof HumanEntity && ((humanTarget = (HumanEntity)defender).getGameMode() == GameMode.SPECTATOR || humanTarget.getGameMode() == GameMode.CREATIVE);
    }

    @Override
    public abstract boolean execute(CommandSender var1, String var2, String[] var3);

    public ConfigurationSection getDefaultConfig() {
        return this.defaultConfig;
    }

    public Set<SkillType> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public abstract void init();

    @Override
    public boolean isShownOnHelpMenu() {
        return false;
    }

    public boolean isType(SkillType type) {
        return this.types.contains((Object)type);
    }

    protected void setTypes(SkillType ... types) {
        this.types.addAll(Arrays.asList(types));
    }

    @Deprecated
    public static void knockBack(LivingEntity target, LivingEntity attacker, double damage) {
        Skill.knockBack(target, attacker, 0.5f);
    }

    public static void knockBack(LivingEntity target, LivingEntity attacker, float knockbackStrength) {
        NMSHandler.getInterface().knockBack(target, attacker, knockbackStrength);
    }

    @Deprecated
    public boolean damageEntity(LivingEntity target, LivingEntity attacker, int damage) {
        return this.damageEntity(target, attacker, (double)damage, true);
    }

    public boolean damageEntity(LivingEntity target, LivingEntity attacker, double damage) {
        return this.damageEntity(target, attacker, damage, true);
    }

    public boolean damageEntity(LivingEntity target, LivingEntity attacker, double damage, boolean knockback) {
        return this.damageEntity(target, attacker, damage, this.isType(SkillType.ABILITY_PROPERTY_PHYSICAL) ? EntityDamageEvent.DamageCause.ENTITY_ATTACK : EntityDamageEvent.DamageCause.MAGIC, knockback);
    }

    @Deprecated
    public boolean damageEntity(LivingEntity target, LivingEntity attacker, int damage, EntityDamageEvent.DamageCause cause, boolean knockback) {
        return this.damageEntity(target, attacker, Math.floor(damage), cause, knockback);
    }

    @Deprecated
    public boolean damageEntity(LivingEntity target, LivingEntity attacker, double damage, EntityDamageEvent.DamageCause cause, boolean knockback) {
        return knockback ? this.damageEntity(target, attacker, damage, cause, Heroes.properties.defaultKnockback) : this.damageEntity(target, attacker, damage, cause, 0.0f);
    }

    public boolean damageEntity(LivingEntity target, LivingEntity attacker, double damage, EntityDamageEvent.DamageCause cause, float knockback) {
        if (attacker instanceof Player) {
            Hero hero = this.plugin.getCharacterManager().getHero((Player)attacker);
            if (!(target instanceof Player)) {
                double pveDamageMultiplier = SkillConfigManager.getUseSetting(hero, this, SkillSetting.PVE_DAMAGE_MULTIPLIER, 1.0, false);
                double pveDamageMultiplierIncreasePerLevel = SkillConfigManager.getUseSetting(hero, this, SkillSetting.PVE_DAMAGE_MULTIPLIER_INCREASE_PER_LEVEL, 0.0, false);
                damage *= pveDamageMultiplier + pveDamageMultiplierIncreasePerLevel * (double)(hero.getHeroLevel(this) - 1);
            } else {
                double pvpDamageMultiplier = SkillConfigManager.getUseSetting(hero, this, SkillSetting.PVP_DAMAGE_MULTIPLIER, 1.0, false);
                double pvpDamageMultiplierIncreasePerLevel = SkillConfigManager.getUseSetting(hero, this, SkillSetting.PVP_DAMAGE_MULTIPLIER_INCREASE_PER_LEVEL, 0.0, false);
                damage *= pvpDamageMultiplier + pvpDamageMultiplierIncreasePerLevel * (double)(hero.getHeroLevel(this) - 1);
            }
        }
        skillDamage = true;
        boolean result = NMSHandler.getInterface().damageEntity(target, attacker, damage, cause, knockback);
        skillDamage = false;
        return result;
    }

    @Deprecated
    public boolean damageEntity(LivingEntity target, LivingEntity attacker, int damage, EntityDamageEvent.DamageCause cause) {
        return this.damageEntity(target, attacker, (double)damage, cause, true);
    }

    public boolean damageEntity(LivingEntity target, LivingEntity attacker, double damage, EntityDamageEvent.DamageCause cause) {
        return this.damageEntity(target, attacker, damage, cause, true);
    }

    protected boolean hasReagentCost(Player player, ItemStack itemStack) {
        if (itemStack == null || itemStack.getAmount() == 0) {
            return true;
        }
        ItemMeta reagentMeta = itemStack.getItemMeta();
        String reagentName = reagentMeta.hasDisplayName() ? reagentMeta.getDisplayName() : null;
        Material reagentType = itemStack.getType();
        boolean potion = Properties.SUBVERSION >= 9 && (reagentType == Material.POTION || reagentType == Material.SPLASH_POTION || reagentType == Material.LINGERING_POTION);
        int amount = 0;
        for (ItemStack stack : player.getInventory().all(reagentType).values()) {
            Material type = stack.getType();
            ItemMeta itemMeta = stack.getItemMeta();
            String materialName = type.name();
            if (reagentName == null ? itemMeta.hasDisplayName() : !itemMeta.hasDisplayName() || !reagentName.equals(this.stripPrependedResetColor(itemMeta.getDisplayName()))) continue;
            if (itemMeta.hasEnchants() || itemMeta.hasLore()) continue;
            if (potion) {
                PotionData reagentPotionData = ((PotionMeta)reagentMeta).getBasePotionData();
                PotionData itemPotionData = ((PotionMeta)itemMeta).getBasePotionData();
                if (reagentPotionData.getType() != itemPotionData.getType() || reagentPotionData.isExtended() != itemPotionData.isExtended() || reagentPotionData.isUpgraded() != itemPotionData.isUpgraded()) continue;
            }
            if ((amount += stack.getAmount()) < itemStack.getAmount()) continue;
            return true;
        }
        return false;
    }

    private String stripPrependedResetColor(String name) {
        String resetColor = ChatColor.RESET.toString();
        if (name.startsWith(resetColor)) {
            return name.substring(resetColor.length());
        }
        return name;
    }

    protected ItemStack getReagentCost(Hero hero) {
        return this.getReagentCost(hero, false);
    }

    protected ItemStack getReagentCost(Hero hero, boolean interrupt) {
        int reagentCost = SkillConfigManager.getUseSetting(hero, this, interrupt ? SkillSetting.INTERRUPT_REAGENT_COST : SkillSetting.REAGENT_COST, 0, true);
        String reagentMaterialName = SkillConfigManager.getUseSetting(hero, this, SkillSetting.REAGENT, null);
        String reagentName = SkillConfigManager.getUseSetting(hero, this, SkillSetting.REAGENT_NAME, null);
        ItemStack itemStack = null;
        if (reagentCost > 0 && reagentMaterialName != null && !reagentMaterialName.isEmpty()) {
            String[] vals = reagentMaterialName.split(":");
            Material itemMaterial = Material.matchMaterial((String)(reagentMaterialName = vals[0]));
            if (itemMaterial == null) {
                Heroes.log(Level.SEVERE, "Invalid skill reagent defined in " + this.getName() + ". Please switch to new format NAME, e.g. IRON_INGOT, instead of a data value.");
                return null;
            }
            itemStack = new ItemStack(itemMaterial, reagentCost);
            if (reagentName != null && !reagentName.isEmpty()) {
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.setDisplayName(reagentName);
                itemStack.setItemMeta(itemMeta);
            }
            if (itemMaterial == Material.POTION || itemMaterial == Material.SPLASH_POTION || Properties.SUBVERSION >= 9 && itemMaterial == Material.LINGERING_POTION) {
                this.handleAndSetReagentPotionProperties(itemStack, vals);
            }
        }
        return itemStack;
    }

    private void handleAndSetReagentPotionProperties(ItemStack itemStack, String[] vals) {
        PotionType potionType = PotionType.WATER;
        if (vals.length > 1) {
            String potionTypeName = vals[1];
            try {
                potionType = PotionType.valueOf((String)potionTypeName.toUpperCase());
            }
            catch (Exception ignored) {
                Heroes.log(Level.WARNING, "Invalid skill reagent potion type '" + potionTypeName + "' defined for skill " + this.getName() + ". Using default (WATER) instead. See Spigot docs for valid values of PotionType.");
            }
        }
        if (Properties.SUBVERSION >= 9) {
            boolean extended = false;
            boolean upgraded = false;
            if (vals.length > 2) {
                String enhancement = vals[2];
                if ((enhancement.equalsIgnoreCase("upgraded") || enhancement.equalsIgnoreCase("enhanced")) && potionType.isUpgradeable()) {
                    upgraded = true;
                } else if (enhancement.equalsIgnoreCase("extended") && potionType.isExtendable()) {
                    extended = true;
                } else {
                    Heroes.log(Level.WARNING, "Invalid skill reagent potion type enhancement '" + enhancement + "' defined for skill " + this.getName() + ", or the potion type cannot be upgraded or extended. Valid values are: ENHANCED (or UPGRADED), or EXTENDED if any is specified. Using default (none).");
                }
            }
            ItemMeta itemMeta = itemStack.getItemMeta();
            ((PotionMeta)itemMeta).setBasePotionData(new PotionData(potionType, extended, upgraded));
            itemStack.setItemMeta(itemMeta);
        } else {
            Heroes.log(Level.WARNING, "Potion types for skill reagents are not supported for minecraft below 1.9. Skill was " + this.getName() + ".");
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.toString().equals(this.getName())) {
            return true;
        }
        if (!(other instanceof Skill)) {
            return false;
        }
        Skill that = (Skill)other;
        return that.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

