/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

public class RecastData {
    private final String name;
    private long readyTime = 0L;

    public RecastData(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null!");
        }
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final long getReadyTime() {
        return this.readyTime;
    }

    public final void setReadyTime(long readyTime) {
        this.readyTime = readyTime;
    }

    public final long getReadyDelay() {
        return this.getReadyTime() - System.currentTimeMillis();
    }

    public final void setReadyDelay(long delay) {
        this.setReadyTime(System.currentTimeMillis() + delay);
    }

    public final boolean isReady() {
        return this.getReadyTime() >= 0L && this.getReadyDelay() <= 0L;
    }

    public final void setReady() {
        this.setReadyTime(System.currentTimeMillis());
    }

    public final boolean isNeverReady() {
        return this.getReadyTime() < 0L;
    }

    public final void setNeverReady() {
        this.setReadyTime(-1L);
    }
}

