/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicEffect;
import com.herocraftonline.heroes.characters.skill.PassiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.potion.PotionEffect;

public class PotionSkill
extends PassiveSkill {
    private long period;
    private final List<PotionEffect> potionEffects;

    public PotionSkill(Heroes plugin, String name, long effectPeriod, List<PotionEffect> potionEffects) {
        super(plugin, name);
        this.period = effectPeriod;
        this.potionEffects = potionEffects;
        this.init();
    }

    @Override
    public String getDescription(Hero hero) {
        StringBuilder description = new StringBuilder(this.getDescription());
        if (!this.potionEffects.isEmpty()) {
            description.append(" Effects: ");
            PotionEffect potionEffect = this.potionEffects.get(0);
            description.append(potionEffect.getType().getName()).append(potionEffect.getAmplifier());
            for (int i = 1; i < this.potionEffects.size(); ++i) {
                potionEffect = this.potionEffects.get(i);
                description.append(", ").append(potionEffect.getType().getName()).append(potionEffect.getAmplifier());
            }
        } else {
            description.append(" No Effects.");
        }
        return description.toString();
    }

    @Override
    public void apply(Hero hero) {
        if (!hero.hasEffect(this.getName())) {
            PotionSkillMaintainEffect potionSkillMaintainEffect = new PotionSkillMaintainEffect((Skill)this, this.getName(), this.period);
            potionSkillMaintainEffect.setPersistent(true);
            for (PotionEffect potionEffect : this.potionEffects) {
                potionSkillMaintainEffect.addPotionEffect(potionEffect);
            }
            hero.addEffect(potionSkillMaintainEffect);
        } else {
            Effect effect = hero.getEffect(this.getName());
            if (!(effect instanceof PotionSkillMaintainEffect)) {
                Heroes.log(Level.WARNING, "Invalid potion skill name \"" + this.getName() + "\". A hero already has an effect with the same name as this potion skill, that isn't from a potion skill. Consider renaming the potion skill.");
                return;
            }
            PotionSkillMaintainEffect potionSkillMaintainEffect = (PotionSkillMaintainEffect)effect;
            for (PotionEffect potionEffect : this.potionEffects) {
                potionSkillMaintainEffect.addPotionEffect(potionEffect);
            }
            potionSkillMaintainEffect.reapplyPotionEffects(hero);
        }
    }

    @Override
    public void unapply(Hero hero) {
        if (hero.hasEffect(this.getName())) {
            hero.removeEffect(hero.getEffect(this.getName()));
        }
    }

    public class PotionSkillMaintainEffect
    extends PeriodicEffect {
        public PotionSkillMaintainEffect(Skill skill, String name, long period) {
            super(skill, name, period);
            this.types.add(EffectType.INTERNAL);
        }

        @Override
        public void applyToHero(Hero hero) {
            super.applyToHero(hero);
        }

        @Override
        public void removeFromHero(Hero hero) {
            super.removeFromHero(hero);
        }

        @Override
        public void tickHero(Hero hero) {
            super.tickHero(hero);
            for (PotionEffect potionEffect : PotionSkill.this.potionEffects) {
                this.addPotionEffect(potionEffect);
            }
            this.reapplyPotionEffects(hero);
        }
    }
}

