/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroChangeLevelEvent;
import com.herocraftonline.heroes.api.events.SkillLearnEvent;
import com.herocraftonline.heroes.api.events.SkillPrepareEvent;
import com.herocraftonline.heroes.api.events.SkillUnlearnEvent;
import com.herocraftonline.heroes.api.events.SkillUnprepareEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.skill.Passive;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class PassiveSkill
extends Skill
implements Passive {
    protected String applyText = null;
    protected String unapplyText = null;
    protected EffectType[] effectTypes = null;

    public PassiveSkill(Heroes plugin, String name) {
        super(plugin, name);
        this.setUsage("Passive Skill");
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new SkillListener(), (Plugin)plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Messaging.send(sender, "$1 is a passive skill and cannot be used!", this.getName());
        return true;
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection section = super.getDefaultConfig();
        section.set(SkillSetting.APPLY_TEXT.node(), (Object)(ChatComponents.GENERIC_SKILL + "%hero% gained %skill%!"));
        section.set(SkillSetting.UNAPPLY_TEXT.node(), (Object)(ChatComponents.GENERIC_SKILL + "%hero% lost %skill%!"));
        return section;
    }

    @Override
    public void init() {
        if (Properties.silencePassiveSkills) {
            this.applyText = "";
            this.unapplyText = "";
            return;
        }
        this.applyText = SkillConfigManager.getRaw((Skill)this, SkillSetting.APPLY_TEXT, "").replace("%hero%", "$1").replace("%skill%", "$3");
        this.unapplyText = SkillConfigManager.getRaw((Skill)this, SkillSetting.UNAPPLY_TEXT, "").replace("%hero%", "$1").replace("%skill%", "$3");
    }

    public void setEffectTypes(EffectType ... effectTypes) {
        this.effectTypes = effectTypes;
    }

    @Override
    public void tryApplying(Hero hero) {
        Player player = hero.getPlayer();
        if (hero.canUseSkill(this)) {
            this.apply(hero);
        } else {
            this.unapply(hero);
        }
    }

    @Override
    public void apply(Hero hero) {
        hero.addEffect(new PassiveEffect((Skill)this, hero.getPlayer(), this.effectTypes));
    }

    @Override
    public void unapply(Hero hero) {
        if (!hero.hasEffect(this.getName())) {
            return;
        }
        hero.removeEffect(hero.getEffect(this.getName()));
    }

    public boolean hasPassive(Hero hero) {
        return hero.hasEffect(this.getName());
    }

    public class SkillListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onHeroChangeLevel(HeroChangeLevelEvent event) {
            PassiveSkill.this.tryApplying(event.getHero());
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onSkillLearnEvent(SkillLearnEvent event) {
            PassiveSkill.this.tryApplying(event.getHero());
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onSkillUnlearnEvent(SkillUnlearnEvent event) {
            PassiveSkill.this.tryApplying(event.getHero());
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onHeroSkillPrepare(SkillPrepareEvent event) {
            PassiveSkill.this.tryApplying(event.getHero());
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onHeroSkillUnprepare(SkillUnprepareEvent event) {
            PassiveSkill.this.tryApplying(event.getHero());
        }
    }

    protected class PassiveEffect
    extends Effect {
        protected PassiveEffect(Skill skill, Player applier, EffectType[] effectTypes) {
            super(skill, skill.getName(), applier, PassiveSkill.this.applyText, PassiveSkill.this.unapplyText, effectTypes);
            this.types.add(EffectType.INTERNAL);
            this.setPersistent(true);
        }
    }
}

