/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.api.events.HeroChangeLevelEvent;
import com.herocraftonline.heroes.api.events.SkillLearnEvent;
import com.herocraftonline.heroes.api.events.SkillPrepareEvent;
import com.herocraftonline.heroes.api.events.SkillUnlearnEvent;
import com.herocraftonline.heroes.api.events.SkillUnprepareEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;

public class OutsourcedSkill
extends Skill {
    private String[] permissions;
    private Permission permission;

    public OutsourcedSkill(Heroes plugin, String name) {
        super(plugin, name);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new SkillHeroListener(), (Plugin)plugin);
    }

    public void setPermissions(String[] permissions) {
        this.permissions = permissions;
        this.permission = this.plugin.getServer().getPluginManager().getPermission(this.getName());
        if (this.permission != null) {
            this.plugin.getServer().getPluginManager().removePermission(this.permission);
        }
        HashMap<String, Boolean> children = new HashMap<String, Boolean>();
        for (String permission : permissions) {
            children.put(permission, true);
        }
        this.permission = new Permission(this.getName(), "Permission-Skill " + this.getName(), children);
        this.plugin.getServer().getPluginManager().addPermission(this.permission);
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        return true;
    }

    @Override
    public void init() {
    }

    public void tryLearningSkill(Hero hero) {
        if (this.permissions == null) {
            Heroes.log(Level.SEVERE, "No permissions detected for skill: " + this.getName() + " fix your config!");
            return;
        }
        if (hero.canUseSkill(this)) {
            hero.addPermission(this.permission.getName());
        } else {
            hero.removePermission(this.permission.getName());
        }
    }

    @Override
    public String getDescription(Hero hero) {
        return this.getDescription();
    }

    public class SkillHeroListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onClassChange(final ClassChangeEvent event) {
            if (event.isCancelled()) {
                return;
            }
            OutsourcedSkill.this.plugin.getServer().getScheduler().runTask((Plugin)OutsourcedSkill.this.plugin, new Runnable(){

                @Override
                public void run() {
                    OutsourcedSkill.this.tryLearningSkill(event.getHero());
                }
            });
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onHeroChangeLevel(final HeroChangeLevelEvent event) {
            OutsourcedSkill.this.plugin.getServer().getScheduler().runTask((Plugin)OutsourcedSkill.this.plugin, new Runnable(){

                @Override
                public void run() {
                    OutsourcedSkill.this.tryLearningSkill(event.getHero());
                }
            });
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onSkillLearnEvent(final SkillLearnEvent event) {
            OutsourcedSkill.this.plugin.getServer().getScheduler().runTask((Plugin)OutsourcedSkill.this.plugin, new Runnable(){

                @Override
                public void run() {
                    OutsourcedSkill.this.tryLearningSkill(event.getHero());
                }
            });
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onSkillUnlearnEvent(final SkillUnlearnEvent event) {
            OutsourcedSkill.this.plugin.getServer().getScheduler().runTask((Plugin)OutsourcedSkill.this.plugin, new Runnable(){

                @Override
                public void run() {
                    OutsourcedSkill.this.tryLearningSkill(event.getHero());
                }
            });
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onHeroSkillPrepare(final SkillPrepareEvent event) {
            OutsourcedSkill.this.plugin.getServer().getScheduler().runTask((Plugin)OutsourcedSkill.this.plugin, new Runnable(){

                @Override
                public void run() {
                    OutsourcedSkill.this.tryLearningSkill(event.getHero());
                }
            });
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onHeroSkillUnprepare(final SkillUnprepareEvent event) {
            OutsourcedSkill.this.plugin.getServer().getScheduler().runTask((Plugin)OutsourcedSkill.this.plugin, new Runnable(){

                @Override
                public void run() {
                    OutsourcedSkill.this.tryLearningSkill(event.getHero());
                }
            });
        }
    }
}

