/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.google.common.base.Preconditions;
import com.herocraftonline.heroes.api.events.SkillChangeLevelEvent;
import com.herocraftonline.heroes.api.events.SkillLearnEvent;
import com.herocraftonline.heroes.api.events.SkillUnlearnEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.ClassSkill;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class HeroSkill {
    public static final int MIN_SKILL_LEVEL = 1;
    private final Hero hero;
    private final ClassSkill classSkill;
    private boolean learned = false;
    private int level = 1;

    public HeroSkill(Hero hero, ClassSkill classSkill) {
        this.hero = (Hero)Preconditions.checkNotNull((Object)hero);
        this.classSkill = (ClassSkill)Preconditions.checkNotNull((Object)classSkill);
        hero.getStorage().loadHeroLearnedSkill(this);
    }

    public Hero getHero() {
        return this.hero;
    }

    public ClassSkill getClassSkill() {
        return this.classSkill;
    }

    public HeroClass getHeroClass() {
        return this.classSkill.getHeroClass();
    }

    public Skill getSkill() {
        return this.classSkill.getSkill();
    }

    public boolean isLearned() {
        return this.learned;
    }

    public boolean canLearn() {
        if (this.learned) {
            return false;
        }
        if (!this.classSkill.learnedUse()) {
            return false;
        }
        return this.classSkill.getUseLevel() <= this.hero.getHeroLevel(this.classSkill.getHeroClass());
    }

    public boolean learn() {
        return this.learn(false);
    }

    public boolean adminLearn() {
        return this.learn(true);
    }

    private boolean learn(boolean adminCommand) {
        if (!this.canLearn()) {
            return false;
        }
        SkillLearnEvent event = new SkillLearnEvent(this, adminCommand);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.learned = true;
        this.hero.getStorage().addHeroLearnedSkill(this);
        return true;
    }

    public boolean unlearn() {
        if (!this.learned) {
            return false;
        }
        this.learned = false;
        this.hero.getStorage().removeHeroLearnedSkill(this);
        Bukkit.getPluginManager().callEvent((Event)new SkillUnlearnEvent(this));
        return true;
    }

    public boolean setLearned(boolean learned) {
        if (learned) {
            return this.learn();
        }
        return this.unlearn();
    }

    public int getLevel() {
        return this.level;
    }

    public int getMaxLevel() {
        return this.classSkill.getMaxSkillLevel();
    }

    public boolean setLevel(int level) {
        return this.setLevel(level, false);
    }

    public boolean adminSetLevel(int level) {
        return this.setLevel(level, true);
    }

    private boolean setLevel(int level, boolean adminCommand) {
        if (level < 1) {
            level = 1;
        } else if (level > this.getMaxLevel()) {
            level = this.getMaxLevel();
        }
        if (level == this.level) {
            return false;
        }
        SkillChangeLevelEvent event = new SkillChangeLevelEvent(this, this.level, level, adminCommand);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.level = level;
        if (this.hero.getRemainingSkillPreparePoints() < 0) {
            this.hero.clearPreparedSkills();
        }
        this.hero.getStorage().addHeroLearnedSkill(this);
        return true;
    }

    public boolean isMastered() {
        return this.getLevel() == this.classSkill.getMaxSkillLevel();
    }

    public int getPrepareCost() {
        return this.classSkill.getPrepareCost(this.level);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getSkill().getName());
        int maxLevel = this.classSkill.getMaxSkillLevel();
        if (maxLevel > 1) {
            builder.append(' ').append(this.level);
        }
        return builder.toString();
    }
}

