/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class GhostManager {
    private static final String GHOST_TEAM_NAME = "Ghosts";
    private static final long UPDATE_DELAY = 20L;
    private static final OfflinePlayer[] EMPTY_PLAYERS = new OfflinePlayer[0];
    private Team ghostTeam;
    private BukkitTask task;
    private boolean closed;
    private Set<String> ghosts = new HashSet<String>();

    public GhostManager(Plugin plugin) {
        this.createTask(plugin);
        this.createGetTeam();
    }

    private void createGetTeam() {
        Scoreboard board = Bukkit.getServer().getScoreboardManager().getMainScoreboard();
        this.ghostTeam = board.getTeam(GHOST_TEAM_NAME);
        if (this.ghostTeam == null) {
            this.ghostTeam = board.registerNewTeam(GHOST_TEAM_NAME);
            this.ghostTeam.setCanSeeFriendlyInvisibles(true);
        }
    }

    private void createTask(Plugin plugin) {
        this.task = Bukkit.getScheduler().runTaskTimer(plugin, new Runnable(){

            @Override
            public void run() {
                for (OfflinePlayer member : GhostManager.this.getMembers()) {
                    Player player = member.getPlayer();
                    if (player != null) {
                        GhostManager.this.setGhost(player, GhostManager.this.isGhost(player));
                        continue;
                    }
                    GhostManager.this.ghosts.remove(member.getName());
                    GhostManager.this.ghostTeam.removePlayer(member);
                }
            }
        }, 20L, 20L);
    }

    public void clearMembers() {
        if (this.ghostTeam != null) {
            for (OfflinePlayer player : this.getMembers()) {
                this.ghostTeam.removePlayer(player);
            }
        }
    }

    public void addPlayer(Player player) {
        this.validateState();
        if (!this.ghostTeam.hasPlayer((OfflinePlayer)player)) {
            this.ghostTeam.addPlayer((OfflinePlayer)player);
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 15));
        }
    }

    public boolean isGhost(Player player) {
        return player != null && this.hasPlayer(player) && this.ghosts.contains(player.getName());
    }

    public boolean hasPlayer(Player player) {
        this.validateState();
        return this.ghostTeam.hasPlayer((OfflinePlayer)player);
    }

    public void setGhost(Player player, boolean isGhost) {
        if (!this.hasPlayer(player)) {
            this.addPlayer(player);
        }
        if (isGhost) {
            this.ghosts.add(player.getName());
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 15));
        } else {
            this.ghosts.remove(player.getName());
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
        }
    }

    public void removePlayer(Player player) {
        this.validateState();
        if (this.ghostTeam.removePlayer((OfflinePlayer)player)) {
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
        }
    }

    public OfflinePlayer[] getGhosts() {
        this.validateState();
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>(this.ghostTeam.getPlayers());
        Iterator it = players.iterator();
        while (it.hasNext()) {
            if (this.ghosts.contains(((OfflinePlayer)it.next()).getName())) continue;
            it.remove();
        }
        return this.toArray(players);
    }

    public OfflinePlayer[] getMembers() {
        this.validateState();
        return this.toArray(this.ghostTeam.getPlayers());
    }

    private OfflinePlayer[] toArray(Set<OfflinePlayer> players) {
        if (players != null) {
            return players.toArray(new OfflinePlayer[players.size()]);
        }
        return EMPTY_PLAYERS;
    }

    public void close() {
        if (!this.closed) {
            this.task.cancel();
            this.ghostTeam.unregister();
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void validateState() {
        if (this.closed) {
            throw new IllegalStateException("Ghost factory has closed. Cannot reuse instances.");
        }
    }
}

