/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;

public class DelayedSkill
implements Delayed {
    private final String identifier;
    private final String[] args;
    private final long readyTime;
    private final Skill skill;
    private final Hero hero;

    public DelayedSkill(String identifier, Hero hero, long warmup, Skill skill, String[] args) {
        this.identifier = identifier;
        this.hero = hero;
        this.args = args;
        this.skill = skill;
        this.readyTime = System.currentTimeMillis() + warmup;
    }

    public boolean isReady() {
        return System.currentTimeMillis() >= this.readyTime;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.readyTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        DelayedSkill that = (DelayedSkill)other;
        return (int)(this.readyTime - that.readyTime);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getArgs() {
        return this.args;
    }

    public Skill getSkill() {
        return this.skill;
    }

    public Hero getHero() {
        return this.hero;
    }

    public Player getPlayer() {
        return this.hero.getPlayer();
    }
}

