/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.api.events.SkillCompleteEvent;
import com.herocraftonline.heroes.api.events.SkillUseEvent;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.ClassSkill;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.classes.scaling.ExpressionScaling;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.effects.common.SlowEffect;
import com.herocraftonline.heroes.characters.skill.DelayedSkill;
import com.herocraftonline.heroes.characters.skill.DelayedTargettedSkill;
import com.herocraftonline.heroes.characters.skill.HeroSkill;
import com.herocraftonline.heroes.characters.skill.RecastData;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.characters.skill.TargettedSkill;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.util.MaterialUtil;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class ActiveSkill
extends Skill {
    private static final String CASTING_EFFECT_NAME = "Casting";
    private static final String RECASTING_EFFECT_NAME_PREFIX = "Recasting_";
    private String useText;
    private String delayText;
    private String interruptText;
    private String toggleableEffectName;
    private final String recastingEffectName;
    private Map<UUID, RecastData> playerRecasts = new HashMap<UUID, RecastData>();
    private final boolean awardExpOnCast = true;

    public static void removeCastingEffect(Hero hero) {
        hero.removeEffect(hero.getEffect(CASTING_EFFECT_NAME));
    }

    public ActiveSkill(Heroes plugin, String name) {
        super(plugin, name);
        this.recastingEffectName = RECASTING_EFFECT_NAME_PREFIX + name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        SkillResult skillResult;
        Long expiry;
        int cooldown;
        if (!(sender instanceof Player)) {
            return false;
        }
        String name = this.getName();
        Player player = (Player)sender;
        CharacterManager hm = this.plugin.getCharacterManager();
        Hero hero = hm.getHero(player);
        if (hero == null) {
            Messaging.send((CommandSender)player, "You are not a hero.", new Object[0]);
            return false;
        }
        if (player.getHealth() <= 0.0 || player.isDead()) {
            return true;
        }
        if (hero.getDelayedSkill() == null && this.isRecasting(hero)) {
            RecastData data = this.playerRecasts.get(player.getUniqueId());
            if (!data.isReady()) {
                if (data.isNeverReady()) {
                    Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "$1 recast [$2] is not ready for use!", name, data.getName());
                    return true;
                } else {
                    String readyDelaySeconds = Util.decFormatCDs.format((double)data.getReadyDelay() / 1000.0);
                    Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "$1 recast [$2] can be used in $3 seconds!", name, data.getName(), readyDelaySeconds);
                }
                return true;
            }
            this.recast(hero, data);
            return true;
        }
        if (!hero.hasAccessToSkill(this)) {
            Messaging.send((CommandSender)player, "Your classes don't have access to the skill: $1.", name);
            return true;
        }
        HeroSkill primaryHeroSkill = hero.getHeroSkillForPrimary(name);
        HeroSkill secondaryHeroSkill = hero.getHeroSkillForSecondary(name);
        HeroSkill raceHeroSkill = hero.getHeroSkillForRace(name);
        HeroSkill globalHeroSkill = hero.getHeroSkillForGlobal(name);
        ClassSkill primaryClassSkill = primaryHeroSkill != null ? primaryHeroSkill.getClassSkill() : null;
        ClassSkill secondaryClassSkill = secondaryHeroSkill != null ? secondaryHeroSkill.getClassSkill() : null;
        ClassSkill raceClassSkill = raceHeroSkill != null ? raceHeroSkill.getClassSkill() : null;
        ClassSkill globalClassSkill = globalHeroSkill != null ? globalHeroSkill.getClassSkill() : null;
        boolean primaryLevelMet = false;
        boolean secondaryLevelMet = false;
        boolean raceLevelMet = false;
        boolean globalLevelMet = false;
        int useLevel = Integer.MAX_VALUE;
        if (primaryClassSkill != null) {
            if (primaryClassSkill.getUseLevel() < useLevel) {
                useLevel = primaryClassSkill.getUseLevel();
            }
            if (hero.getHeroLevel(primaryClassSkill.getHeroClass()) >= primaryClassSkill.getUseLevel()) {
                primaryLevelMet = true;
            }
        }
        if (secondaryClassSkill != null) {
            if (secondaryClassSkill.getUseLevel() < useLevel) {
                useLevel = secondaryClassSkill.getUseLevel();
            }
            if (hero.getHeroLevel(secondaryClassSkill.getHeroClass()) >= secondaryClassSkill.getUseLevel()) {
                secondaryLevelMet = true;
            }
        }
        if (raceClassSkill != null) {
            if (raceClassSkill.getUseLevel() < useLevel) {
                useLevel = raceClassSkill.getUseLevel();
            }
            if (hero.getHeroLevel(raceClassSkill.getHeroClass()) >= raceClassSkill.getUseLevel()) {
                raceLevelMet = true;
            }
        }
        if (globalClassSkill != null) {
            if (globalClassSkill.getUseLevel() < useLevel) {
                useLevel = globalClassSkill.getUseLevel();
            }
            if (hero.getHeroLevel(hero.getHeroClass()) >= globalClassSkill.getUseLevel()) {
                globalLevelMet = true;
            }
        }
        if (!(primaryLevelMet || secondaryLevelMet || raceLevelMet || globalLevelMet)) {
            this.messageAndEvent(hero, new SkillResult(SkillResult.ResultType.LOW_LEVEL, true, useLevel));
            return true;
        }
        Boolean isLearned = null;
        if (primaryLevelMet && primaryClassSkill.learnedUse()) {
            isLearned = primaryHeroSkill.isLearned();
        }
        if (secondaryLevelMet && secondaryClassSkill.learnedUse()) {
            isLearned = isLearned != null && isLearned != false || secondaryHeroSkill.isLearned();
        }
        if (raceLevelMet && raceClassSkill.learnedUse()) {
            isLearned = isLearned != null && isLearned != false || raceHeroSkill.isLearned();
        }
        if (globalLevelMet && globalClassSkill.learnedUse()) {
            isLearned = isLearned != null && isLearned != false || globalHeroSkill.isLearned();
        }
        if (isLearned != null && !isLearned.booleanValue()) {
            this.messageAndEvent(hero, SkillResult.NOT_LEARNED);
            return true;
        }
        if ((primaryClassSkill != null && primaryClassSkill.preparedUse() || secondaryClassSkill != null && secondaryClassSkill.preparedUse() || raceClassSkill != null && raceClassSkill.preparedUse() || globalClassSkill != null && globalClassSkill.preparedUse()) && !hero.isSkillPrepared(name)) {
            this.messageAndEvent(hero, SkillResult.NOT_PREPARED);
            return true;
        }
        long time = System.currentTimeMillis();
        Long globalCooldown = hero.getCooldown("global");
        if (hero.getDelayedSkill() == null) {
            if (globalCooldown != null && time < globalCooldown) {
                String timeRemaining = Util.decFormatCDs.format((double)(globalCooldown - time) / 1000.0);
                this.messageAndEvent(hero, new SkillResult(SkillResult.ResultType.ON_GLOBAL_COOLDOWN, true, timeRemaining));
                return true;
            }
            if (this.hasEffectToToggle(hero)) {
                this.onSkillEffectToggle(hero);
                this.messageAndEvent(hero, new SkillResult(SkillResult.ResultType.REMOVED_EFFECT, false, new Object[0]));
                return true;
            }
        }
        if ((cooldown = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.COOLDOWN, 0, true)) > 0 && this.isCoolDownRequired(args) && (expiry = hero.getCooldown(name)) != null && time < expiry) {
            long remaining = expiry - time;
            String timeRemaining = Util.decFormatCDs.format((double)remaining / 1000.0);
            this.messageAndEvent(hero, new SkillResult(SkillResult.ResultType.ON_COOLDOWN, true, name, timeRemaining));
            return false;
        }
        int delay = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.DELAY, 0, true);
        if (hero.isInCombat() && SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.NO_COMBAT_USE, false)) {
            DelayedSkill dSkill;
            if (delay > 0 && (dSkill = hero.getDelayedSkill()) != null && dSkill.getSkill().equals(this)) {
                hero.cancelDelayedSkill();
            }
            this.messageAndEvent(hero, SkillResult.NO_COMBAT);
            return true;
        }
        int manaCost = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MANA, 0, true);
        double manaReduce = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MANA_REDUCE_PER_LEVEL, 0.0, false) * (double)hero.getHeroLevel(this);
        ItemStack itemStack = this.getReagentCost(hero);
        double healthCost = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.HEALTH_COST, 0, true);
        int staminaCost = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.STAMINA, 0, true);
        SkillUseEvent skillEvent = new SkillUseEvent((Skill)this, player, hero, manaCost -= (int)manaReduce, healthCost, staminaCost, itemStack, args);
        this.plugin.getServer().getPluginManager().callEvent((Event)skillEvent);
        if (skillEvent.isCancelled()) {
            this.messageAndEvent(hero, SkillResult.CANCELLED);
            return true;
        }
        boolean cancelDelayedSkillOnFailure = false;
        DelayedSkill dSkill = hero.getDelayedSkill();
        if (dSkill != null && dSkill.getSkill().equals(this)) {
            cancelDelayedSkillOnFailure = true;
        }
        if ((manaCost = skillEvent.getManaCost()) > hero.getMana()) {
            if (cancelDelayedSkillOnFailure) {
                hero.cancelDelayedSkill();
            }
            this.messageAndEvent(hero, SkillResult.LOW_MANA);
            return true;
        }
        healthCost = skillEvent.getHealthCost();
        if (healthCost > 0.0 && hero.getPlayer().getHealth() <= healthCost) {
            if (cancelDelayedSkillOnFailure) {
                hero.cancelDelayedSkill();
            }
            this.messageAndEvent(hero, SkillResult.LOW_HEALTH);
            return true;
        }
        staminaCost = skillEvent.getStaminaCost();
        if (staminaCost > 0 && hero.getStamina() < staminaCost) {
            if (cancelDelayedSkillOnFailure) {
                hero.cancelDelayedSkill();
            }
            this.messageAndEvent(hero, SkillResult.LOW_STAMINA);
            return true;
        }
        itemStack = skillEvent.getReagentCost();
        if (itemStack != null && itemStack.getAmount() != 0 && !this.hasReagentCost(player, itemStack)) {
            ItemMeta reagentMeta;
            if (cancelDelayedSkillOnFailure) {
                hero.cancelDelayedSkill();
            }
            Object reagentName = MaterialUtil.getFriendlyName(itemStack.getType());
            if (itemStack.hasItemMeta() && (reagentMeta = itemStack.getItemMeta()).hasDisplayName()) {
                reagentName = (String)reagentName + " (named \"" + reagentMeta.getDisplayName() + "\")";
            }
            this.messageAndEvent(hero, new SkillResult(SkillResult.ResultType.MISSING_REAGENT, true, String.valueOf(itemStack.getAmount()), reagentName));
            return true;
        }
        dSkill = null;
        if (delay > 0 && hero.getDelayedSkill() == null && this.isWarmupRequired(args)) {
            if (!this.addDelayedSkill(hero, delay, identifier, args)) return true;
            this.onWarmup(hero);
            this.messageAndEvent(hero, SkillResult.START_DELAY);
            if (!Heroes.properties.slowCasting || this.isType(SkillType.ABILITY_PROPERTY_SONG)) return true;
            hero.addEffect(new CastingEffect(this, player, delay));
            return true;
        }
        if (hero.getDelayedSkill() != null) {
            dSkill = hero.getDelayedSkill();
            if (!dSkill.getSkill().equals(this)) return false;
            if (!dSkill.isReady()) return true;
            if (!this.isType(SkillType.ABILITY_PROPERTY_SONG)) {
                ActiveSkill.removeCastingEffect(hero);
            }
            hm.cancelDelayedSkill(dSkill);
        }
        if (dSkill instanceof DelayedTargettedSkill) {
            DelayedTargettedSkill dtSkill = (DelayedTargettedSkill)dSkill;
            skillResult = ((TargettedSkill)this).useDelayed(hero, dtSkill.getTarget(), args, dtSkill.getFlags());
        } else {
            skillResult = this.use(hero, args);
        }
        if (skillResult.type == SkillResult.ResultType.NORMAL) {
            time = System.currentTimeMillis();
            boolean isRecasting = this.isRecasting(hero);
            if (!isRecasting && cooldown > 0 && (cooldown = this.alterAppliedCooldown(hero, cooldown)) > 0) {
                hero.setCooldown(name, time + (long)cooldown);
                if (Heroes.properties.debug) {
                    Heroes.debugLog(Level.INFO, hero.getName() + " used skill: " + this.getName() + " cooldown until: " + time + cooldown);
                }
            }
            if (Heroes.properties.globalCooldown > 0) {
                hero.setCooldown("global", (long)Heroes.properties.globalCooldown + time);
            }
            Objects.requireNonNull(this);
            this.awardExp(hero);
            if (manaCost > 0) {
                hero.setMana(hero.getMana() - manaCost);
                if (hero.isVerboseMana()) {
                    hero.getPlayer().sendMessage(ChatComponents.Bars.mana(hero.getMana(), hero.getMaxMana(), true));
                }
            }
            if (healthCost > 0.0) {
                player.setHealth(player.getHealth() - healthCost);
            }
            if (staminaCost > 0) {
                hero.setStamina(hero.getStamina() - staminaCost);
                if (hero.isVerboseStamina()) {
                    hero.getPlayer().sendMessage(ChatComponents.Bars.stamina(hero.getStamina(), hero.getMaxStamina(), true));
                }
            }
            if (itemStack != null && itemStack.getAmount() > 0) {
                player.getInventory().removeItem(new ItemStack[]{itemStack});
                player.updateInventory();
            }
            if (!isRecasting) {
                this.finalizeSkillUse(hero);
            }
        }
        this.messageAndEvent(hero, skillResult);
        return true;
    }

    public void applyInterruptCost(Hero hero) {
        this.applyInterruptCost(hero, null);
    }

    public void applyInterruptCost(Hero hero, Long interruptCd) {
        ItemStack itemStack;
        int staminaCost;
        double healthCost;
        int manaCost;
        long time = System.currentTimeMillis();
        int naturalInterruptCdCost = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.INTERRUPT_COOLDOWN, 0, true);
        if (naturalInterruptCdCost > 0 || interruptCd != null && interruptCd > 0L) {
            if (interruptCd == null || interruptCd <= 0L || (long)naturalInterruptCdCost > interruptCd) {
                hero.setCooldown(this.getName(), time + (long)naturalInterruptCdCost);
            } else {
                hero.setCooldown(this.getName(), time + interruptCd);
            }
        }
        if ((manaCost = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.INTERRUPT_MANA, 0, true)) > 0) {
            hero.setMana(hero.getMana() - manaCost);
            if (hero.isVerboseMana()) {
                hero.getPlayer().sendMessage(ChatComponents.Bars.mana(hero.getMana(), hero.getMaxMana(), true));
            }
        }
        if ((healthCost = (double)SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.INTERRUPT_HEALTH, 0, true)) > 0.0) {
            hero.getPlayer().setHealth(hero.getPlayer().getHealth() - healthCost);
        }
        if ((staminaCost = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.INTERRUPT_STAMINA, 0, true)) > 0) {
            hero.setStamina(hero.getStamina() - staminaCost);
            if (hero.isVerboseStamina()) {
                hero.getPlayer().sendMessage(ChatComponents.Bars.stamina(hero.getStamina(), hero.getMaxStamina(), true));
            }
        }
        if ((itemStack = this.getReagentCost(hero, true)) != null && itemStack.getAmount() > 0) {
            hero.getPlayer().getInventory().removeItem(new ItemStack[]{itemStack});
            hero.getPlayer().updateInventory();
        }
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection section = super.getDefaultConfig();
        section.set(SkillSetting.USE_TEXT.node(), (Object)(ChatComponents.GENERIC_SKILL + "%hero% used %skill%!"));
        return section;
    }

    protected boolean addDelayedSkill(Hero hero, int delay, String identifier, String[] args) {
        DelayedSkill dSkill = new DelayedSkill(identifier, hero, delay, this, args);
        Player player = hero.getPlayer();
        String text = this.getDelayText();
        if (text != null && !text.isEmpty()) {
            if (hero.hasEffectType(EffectType.SILENT_ACTIONS)) {
                Messaging.send((CommandSender)player, "    " + text, player.getName(), this.getName());
            } else {
                this.broadcast(player.getLocation(), "    " + text, player.getName(), this.getName());
            }
        }
        this.plugin.getCharacterManager().queueDelayedSkill(dSkill);
        hero.setDelayedSkill(dSkill);
        return true;
    }

    public String getUseText() {
        return this.useText;
    }

    public void setUseText(String useText) {
        this.useText = useText;
    }

    public String getInterruptText() {
        return this.interruptText;
    }

    public void setInterruptText(String interruptText) {
        this.interruptText = interruptText;
    }

    public String getDelayText() {
        return this.delayText;
    }

    public void setDelayText(String delayText) {
        this.delayText = delayText;
    }

    @Override
    public void init() {
        String delayText = SkillConfigManager.getRaw((Skill)this, SkillSetting.DELAY_TEXT, ChatComponents.GENERIC_SKILL + "%hero% begins to use %skill%!");
        this.setDelayText(delayText.replace("%hero%", "$1").replace("%skill%", "$2"));
        String interruptText = SkillConfigManager.getRaw((Skill)this, SkillSetting.INTERRUPT_TEXT, ChatComponents.GENERIC_SKILL + "%hero% stopped using %skill%!");
        this.setInterruptText(interruptText.replace("%hero%", "$1").replace("%skill%", "$2"));
        String useText = SkillConfigManager.getRaw((Skill)this, SkillSetting.USE_TEXT, ChatComponents.GENERIC_SKILL + "%hero% used %skill%!");
        this.setUseText(useText.replace("%hero%", "$1").replace("%skill%", "$2"));
    }

    public abstract SkillResult use(Hero var1, String[] var2);

    public void setToggleableEffectName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Toggleable Effect Name must not be null");
        }
        this.toggleableEffectName = name;
    }

    public String getToggleableEffectName() {
        return this.toggleableEffectName;
    }

    public boolean hasEffectToToggle(Hero hero) {
        if (this.toggleableEffectName == null) {
            return false;
        }
        return hero.hasEffect(this.toggleableEffectName);
    }

    protected void onSkillEffectToggle(Hero hero) {
        if (this.toggleableEffectName == null) {
            return;
        }
        hero.removeEffect(hero.getEffect(this.toggleableEffectName));
    }

    protected void recast(Hero hero, RecastData data) {
    }

    public final boolean isRecasting(UUID playerId) {
        return this.playerRecasts.containsKey(playerId);
    }

    public final boolean isRecasting(Player player) {
        return this.isRecasting(player.getUniqueId());
    }

    public final boolean isRecasting(Hero hero) {
        return this.isRecasting(hero.getPlayer());
    }

    public final boolean isRecasting(UUID playerId, String name) {
        RecastData data = this.getRecastData(playerId);
        return data != null && data.getName().equals(name);
    }

    public final boolean isRecasting(Player player, String name) {
        return this.isRecasting(player.getUniqueId(), name);
    }

    public final boolean isRecasting(Hero hero, String name) {
        return this.isRecasting(hero.getPlayer(), name);
    }

    public final RecastData getRecastData(UUID playerId) {
        return this.playerRecasts.get(playerId);
    }

    public final RecastData getRecastData(Player player) {
        return this.getRecastData(player.getUniqueId());
    }

    public final RecastData getRecastData(Hero hero) {
        return this.getRecastData(hero.getPlayer());
    }

    protected final void startRecast(Hero hero, long duration, RecastData data) {
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        RecastData oldData = this.playerRecasts.put(hero.getPlayer().getUniqueId(), data);
        if (oldData != null) {
            this.onRecastEnd(hero, oldData);
        }
        this.onRecastStart(hero, data);
        this.applyRecastDuration(hero, duration);
    }

    protected final void startRecast(Hero hero, RecastData data) {
        this.startRecast(hero, -1L, data);
    }

    protected final void setRecastDuration(Hero hero, long duration) {
        if (this.isRecasting(hero)) {
            this.applyRecastDuration(hero, duration);
        }
    }

    protected final void setRecastPersistant(Hero hero) {
        this.setRecastDuration(hero, -1L);
    }

    protected final void endRecast(Hero hero) {
        if (this.isRecasting(hero)) {
            hero.removeEffect(hero.getEffect(this.recastingEffectName));
        }
    }

    protected void onRecastStart(Hero hero, RecastData data) {
    }

    protected void onRecastEnd(Hero hero, RecastData data) {
    }

    private void applyRecastDuration(Hero hero, long duration) {
        long appliedDuration = duration > 0L ? duration : 1L;
        Effect effect = hero.setEffectDuration(this.recastingEffectName, (Skill)this, hero.getPlayer(), appliedDuration, () -> new RecastingEffect(hero.getPlayer(), appliedDuration));
        effect.setPersistent(duration <= 0L);
    }

    private void awardExp(Hero hero) {
        if (hero.canGain(HeroClass.ExperienceType.SKILL)) {
            hero.gainExp(SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.EXP, 0, false), HeroClass.ExperienceType.SKILL, hero.getViewingLocation(1.0));
        }
    }

    protected int alterAppliedCooldown(Hero hero, int cooldown) {
        return cooldown;
    }

    protected void broadcastExecuteText(Hero hero) {
        Player player = hero.getPlayer();
        String text = this.getUseText();
        if (text != null && !text.isEmpty()) {
            if (hero.hasEffectType(EffectType.SILENT_ACTIONS)) {
                Messaging.send((CommandSender)player, "    " + text, player.getName(), this.getName());
            } else {
                this.broadcast(player.getLocation(), "    " + text, player.getName(), this.getName());
            }
        }
    }

    private void messageAndEvent(Hero hero, SkillResult result) {
        ActiveSkill.sendResultMessage(hero, this, result);
        if (result.equals(SkillResult.SKIP_POST_USAGE)) {
            return;
        }
        SkillCompleteEvent event = new SkillCompleteEvent(hero, this, result);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
    }

    public static void sendResultMessage(Hero hero, Skill skill, SkillResult result) {
        Player player = hero.getPlayer();
        if (!result.showMessage) {
            return;
        }
        switch (result.type) {
            case INVALID_TARGET: {
                Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "Invalid Target!", new Object[0]);
                break;
            }
            case LOW_HEALTH: {
                Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "Not enough health!", new Object[0]);
                break;
            }
            case LOW_LEVEL: {
                Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "You must be level $1 to do that.", result.args[0]);
                break;
            }
            case LOW_MANA: {
                Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "Not enough mana!", new Object[0]);
                break;
            }
            case LOW_STAMINA: {
                Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "You are too fatigued!", new Object[0]);
                break;
            }
            case ON_COOLDOWN: {
                Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "$1 has $2s until recovery!", result.args[0], result.args[1]);
                break;
            }
            case ON_GLOBAL_COOLDOWN: {
                Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "You must wait $1s before using another skill.", result.args[0]);
                break;
            }
            case MISSING_REAGENT: {
                Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "You need to have $1 $2 to use $3!", result.args[0], result.args[1], skill.getName());
                break;
            }
            case NO_COMBAT: {
                Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "You may not use that skill in combat!", new Object[0]);
                break;
            }
            case NOT_LEARNED: {
                Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "You must learn that skill before using!", new Object[0]);
                break;
            }
            case NOT_PREPARED: {
                Messaging.send((CommandSender)player, "    " + ChatComponents.GENERIC_SKILL + "You must prepare that skill before using!", new Object[0]);
                break;
            }
        }
    }

    public void onWarmup(Hero hero) {
    }

    protected void finalizeSkillUse(Hero hero) {
    }

    public boolean isWarmupRequired(String[] args) {
        return true;
    }

    public boolean isCoolDownRequired(String[] args) {
        return true;
    }

    public double getScaledHealing(Hero hero, double healing) {
        String expression;
        boolean scaledHealing = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.IS_SCALED_HEALING.node(), false);
        if (scaledHealing && !(expression = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.HEALING_SCALE_EXPRESSION.node(), "1")).equals("1")) {
            ExpressionScaling healingScaling = new ExpressionScaling(hero.getHeroClass(), expression);
            healing *= healingScaling.getScaled(hero);
        }
        return healing;
    }

    private static class CastingEffect
    extends SlowEffect {
        public CastingEffect(ActiveSkill skill, Player applier, long duration) {
            super((Skill)skill, ActiveSkill.CASTING_EFFECT_NAME, applier, duration, 4, false, Heroes.properties.noSprintWhileCasting);
            this.types.remove((Object)EffectType.HARMFUL);
            this.types.add(EffectType.INTERNAL);
            this.types.add(EffectType.BENEFICIAL);
        }

        @Override
        public void removeFromHero(Hero hero) {
            super.removeFromHero(hero);
        }
    }

    private class RecastingEffect
    extends ExpirableEffect {
        public RecastingEffect(Player applier, long duration) {
            super((Skill)ActiveSkill.this, ActiveSkill.this.recastingEffectName, applier, duration);
            this.types.add(EffectType.INTERNAL);
            this.types.add(EffectType.BENEFICIAL);
        }

        @Override
        public void removeFromHero(Hero hero) {
            RecastData data = ActiveSkill.this.playerRecasts.remove(hero.getPlayer().getUniqueId());
            ActiveSkill.this.onRecastEnd(hero, data);
            long time = System.currentTimeMillis();
            int cooldown = SkillConfigManager.getUseSetting(hero, (Skill)ActiveSkill.this, SkillSetting.COOLDOWN, 0, true);
            if (cooldown > 0 && (cooldown = ActiveSkill.this.alterAppliedCooldown(hero, cooldown)) > 0) {
                hero.setCooldown(ActiveSkill.this.getName(), time + (long)cooldown);
                if (Heroes.properties.debug) {
                    Heroes.debugLog(Level.INFO, hero.getName() + " finished recasting: " + this.getName() + " cooldown until: " + time + cooldown);
                }
            }
            ActiveSkill.this.finalizeSkillUse(hero);
        }
    }
}

