/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.party;

import com.dthielke.herochat.Channel;
import com.dthielke.herochat.ChannelChatEvent;
import com.dthielke.herochat.ChatCompleteEvent;
import com.dthielke.herochat.Chatter;
import com.dthielke.herochat.Herochat;
import com.dthielke.herochat.MessageFormatSupplier;
import com.dthielke.herochat.StandardChannel;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.milkbowl.vault.chat.Chat;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PartyChannel
extends StandardChannel {
    private static final Pattern msgPattern = Pattern.compile("(.*)<(.*)%1\\$s(.*)> %2\\$s");
    private static final String format = ChatColor.GREEN.toString() + "[Party] &f{L}{sender}" + ChatColor.DARK_AQUA.toString() + ": {msg}";
    private static final String announcement = ChatColor.GREEN.toString() + "[Party]" + ChatColor.DARK_AQUA.toString() + " {msg}";
    private String leader = "";

    public PartyChannel(MessageFormatSupplier formatSupplier, Chatter leader, Chatter ... chatters) {
        super(Herochat.getChannelManager().getStorage(), "party" + leader.getName(), "party" + leader.getName(), formatSupplier);
        this.leader = leader.getPlayer().getName();
        this.addMember(leader, false, false);
        for (Chatter chatter : chatters) {
            this.addMember(chatter, false, false);
        }
        this.setFormat(format);
    }

    public boolean addMember(Chatter chatter, boolean announce, boolean flagUpdate) {
        Hero leaderHero = Heroes.getInstance().getCharacterManager().getHero(Bukkit.getPlayer((String)this.leader));
        HeroParty party = leaderHero.getParty();
        return party.isPartyMember(Bukkit.getPlayer((String)chatter.getName())) && super.addMember(chatter, false, false);
    }

    public void addWorld(String world) {
    }

    public void announce(String message) {
        String colorized = message.replaceAll("(?i)&([a-fklmno0-9])", "\u00a7$1");
        message = this.applyFormat(announcement, "").replace("%2$s", colorized);
        for (Chatter member : this.getMembers()) {
            member.getPlayer().sendMessage(message);
        }
        Herochat.logChat((String)ChatColor.stripColor((String)message));
    }

    public String applyFormat(String format, String originalFormat) {
        format = format.replace("{msg}", "%2$s");
        Matcher matcher = msgPattern.matcher(originalFormat);
        format = matcher.matches() && matcher.groupCount() == 3 ? format.replace("{sender}", matcher.group(1) + matcher.group(2) + "%1$s" + matcher.group(3)) : format.replace("{sender}", "%1$s");
        format = format.replaceAll("(?i)&([a-fklmnor0-9])", "\u00a7$1");
        return format;
    }

    public String applyFormat(String format, String originalFormat, Player sender) {
        format = this.applyFormat(format, originalFormat);
        Chat chat = Herochat.getChatService();
        if (chat != null) {
            try {
                String groupSuffix;
                String group;
                String groupPrefix;
                String suffix;
                String prefix = chat.getPlayerPrefix(sender);
                if (StringUtils.isNotEmpty((String)prefix)) {
                    prefix = chat.getPlayerPrefix(null, (OfflinePlayer)sender);
                }
                if (StringUtils.isNotEmpty((String)(suffix = chat.getPlayerSuffix(sender)))) {
                    suffix = chat.getPlayerSuffix(null, (OfflinePlayer)sender);
                }
                String string = groupPrefix = (group = chat.getPrimaryGroup(sender)) == null ? "" : chat.getGroupPrefix(sender.getWorld(), group);
                if (group != null && StringUtils.isNotEmpty((String)groupPrefix)) {
                    groupPrefix = chat.getGroupPrefix((String)null, group);
                }
                String string2 = groupSuffix = group == null ? "" : chat.getGroupSuffix(sender.getWorld(), group);
                if (group != null && StringUtils.isNotEmpty((String)groupSuffix)) {
                    groupSuffix = chat.getGroupSuffix((String)null, group);
                }
                format = format.replace("{prefix}", prefix == null ? "" : prefix.replace("%", "%%"));
                format = format.replace("{suffix}", suffix == null ? "" : suffix.replace("%", "%%"));
                format = format.replace("{group}", group == null ? "" : group.replace("%", "%%"));
                format = format.replace("{groupprefix}", groupPrefix == null ? "" : groupPrefix.replace("%", "%%"));
                format = format.replace("{groupsuffix}", groupSuffix == null ? "" : groupSuffix.replace("%", "%%"));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        } else {
            format = format.replace("{prefix}", "");
            format = format.replace("{suffix}", "");
            format = format.replace("{group}", "");
            format = format.replace("{groupprefix}", "");
            format = format.replace("{groupsuffix}", "");
        }
        format = format.replace("{L}", sender.getName().equals(this.leader) ? "&3[&e\u272e&3]&4 " : "");
        format = format.replaceAll("(?i)&([a-fklmno0-9])", "\u00a7$1");
        return format;
    }

    public boolean banMember(Chatter chatter, boolean announce) {
        return false;
    }

    public Set<String> getBans() {
        return new HashSet<String>();
    }

    public int getDistance() {
        return 0;
    }

    public Set<String> getModerators() {
        return new HashSet<String>();
    }

    public Set<String> getMutes() {
        return new HashSet<String>();
    }

    public String getPassword() {
        return "";
    }

    public Set<String> getWorlds() {
        return new HashSet<String>();
    }

    public boolean isCrossWorld() {
        return true;
    }

    public boolean hasWorld(World world) {
        return true;
    }

    @Deprecated
    public boolean isBanned(String name) {
        return false;
    }

    public boolean isBanned(UUID name) {
        return false;
    }

    public boolean isHidden() {
        return true;
    }

    public boolean isLocal() {
        return false;
    }

    @Deprecated
    public boolean isModerator(String name) {
        return false;
    }

    public boolean isModerator(UUID name) {
        return false;
    }

    @Deprecated
    public boolean isMuted(String name) {
        return false;
    }

    public boolean isMuted(UUID name) {
        return false;
    }

    public boolean isShortcutAllowed() {
        return false;
    }

    public boolean isTransient() {
        return true;
    }

    public boolean kickMember(Chatter chatter, boolean announce) {
        return false;
    }

    public void processChat(ChannelChatEvent event) {
        Player player = event.getSender().getPlayer();
        String format = this.applyFormat(event.getFormat(), event.getBukkitFormat(), player);
        Chatter sender = Herochat.getChatterManager().getChatter(player);
        HashSet<Chatter> recipients = new HashSet<Chatter>(this.getMembers());
        this.trimRecipients(recipients, sender);
        String msg = String.format(format, player.getName(), event.getMessage());
        for (Chatter chatter : recipients) {
            chatter.getPlayer().sendMessage(msg);
        }
        Bukkit.getPluginManager().callEvent((Event)new ChatCompleteEvent(sender, (Channel)this, msg));
        Herochat.logChat((String)msg);
    }

    public boolean removeMember(Chatter chatter, boolean announce, boolean flagUpdate) {
        if (super.removeMember(chatter, false, flagUpdate)) {
            int count;
            if (chatter.getActiveChannel() == null || chatter.getActiveChannel().equals((Object)this)) {
                Channel newFocus = chatter.getLastFocusableChannel();
                if (newFocus == null || newFocus.equals((Object)this)) {
                    newFocus = Herochat.getChannelManager().getDefaultChannel();
                }
                chatter.setActiveChannel(newFocus, true, true);
            }
            if ((count = this.getMembers().size()) == 1) {
                Chatter otherMember = (Chatter)this.getMembers().iterator().next();
                this.removeMember(otherMember, false, flagUpdate);
                if (otherMember.getActiveChannel() != null && otherMember.getActiveChannel().equals((Object)this)) {
                    Channel focus = otherMember.getLastActiveChannel();
                    otherMember.setActiveChannel(focus != null ? focus : Herochat.getChannelManager().getDefaultChannel(), true, flagUpdate);
                }
                Herochat.getChannelManager().removeChannel((Channel)this);
            }
            return true;
        }
        return false;
    }

    public void removeWorld(String world) {
    }

    @Deprecated
    public void setBanned(String name, boolean banned) {
    }

    public void setBanned(UUID name, boolean banned) {
    }

    public void setBans(Set<String> bans) {
    }

    @Deprecated
    public void setModerator(String name, boolean moderator) {
    }

    public void setModerator(UUID name, boolean moderator) {
    }

    public void setModerators(Set<String> moderators) {
    }

    @Deprecated
    public void setMuted(String name, boolean muted) {
    }

    public void setMuted(UUID name, boolean muted) {
    }

    public void setMutes(Set<String> mutes) {
    }

    public void setNick(String nick) {
    }

    public void setPassword(String password) {
    }

    public void setShortcutAllowed(boolean shortcutAllowed) {
    }

    public void setWorlds(Set<String> worlds) {
    }

    private void trimRecipients(Set<Chatter> recipients, Chatter sender) {
        Iterator<Chatter> iterator = recipients.iterator();
        while (iterator.hasNext()) {
            Chatter recipient = iterator.next();
            if (recipient == null || !recipient.isIgnoring(sender)) continue;
            iterator.remove();
        }
    }
}

