/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.party;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroLeavePartyEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.party.PartyChannelManager;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import to.hc.common.bukkit.ui.ManagedScoreboard;

public class HeroParty {
    private final Heroes plugin;
    private Hero leader;
    private final Set<Hero> members = new HashSet<Hero>();
    private final LinkedList<String> invites = new LinkedList();
    private Boolean noPvp = true;
    private boolean herochat = Heroes.herochat != null;
    private PartyChannelManager channelManager;

    public HeroParty(Hero leader, Heroes plugin) {
        this.plugin = plugin;
        this.leader = leader;
        this.members.add(leader);
        leader.setParty(this);
        this.channelManager = plugin.getPartyChannelManager();
        if (this.channelManager != null) {
            this.channelManager.makeNewPartyChannel(this);
        }
        if (this.herochat) {
            this.channelManager.addMember(this, leader);
        }
    }

    public void addInvite(String player) {
        this.invites.add(player);
    }

    public void addMember(Hero hero) {
        if (this.members.size() == Heroes.properties.maxPartySize) {
            return;
        }
        this.members.add(hero);
        if (this.herochat) {
            this.channelManager.addMember(this, hero);
        }
        hero.setParty(this);
        this.update();
    }

    public int getInviteCount() {
        return this.invites.size();
    }

    public Hero getLeader() {
        return this.leader;
    }

    public Set<Hero> getMembers() {
        return new HashSet<Hero>(this.members);
    }

    public boolean isInvited(String player) {
        return this.invites.contains(player);
    }

    public Boolean isNoPvp() {
        return this.noPvp;
    }

    public boolean isPartyMember(Hero hero) {
        return this.members.contains(hero);
    }

    public boolean isPartyMember(Player player) {
        for (Hero hero : this.members) {
            if (!hero.getPlayer().equals(player)) continue;
            return true;
        }
        return false;
    }

    public void messageParty(String message) {
        if (this.herochat) {
            this.channelManager.messageParty(this, message);
        } else {
            for (Hero hero : this.members) {
                hero.getPlayer().sendMessage(message);
            }
        }
    }

    @Deprecated
    public void messageParty(String msg, Object ... params) {
        if (this.herochat) {
            this.channelManager.messageParty(this, msg, params);
        } else {
            for (Hero hero : this.members) {
                Messaging.send((CommandSender)hero.getPlayer(), msg, params);
            }
        }
    }

    public void pvpToggle() {
        if (this.noPvp.booleanValue()) {
            this.noPvp = false;
            this.messageParty(ChatColor.GRAY + "PvP is now " + ChatColor.GREEN + "enabled" + ChatColor.GRAY + "!");
        } else {
            this.noPvp = true;
            this.messageParty(ChatColor.GRAY + "PvP is now " + ChatColor.RED + "disabled" + ChatColor.GRAY + "!");
        }
    }

    public void removeInvite(Player player) {
        this.invites.remove(player.getName());
    }

    public void removeMember(Hero hero) {
        this.members.remove(hero);
        hero.setParty(null);
        if (this.herochat) {
            this.channelManager.removeMember(this, hero);
        }
        if (this.members.size() == 1) {
            Hero remainingMember = this.members.iterator().next();
            if (this.herochat) {
                this.channelManager.removeChannel(this, remainingMember);
            }
            this.plugin.getServer().getPluginManager().callEvent((Event)new HeroLeavePartyEvent(remainingMember, this, HeroLeavePartyEvent.LeavePartyReason.SYSTEM));
            remainingMember.setParty(null);
            this.messageParty(ChatColor.GRAY + "Party disbanded.");
            this.members.remove(remainingMember);
            this.leader = null;
            return;
        }
        if (hero.equals(this.leader) && !this.members.isEmpty()) {
            this.setLeader(this.members.iterator().next());
        }
        this.update();
    }

    public void removeOldestInvite() {
        this.invites.pop();
    }

    public void setLeader(Hero leader) {
        this.leader = leader;
        if (this.herochat) {
            this.channelManager.makeNewPartyChannel(this);
        }
        this.messageParty(leader.getPlayer().getName() + ChatColor.GRAY + " is now leading the party.");
    }

    public void update() {
        for (Hero member : this.getMembers()) {
            ManagedScoreboard scoreboard = member.getScoreboard();
            if (scoreboard == null || member.getPlayer().isDead()) continue;
            scoreboard.start();
            scoreboard.render();
        }
    }

    public void gainExp(double amount, HeroClass.ExperienceType type, Location location) {
        HashSet<Hero> inRangeMembers = new HashSet<Hero>();
        for (Hero member : this.members) {
            if (!location.getWorld().equals(member.getPlayer().getLocation().getWorld()) || location.distanceSquared(member.getPlayer().getLocation()) > 2500.0 || !member.canGain(type)) continue;
            inRangeMembers.add(member);
        }
        double totalShares = 0.0;
        for (Hero member : inRangeMembers) {
            totalShares += Math.pow(member.getHeroLevel() + member.getHeroClass().getTier() * 60 + 10, 2.71);
        }
        int partySize = inRangeMembers.size();
        double bonusFactor = partySize > 1 ? Properties.partyMults[partySize - 1] * Heroes.properties.partyBonus : 0.0;
        for (Hero member : inRangeMembers) {
            double sharedExp = amount * Math.pow(member.getHeroLevel() + member.getHeroClass().getTier() * 60 + 10, 2.71) / totalShares;
            double bonusExp = sharedExp * bonusFactor;
            bonusExp = Util.formatDouble(bonusExp);
            member.gainExp(sharedExp + bonusExp, type, location);
        }
    }
}

