/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.equipment;

import com.herocraftonline.heroes.util.Util;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public enum EquipmentType {
    HELMET(39, 5),
    CHESTPLATE(38, 6),
    LEGGINGS(37, 7),
    BOOTS(36, 8),
    OFFHAND(40, 45);

    private final int slot;
    private final int rawSlot;

    private EquipmentType(int slot, int rawSlot) {
        this.slot = slot;
        this.rawSlot = rawSlot;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getRawSlot() {
        return this.rawSlot;
    }

    public static EquipmentType ensureIsTypeOrNull(ItemStack itemStack, EquipmentType type) {
        return EquipmentType.ensureIsTypeOrNull(itemStack.getType(), type);
    }

    public static EquipmentType ensureIsTypeOrNull(Material itemType, EquipmentType type) {
        return EquipmentType.tryMatchType(itemType) == type ? OFFHAND : null;
    }

    public static boolean isRecognizedType(ItemStack itemStack) {
        return EquipmentType.tryMatchType(itemStack) != null;
    }

    public static boolean isRecognizedType(Material itemType) {
        return EquipmentType.tryMatchType(itemType) != null;
    }

    public static EquipmentType tryMatchType(ItemStack itemStack) {
        return itemStack == null ? null : EquipmentType.tryMatchType(itemStack.getType());
    }

    public static EquipmentType tryMatchType(Material itemType) {
        if (itemType == null || itemType.name().contains("AIR")) {
            return null;
        }
        String name = itemType.name();
        if (Util.helmets.contains(name)) {
            return HELMET;
        }
        if (Util.chestPlates.contains(name)) {
            return CHESTPLATE;
        }
        if (Util.leggings.contains(name)) {
            return LEGGINGS;
        }
        if (Util.boots.contains(name)) {
            return BOOTS;
        }
        if (Util.weapons.contains(name) || Util.trinkets.contains(name)) {
            return OFFHAND;
        }
        return null;
    }

    public static EquipmentType tryStrictMatchType(ItemStack itemStack) {
        return itemStack == null ? null : EquipmentType.tryStrictMatchType(itemStack.getType());
    }

    public static EquipmentType tryStrictMatchType(Material itemType) {
        if (itemType == null || itemType.name().contains("AIR")) {
            return null;
        }
        String name = itemType.name();
        if (name.endsWith("_HELMET") || name.equals("TURTLE_HELMET") || name.equals("TURTLE_SHELL")) {
            return HELMET;
        }
        if (name.endsWith("_CHESTPLATE") || name.equals("ELYTRA")) {
            return CHESTPLATE;
        }
        if (name.endsWith("_LEGGINGS")) {
            return LEGGINGS;
        }
        if (name.endsWith("_BOOTS")) {
            return BOOTS;
        }
        if (name.equals("SHIELD")) {
            return OFFHAND;
        }
        return null;
    }
}

