/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.equipment;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.equipment.EquipMethod;
import com.herocraftonline.heroes.characters.equipment.EquipmentChangedEvent;
import com.herocraftonline.heroes.characters.equipment.EquipmentType;
import com.herocraftonline.heroes.util.EquipmentUtil;
import com.herocraftonline.heroes.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class EquipmentListener
implements Listener {
    public final Heroes plugin;

    public EquipmentListener(Heroes plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEquipmentChanged(EquipmentChangedEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroClass heroClass = hero.getHeroClass();
        HeroClass secondClass = hero.getSecondaryClass();
        ItemStack item = event.getNewArmorPiece();
        if (event.isUnequippingOldGear() && !event.isReplacingGear() || item == null) {
            return;
        }
        Material itemType = item.getType();
        boolean isUnallowedItem = false;
        if (event.getType() == EquipmentType.HELMET) {
            isUnallowedItem = !hero.canUseAsHelmet(itemType);
        } else if (event.getType() == EquipmentType.OFFHAND) {
            isUnallowedItem = !hero.canUseAsOffhand(itemType);
        } else {
            boolean bl = isUnallowedItem = !hero.canUseAsArmor(itemType);
        }
        if (isUnallowedItem && Heroes.properties.showNotTrainedUseMessage) {
            boolean isOffhand = event.getType() == EquipmentType.OFFHAND;
            player.sendMessage(EquipmentUtil.getAreNotTrainedItemUseMessage(hero, itemType, isOffhand, !isOffhand));
        }
        if (Heroes.properties.checkEquipmentWeight) {
            boolean bl = isUnallowedItem = isUnallowedItem || hero.wouldBecomeOverweight(event.getOldArmorPiece(), event.getNewArmorPiece());
        }
        if (isUnallowedItem) {
            event.setCancelled(true);
            if (event.getType() != EquipmentType.OFFHAND) {
                hero.sendEquipmentWeightChangedMessage();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        ItemStack oldItem = event.getMainHandItem();
        ItemStack newItem = event.getOffHandItem();
        EquipmentType oldEquipmentType = EquipmentType.ensureIsTypeOrNull(oldItem, EquipmentType.OFFHAND);
        EquipmentType newEquipmentType = EquipmentType.ensureIsTypeOrNull(newItem, EquipmentType.OFFHAND);
        if (oldEquipmentType == null && newEquipmentType == null) {
            return;
        }
        Player player = event.getPlayer();
        EquipmentChangedEvent equipmentChangedEvent = new EquipmentChangedEvent(player, EquipMethod.OFFHAND_SWAP, newEquipmentType, (ItemStack)(oldEquipmentType != null ? oldItem : null), (ItemStack)(newEquipmentType != null ? newItem : null));
        Bukkit.getServer().getPluginManager().callEvent((Event)equipmentChangedEvent);
        if (equipmentChangedEvent.isCancelled()) {
            event.setCancelled(true);
            Util.syncInventory(player, this.plugin);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onInventoryClick(InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.NOTHING) {
            return;
        }
        if (event.getSlotType() != InventoryType.SlotType.ARMOR && event.getSlotType() != InventoryType.SlotType.QUICKBAR && event.getSlotType() != InventoryType.SlotType.CONTAINER) {
            return;
        }
        if (event.getClickedInventory() != null && !event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
            return;
        }
        if (!event.getInventory().getType().equals((Object)InventoryType.CRAFTING) && !event.getInventory().getType().equals((Object)InventoryType.PLAYER)) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        boolean isShiftClick = false;
        if (event.getClick().equals((Object)ClickType.SHIFT_LEFT) || event.getClick().equals((Object)ClickType.SHIFT_RIGHT)) {
            isShiftClick = true;
        }
        boolean numberKey = false;
        if (event.getClick().equals((Object)ClickType.NUMBER_KEY)) {
            numberKey = true;
        }
        EquipmentType newEquipmentType = EquipmentType.tryMatchType(isShiftClick ? event.getCurrentItem() : event.getCursor());
        if (!isShiftClick && newEquipmentType != null && event.getRawSlot() != newEquipmentType.getRawSlot()) {
            return;
        }
        if (isShiftClick) {
            newEquipmentType = EquipmentType.tryMatchType(event.getCurrentItem());
            if (newEquipmentType != null) {
                PlayerInventory inventory;
                boolean isEquipping = true;
                if (event.getRawSlot() == newEquipmentType.getRawSlot()) {
                    isEquipping = false;
                }
                if (EquipmentListener.isCurrentSlotEmpty(newEquipmentType, inventory = player.getInventory()) == isEquipping) {
                    EquipmentChangedEvent equipmentChangedEvent = new EquipmentChangedEvent(player, EquipMethod.SHIFT_CLICK, newEquipmentType, isEquipping ? null : event.getCurrentItem(), isEquipping ? event.getCurrentItem() : null);
                    Bukkit.getServer().getPluginManager().callEvent((Event)equipmentChangedEvent);
                    if (equipmentChangedEvent.isCancelled()) {
                        event.setCancelled(true);
                    }
                }
            }
        } else {
            ItemStack newArmorPiece = event.getCursor();
            ItemStack oldArmorPiece = event.getCurrentItem();
            if (numberKey) {
                if (event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
                    ItemStack hotbarItem = event.getClickedInventory().getItem(event.getHotbarButton());
                    if (!EquipmentListener.isAirOrNull(hotbarItem)) {
                        newEquipmentType = EquipmentType.tryMatchType(hotbarItem);
                        newArmorPiece = hotbarItem;
                        oldArmorPiece = event.getClickedInventory().getItem(event.getSlot());
                    } else {
                        newEquipmentType = EquipmentType.tryMatchType(!EquipmentListener.isAirOrNull(event.getCurrentItem()) ? event.getCurrentItem() : event.getCursor());
                    }
                }
            } else if (EquipmentListener.isAirOrNull(event.getCursor()) && !EquipmentListener.isAirOrNull(event.getCurrentItem())) {
                newEquipmentType = EquipmentType.tryMatchType(event.getCurrentItem());
            }
            if (newEquipmentType == null || event.getRawSlot() != newEquipmentType.getRawSlot()) {
                return;
            }
            EquipMethod method = EquipMethod.PICK_DROP;
            if (event.getAction().equals((Object)InventoryAction.HOTBAR_SWAP) || numberKey) {
                method = EquipMethod.HOTBAR_SWAP;
            }
            EquipmentChangedEvent equipmentChangedEvent = new EquipmentChangedEvent(player, method, newEquipmentType, oldArmorPiece, newArmorPiece);
            Bukkit.getServer().getPluginManager().callEvent((Event)equipmentChangedEvent);
            if (equipmentChangedEvent.isCancelled()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void playerInteractEvent(PlayerInteractEvent event) {
        Material mat;
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && Util.interactableBlocks.contains(mat = event.getClickedBlock().getType())) {
            return;
        }
        EquipmentType newEquipmentType = EquipmentType.tryMatchType(event.getItem());
        if (newEquipmentType == null) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && (event.getItem().getType().isBlock() || Util.placeableHelmets.contains(event.getItem().getType().name()))) {
            return;
        }
        if (EquipmentListener.isCurrentSlotEmpty(newEquipmentType, inventory)) {
            EquipmentChangedEvent equipmentChangedEvent = new EquipmentChangedEvent(player, EquipMethod.HOTBAR, EquipmentType.tryMatchType(event.getItem()), null, event.getItem());
            Bukkit.getServer().getPluginManager().callEvent((Event)equipmentChangedEvent);
            if (equipmentChangedEvent.isCancelled()) {
                event.setCancelled(true);
                Util.syncInventory(player, this.plugin);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void inventoryDrag(InventoryDragEvent event) {
        if (event.getRawSlots().isEmpty()) {
            return;
        }
        EquipmentType type = EquipmentType.tryMatchType(event.getOldCursor());
        if (type == null || type.getRawSlot() != event.getRawSlots().stream().findFirst().orElse(0).intValue()) {
            event.getInventory().getHolder();
            return;
        }
        EquipmentChangedEvent equipmentChangedEvent = new EquipmentChangedEvent((Player)event.getWhoClicked(), EquipMethod.DRAG, type, null, event.getOldCursor());
        Bukkit.getServer().getPluginManager().callEvent((Event)equipmentChangedEvent);
        if (equipmentChangedEvent.isCancelled()) {
            event.setResult(Event.Result.DENY);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onArmorDispense(BlockDispenseArmorEvent event) {
        if (EquipmentListener.isAirOrNull(event.getItem()) || event.getTargetEntity() == null || !(event.getTargetEntity() instanceof Player)) {
            return;
        }
        EquipmentType type = EquipmentType.tryMatchType(event.getItem());
        if (type == null) {
            return;
        }
        Player player = (Player)event.getTargetEntity();
        PlayerInventory playerInv = player.getInventory();
        if (EquipmentListener.isCurrentSlotFull(type, playerInv)) {
            return;
        }
        EquipmentChangedEvent equipChangedEvent = new EquipmentChangedEvent(player, EquipMethod.DISPENSER, type, null, event.getItem());
        Bukkit.getServer().getPluginManager().callEvent((Event)equipChangedEvent);
        if (equipChangedEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemBreak(PlayerItemBreakEvent event) {
        EquipmentType type = EquipmentType.tryMatchType(event.getBrokenItem());
        if (type == null) {
            return;
        }
        Player player = event.getPlayer();
        EquipmentChangedEvent equipmentChangedEvent = new EquipmentChangedEvent(player, EquipMethod.BROKE, type, event.getBrokenItem(), null);
        Bukkit.getServer().getPluginManager().callEvent((Event)equipmentChangedEvent);
        if (equipmentChangedEvent.isCancelled()) {
            ItemStack item = event.getBrokenItem().clone();
            item.setAmount(1);
            item.setDurability((short)(item.getDurability() - 1));
            if (type.equals((Object)EquipmentType.HELMET)) {
                player.getInventory().setHelmet(item);
            } else if (type.equals((Object)EquipmentType.CHESTPLATE)) {
                player.getInventory().setChestplate(item);
            } else if (type.equals((Object)EquipmentType.LEGGINGS)) {
                player.getInventory().setLeggings(item);
            } else if (type.equals((Object)EquipmentType.BOOTS)) {
                player.getInventory().setBoots(item);
            } else if (type.equals((Object)EquipmentType.OFFHAND)) {
                player.getInventory().setItemInOffHand(item);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void playerDeathEvent(PlayerDeathEvent event) {
        Player player = event.getEntity();
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getArmorContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (EquipmentListener.isAirOrNull(item)) continue;
            EquipmentChangedEvent equipChangedEvent = new EquipmentChangedEvent(player, EquipMethod.DEATH, EquipmentType.tryMatchType(item), item, null);
            Bukkit.getServer().getPluginManager().callEvent((Event)equipChangedEvent);
            if (!equipChangedEvent.isCancelled()) continue;
            inventory.clear(i);
        }
    }

    private static boolean isCurrentSlotFull(EquipmentType type, PlayerInventory inventory) {
        return type == EquipmentType.HELMET && !EquipmentListener.isAirOrNull(inventory.getHelmet()) || type == EquipmentType.CHESTPLATE && !EquipmentListener.isAirOrNull(inventory.getChestplate()) || type == EquipmentType.LEGGINGS && !EquipmentListener.isAirOrNull(inventory.getLeggings()) || type == EquipmentType.BOOTS && !EquipmentListener.isAirOrNull(inventory.getBoots()) || type == EquipmentType.OFFHAND && !EquipmentListener.isAirOrNull(inventory.getItemInOffHand());
    }

    private static boolean isCurrentSlotEmpty(EquipmentType type, PlayerInventory inventory) {
        return type.equals((Object)EquipmentType.HELMET) && EquipmentListener.isAirOrNull(inventory.getHelmet()) || type.equals((Object)EquipmentType.CHESTPLATE) && EquipmentListener.isAirOrNull(inventory.getChestplate()) || type.equals((Object)EquipmentType.LEGGINGS) && EquipmentListener.isAirOrNull(inventory.getLeggings()) || type.equals((Object)EquipmentType.BOOTS) && EquipmentListener.isAirOrNull(inventory.getBoots());
    }

    private static boolean isAirOrNull(ItemStack item) {
        return item == null || item.getType().equals((Object)Material.AIR);
    }
}

