/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.equipment;

import com.herocraftonline.heroes.characters.equipment.EquipMethod;
import com.herocraftonline.heroes.characters.equipment.EquipmentType;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class EquipmentChangedEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancel = false;
    private final EquipMethod equipType;
    private final EquipmentType type;
    @Nullable
    private ItemStack oldArmorPiece;
    @Nullable
    private ItemStack newArmorPiece;

    public EquipmentChangedEvent(Player player, EquipMethod equipType, EquipmentType type, @Nullable ItemStack oldArmorPiece, @Nullable ItemStack newArmorPiece) {
        super(player);
        this.equipType = equipType;
        this.type = type;
        this.oldArmorPiece = oldArmorPiece;
        this.newArmorPiece = newArmorPiece;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public final HandlerList getHandlers() {
        return handlers;
    }

    public final void setCancelled(boolean cancel) {
        this.cancel = cancel;
    }

    public final boolean isCancelled() {
        return this.cancel;
    }

    public final EquipmentType getType() {
        return this.type;
    }

    @Nullable
    public final ItemStack getOldArmorPiece() {
        return this.oldArmorPiece;
    }

    public final void setOldArmorPiece(@Nullable ItemStack oldArmorPiece) {
        this.oldArmorPiece = oldArmorPiece;
    }

    @Nullable
    public final ItemStack getNewArmorPiece() {
        return this.newArmorPiece;
    }

    public final boolean isEquippingNewGear() {
        return this.getNewArmorPiece() != null && this.getNewArmorPiece().getType() != Material.AIR;
    }

    public final boolean isUnequippingOldGear() {
        return this.getOldArmorPiece() != null && this.getOldArmorPiece().getType() != Material.AIR;
    }

    public final boolean isReplacingGear() {
        return this.isUnequippingOldGear() && this.isEquippingNewGear();
    }

    public final void setNewArmorPiece(@Nullable ItemStack newArmorPiece) {
        this.newArmorPiece = newArmorPiece;
    }

    public EquipMethod getMethod() {
        return this.equipType;
    }
}

