/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.standard;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SwiftnessEffect
extends ExpirableEffect {
    public static final String BASE_NAME = "Swiftness";
    public static final int MIN_STRENGTH = 1;
    public static final int MAX_STRENGTH = 5;
    private final int strength;

    public static String getName(int strength) {
        return "Swiftness " + SwiftnessEffect.getStrengthSuffix(strength);
    }

    public static String getStrengthSuffix(int strength) {
        switch (SwiftnessEffect.clampStrength(strength)) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
        }
        throw new IllegalStateException("This shouldn't happen");
    }

    public static void setDuration(CharacterTemplate character, Skill skill, Player applier, long duration, int strength, boolean keepLongerDuration) {
        character.setEffectDuration(SwiftnessEffect.getName(strength), skill, applier, duration, keepLongerDuration, () -> new SwiftnessEffect(skill, applier, duration, strength));
    }

    public static void setDuration(CharacterTemplate character, Skill skill, Player applier, long duration, int strength) {
        SwiftnessEffect.setDuration(character, skill, applier, duration, strength, false);
    }

    public static void addDuration(CharacterTemplate character, Skill skill, Player applier, long amount, int strength) {
        character.addEffectDuration(SwiftnessEffect.getName(strength), skill, applier, amount, () -> new SwiftnessEffect(skill, applier, amount, strength));
    }

    public static void subtractDuration(CharacterTemplate character, Skill skill, Player applier, long amount, int strength) {
        character.subtractEffectDuration(SwiftnessEffect.getName(strength), skill, applier, amount);
    }

    public static SwiftnessEffect get(CharacterTemplate character, int strength) {
        Effect effect = character.getEffect(SwiftnessEffect.getName(strength));
        return effect instanceof SwiftnessEffect ? (SwiftnessEffect)effect : null;
    }

    public static SwiftnessEffect getStrongest(CharacterTemplate character) {
        SwiftnessEffect current = null;
        for (Effect effect : character.getEffects()) {
            if (!(effect instanceof SwiftnessEffect)) continue;
            SwiftnessEffect swiftnessEffect = (SwiftnessEffect)effect;
            if (current != null && swiftnessEffect.getStrength() <= current.getStrength()) continue;
            current = swiftnessEffect;
        }
        return current;
    }

    public static void remove(CharacterTemplate character, int strength) {
        character.removeEffect(SwiftnessEffect.get(character, strength));
    }

    public static void removeAll(CharacterTemplate character) {
        for (int i = 1; i <= 5; ++i) {
            SwiftnessEffect.remove(character, i);
        }
    }

    public static long getRemainingDuration(CharacterTemplate character, int strength) {
        return character.getRemainingEffectDuration(SwiftnessEffect.getName(strength));
    }

    private static int clampStrength(int strength) {
        if (strength > 5) {
            return 5;
        }
        if (strength < 1) {
            return 1;
        }
        return strength;
    }

    private static String processText(String text, int strength) {
        return text != null ? text.replace("%strength%", SwiftnessEffect.getStrengthSuffix(strength)) : null;
    }

    public SwiftnessEffect(Skill skill, Player applier, long duration, int strength) {
        super(skill, SwiftnessEffect.getName(strength), applier, duration, SwiftnessEffect.processText(Heroes.properties.standardEffectSwiftnessApplyText, strength), SwiftnessEffect.processText(Heroes.properties.standardEffectSwiftnessRemoveText, strength));
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.SPEED);
        this.strength = SwiftnessEffect.clampStrength(strength);
        this.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 100000000, this.strength));
    }

    public int getStrength() {
        return this.strength;
    }
}

