/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.standard;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class SlownessEffect
extends ExpirableEffect {
    public static final String BASE_NAME = "Slowness";
    public static final int MIN_STRENGTH = 1;
    public static final int MAX_STRENGTH = 5;
    private final int strength;

    public static String getName(int strength) {
        return "Slowness " + SlownessEffect.getStrengthSuffix(strength);
    }

    public static String getStrengthSuffix(int strength) {
        switch (SlownessEffect.clampStrength(strength)) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
        }
        throw new IllegalStateException("This shouldn't happen");
    }

    public static void setDuration(CharacterTemplate character, Skill skill, Player applier, long duration, int strength, boolean keepLongerDuration) {
        character.setEffectDuration(SlownessEffect.getName(strength), skill, applier, duration, keepLongerDuration, () -> new SlownessEffect(skill, applier, duration, strength));
    }

    public static void setDuration(CharacterTemplate character, Skill skill, Player applier, long duration, int strength) {
        SlownessEffect.setDuration(character, skill, applier, duration, strength, false);
    }

    public static void addDuration(CharacterTemplate character, Skill skill, Player applier, long amount, int strength) {
        character.addEffectDuration(SlownessEffect.getName(strength), skill, applier, amount, () -> new SlownessEffect(skill, applier, amount, strength));
    }

    public static void subtractDuration(CharacterTemplate character, Skill skill, Player applier, long amount, int strength) {
        character.subtractEffectDuration(SlownessEffect.getName(strength), skill, applier, amount);
    }

    public static SlownessEffect get(CharacterTemplate character, int strength) {
        Effect effect = character.getEffect(SlownessEffect.getName(strength));
        return effect instanceof SlownessEffect ? (SlownessEffect)effect : null;
    }

    public static SlownessEffect getStrongest(CharacterTemplate character) {
        SlownessEffect current = null;
        for (Effect effect : character.getEffects()) {
            if (!(effect instanceof SlownessEffect)) continue;
            SlownessEffect slownessEffect = (SlownessEffect)effect;
            if (current != null && slownessEffect.getStrength() <= current.getStrength()) continue;
            current = slownessEffect;
        }
        return current;
    }

    public static void remove(CharacterTemplate character, int strength) {
        character.removeEffect(SlownessEffect.get(character, strength));
    }

    public static void removeAll(CharacterTemplate character) {
        for (int i = 1; i <= 5; ++i) {
            SlownessEffect.remove(character, i);
        }
    }

    public static long getRemainingDuration(CharacterTemplate character, int strength) {
        return character.getRemainingEffectDuration(SlownessEffect.getName(strength));
    }

    private static int clampStrength(int strength) {
        if (strength > 5) {
            return 5;
        }
        if (strength < 1) {
            return 1;
        }
        return strength;
    }

    private static String processText(String text, int strength) {
        return text != null ? text.replace("%strength%", SlownessEffect.getStrengthSuffix(strength)) : null;
    }

    public SlownessEffect(Skill skill, Player applier, long duration, int strength) {
        super(skill, SlownessEffect.getName(strength), applier, duration, SlownessEffect.processText(Heroes.properties.standardEffectSlownessApplyText, strength), SlownessEffect.processText(Heroes.properties.standardEffectSlownessRemoveText, strength));
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.SLOW);
        this.strength = SlownessEffect.clampStrength(strength);
        this.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100000000, this.strength));
    }

    public int getStrength() {
        return this.strength;
    }
}

