/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.standard;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.common.MaxHealthPercentDecreaseEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class DeepWoundEffect
extends MaxHealthPercentDecreaseEffect {
    public static final String NAME = "DeepWound";

    public static void setDuration(CharacterTemplate character, Skill skill, Player applier, long duration, boolean keepLongerDuration) {
        character.setEffectDuration(NAME, skill, applier, duration, keepLongerDuration, () -> new DeepWoundEffect(skill, applier, duration));
    }

    public static void setDuration(CharacterTemplate character, Skill skill, Player applier, long duration) {
        DeepWoundEffect.setDuration(character, skill, applier, duration, false);
    }

    public static void addDuration(CharacterTemplate character, Skill skill, Player applier, long amount) {
        character.addEffectDuration(NAME, skill, applier, amount, () -> new DeepWoundEffect(skill, applier, amount));
    }

    public static void subtractDuration(CharacterTemplate character, Skill skill, Player applier, long amount) {
        character.subtractEffectDuration(NAME, skill, applier, amount);
    }

    public static DeepWoundEffect get(CharacterTemplate character, int strength) {
        Effect effect = character.getEffect(NAME);
        return effect instanceof DeepWoundEffect ? (DeepWoundEffect)effect : null;
    }

    public static long getRemainingDuration(CharacterTemplate character, int strength) {
        return character.getRemainingEffectDuration(NAME);
    }

    public DeepWoundEffect(Skill skill, Player applier, long duration) {
        super(skill, NAME, applier, duration, Heroes.properties.standardEffectDeepWoundPercentMaxHealthReduction, Heroes.properties.standardEffectDeepWoundApplyText, Heroes.properties.standardEffectDeepWoundRemoveText);
    }
}

