/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.standard;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicStackingDamageEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.nms.physics.collision.AABB;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public final class BleedingEffect
extends PeriodicStackingDamageEffect {
    public static final String NAME = "Bleeding";

    public BleedingEffect(Skill skill, Player applier) {
        super(skill, NAME, applier, Heroes.properties.standardEffectBleedingMaxStacks, Heroes.properties.standardEffectBleedingPeriod, Heroes.properties.standardEffectBleedingDamagePerStack, Heroes.properties.standardEffectBleedingApplyText, Heroes.properties.standardEffectBleedingRemoveText);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.DAMAGING);
    }

    public static int applyStacks(CharacterTemplate character, Skill skill, Player applier, long duration, int amount) {
        return character.addEffectStacks(NAME, skill, applier, duration, amount, () -> new BleedingEffect(skill, applier));
    }

    public static boolean applyStack(CharacterTemplate character, Skill skill, Player applier, long duration) {
        return BleedingEffect.applyStacks(character, skill, applier, duration, 1) == 1;
    }

    public static BleedingEffect get(CharacterTemplate character) {
        Effect effect = character.getEffect(NAME);
        return effect instanceof BleedingEffect ? (BleedingEffect)effect : null;
    }

    public static int getStackCount(CharacterTemplate character) {
        return character.getEffectStackCount(NAME);
    }

    @Override
    public void tick(CharacterTemplate character) {
        super.tick(character);
        LivingEntity target = character.getEntity();
        AABB targetAABB = NMSPhysics.instance().getEntityAABB((Entity)target);
        World targetWorld = target.getWorld();
        Location particleLocation = target.getLocation();
        particleLocation.setX(targetAABB.getCenterX());
        particleLocation.setY(targetAABB.getCenterY());
        particleLocation.setZ(targetAABB.getCenterZ());
        targetWorld.spawnParticle(Particle.REDSTONE, particleLocation, Heroes.properties.standardEffectBleedingParticleCount, (targetAABB.getMaxX() - targetAABB.getMinX()) / 2.0, (targetAABB.getMaxY() - targetAABB.getMinY()) / 2.0, (targetAABB.getMaxZ() - targetAABB.getMinZ()) / 2.0, 1.0, (Object)new Particle.DustOptions(Color.RED, 1.0f));
    }
}

