/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.common.HealthRegainReductionEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WitheringEffect
extends HealthRegainReductionEffect {
    private static String defaultEffectName = "Withering";
    private static double defaultHealingReductionPercent = 0.3;
    private static String defaultApplyText = ChatComponents.GENERIC_SKILL + "$1 is withering!";
    private static String defaultExpireText = ChatComponents.GENERIC_SKILL + "$1 is no longer withered.";

    public WitheringEffect(Skill skill, Player applier, long duration, int amplifier) {
        this(skill, defaultEffectName, applier, duration, amplifier, defaultHealingReductionPercent, defaultApplyText, defaultExpireText);
    }

    public WitheringEffect(Skill skill, Player applier, long duration, int amplifier, double healingReductionPercent) {
        this(skill, defaultEffectName, applier, duration, amplifier, healingReductionPercent, defaultApplyText, defaultExpireText);
    }

    public WitheringEffect(Skill skill, String name, Player applier, long duration, int amplifier) {
        this(skill, name, applier, duration, amplifier, defaultHealingReductionPercent, defaultApplyText, defaultExpireText);
    }

    public WitheringEffect(Skill skill, String name, Player applier, long duration, int amplifier, double healingReductionPercent) {
        this(skill, name, applier, duration, amplifier, healingReductionPercent, defaultApplyText, defaultExpireText);
    }

    public WitheringEffect(Skill skill, Player applier, long duration, int amplifier, String applyText, String expireText) {
        this(skill, defaultEffectName, applier, duration, amplifier, defaultHealingReductionPercent, applyText, expireText);
    }

    public WitheringEffect(Skill skill, Player applier, long duration, int amplifier, double healingReductionPercent, String applyText, String expireText) {
        this(skill, defaultEffectName, applier, duration, amplifier, healingReductionPercent, applyText, expireText);
    }

    public WitheringEffect(Skill skill, String name, Player applier, long duration, int amplifier, String applyText, String expireText) {
        this(skill, name, applier, duration, amplifier, defaultHealingReductionPercent, applyText, expireText);
    }

    public WitheringEffect(Skill skill, String name, Player applier, long duration, int amplifier, double healingReductionPercent, String applyText, String expireText) {
        super(skill, name, applier, duration, healingReductionPercent, applyText, expireText);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.WITHER);
        this.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, (int)(20L * duration / 1000L), amplifier));
    }
}

