/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WeaknessEffect
extends ExpirableEffect {
    public WeaknessEffect(Skill skill, Player applier, long duration) {
        this(skill, "Weakness", applier, duration, ChatComponents.GENERIC_SKILL + "$1 has become weak!", ChatComponents.GENERIC_SKILL + "$1's strength has returned.");
    }

    public WeaknessEffect(Skill skill, String name, Player applier, long duration) {
        this(skill, name, applier, duration, ChatComponents.GENERIC_SKILL + "$1 has become weak!", ChatComponents.GENERIC_SKILL + "$1's strength has returned.");
    }

    public WeaknessEffect(Skill skill, Player applier, long duration, String applyText, String expireText) {
        this(skill, "Weakness", applier, duration, applyText, expireText);
    }

    public WeaknessEffect(Skill skill, String name, Player applier, long duration, String applyText, String expireText) {
        super(skill, name, applier, duration, applyText, expireText);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.WEAKNESS);
        this.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, (int)(20L * duration / 1000L), 0), false);
    }
}

