/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WaterBreathingEffect
extends ExpirableEffect {
    public WaterBreathingEffect(Skill skill, Player applier, long duration) {
        this(skill, "WaterBreathing", applier, duration, ChatComponents.GENERIC_SKILL + "$1 has grown a set of gills!", ChatComponents.GENERIC_SKILL + "$1's gills have faded.");
    }

    public WaterBreathingEffect(Skill skill, String name, Player applier, long duration) {
        this(skill, name, applier, duration, ChatComponents.GENERIC_SKILL + "$1 has grown a set of gills!", ChatComponents.GENERIC_SKILL + "$1's gills have faded.");
    }

    public WaterBreathingEffect(Skill skill, Player applier, long duration, String applyText, String expireText) {
        this(skill, "WaterBreathing", applier, duration, applyText, expireText);
    }

    public WaterBreathingEffect(Skill skill, String name, Player applier, long duration, String applyText, String expireText) {
        super(skill, name, applier, duration, applyText, expireText);
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.WATER_BREATHING);
        this.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, (int)(20L * duration / 1000L), 0), false);
    }
}

