/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WaterBreatheEffect
extends ExpirableEffect {
    private final String applyText;
    private final String expireText;

    public WaterBreatheEffect(Skill skill, Player applier, long duration, String applyText, String expireText) {
        super(skill, "WaterBreathing", applier, duration);
        this.applyText = applyText;
        this.expireText = expireText;
        this.types.add(EffectType.DISPELLABLE);
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.MAGIC);
        this.types.add(EffectType.WATER_BREATHING);
        this.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, (int)(20L * duration / 1000L), 0), false);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), this.applyText, player.getDisplayName());
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), this.expireText, player.getDisplayName());
    }
}

