/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class VanillaHungerEffect
extends PeriodicExpirableEffect {
    double staminaDrainMultiplier = 0.05;

    public VanillaHungerEffect(Skill skill, Player applier, long duration) {
        this(skill, (Heroes)null, applier, 1000L, duration);
    }

    public VanillaHungerEffect(Skill skill, Player applier, long period, long duration) {
        this(skill, (Heroes)null, applier, period, duration);
    }

    public VanillaHungerEffect(Skill skill, Heroes plugin, Player applier, long duration) {
        this(skill, plugin, applier, 1000L, duration);
    }

    public VanillaHungerEffect(Skill skill, Heroes plugin, Player applier, long period, long duration) {
        super(skill, plugin, "VanillaHungerEffect", applier, period, duration);
        this.types.add(EffectType.MAGIC);
        this.types.add(EffectType.DISPELLABLE);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.HUNGER);
        this.types.add(EffectType.STAMINA_REGEN_FREEZING);
        this.types.add(EffectType.STAMINA_DECREASING);
        this.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, (int)(20L * duration / 1000L), 0));
    }

    @Override
    public void tickHero(Hero hero) {
        Player player = hero.getPlayer();
        int staminaDrain = (int)((double)hero.getStamina() * this.staminaDrainMultiplier);
        hero.setStamina(hero.getStamina() - staminaDrain);
        if (hero.isVerboseStamina()) {
            player.sendMessage(ChatComponents.Bars.stamina(hero.getStamina(), hero.getMaxStamina(), true));
        }
    }

    @Override
    public void tickMonster(Monster monster) {
    }
}

