/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicEffect;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.effects.common.interfaces.Summon;
import com.herocraftonline.heroes.characters.skill.Skill;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class SummonEffect
extends PeriodicExpirableEffect
implements Summon {
    public static final double DEFAULT_AGGRO_RADIUS = 14.0;
    public static final long DEFAULT_AGGRO_PERIOD = 1000L;
    private final Hero summoner;
    private final double initialAggroRadius;
    private final double maxLeashDistance;

    public SummonEffect(Skill skill, long duration, Hero summoner, String expireText) {
        this(skill, duration, summoner, 14.0, expireText);
    }

    public SummonEffect(Skill skill, long duration, Hero summoner, double initialAggroRadius, String expireText) {
        this(skill, "Summon", duration, summoner, initialAggroRadius, expireText);
    }

    public SummonEffect(Skill skill, String name, long duration, Hero summoner, String expireText) {
        this(skill, name, duration, summoner, 14.0, expireText);
    }

    public SummonEffect(Skill skill, String name, long duration, Hero summoner, double initialAggroRadius, String expireText) {
        this(skill, name, 1000L, duration, summoner, initialAggroRadius, expireText, 75.0);
    }

    public SummonEffect(Skill skill, String name, long period, long duration, Hero summoner, double initialAggroRadius, String expireText, double maxLeashDistance) {
        super(skill, name, summoner.getPlayer(), period, duration, null, expireText);
        this.summoner = summoner;
        this.initialAggroRadius = initialAggroRadius;
        this.maxLeashDistance = maxLeashDistance;
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.SUMMON);
    }

    @Override
    public void applyToMonster(Monster monster) {
        super.applyToMonster(monster);
        this.summoner.getSummons().add(monster);
        SummonLeashEffect effect = new SummonLeashEffect(this.skill, 1500L, this.maxLeashDistance);
        this.summoner.addEffect(effect);
        this.aggroClosestEnemy(monster);
    }

    @Override
    public void tickMonster(Monster monster) {
        this.aggroClosestEnemy(monster);
    }

    @Override
    public void tickHero(Hero hero) {
    }

    protected void aggroClosestEnemy(Monster monster) {
        Player summonerPlayer = this.summoner.getPlayer();
        LivingEntity currentTarget = monster.getCurrentTargetIfAble();
        if (currentTarget != null && !(currentTarget.getHealth() < 0.0) && !currentTarget.isDead()) {
            CharacterTemplate targetCT = this.plugin.getCharacterManager().getCharacter(currentTarget);
            for (Effect effect : targetCT.getEffects()) {
                if (!effect.isType(EffectType.INVIS)) continue;
                currentTarget = null;
            }
        }
        if (currentTarget != null && currentTarget.getHealth() > 0.0 && !currentTarget.isDead() && !summonerPlayer.equals(currentTarget) && !monster.getEntity().equals(currentTarget)) {
            return;
        }
        double closestDistanceSquared = Double.MAX_VALUE;
        LivingEntity monsterEnt = monster.getEntity();
        LivingEntity closestEnemy = null;
        Collection nearbyEnts = monsterEnt.getWorld().getNearbyEntities(monsterEnt.getLocation(), this.initialAggroRadius, this.initialAggroRadius * 0.5, this.initialAggroRadius);
        for (Entity ent : nearbyEnts) {
            double distSquared;
            if (!(ent instanceof LivingEntity)) continue;
            LivingEntity nearbyLE = (LivingEntity)ent;
            CharacterTemplate nearbyCT = this.plugin.getCharacterManager().getCharacter(nearbyLE);
            if (this.summoner.isAlliedTo(nearbyLE) || nearbyLE instanceof Player && ((Player)nearbyLE).isSneaking()) continue;
            boolean isStealthyTarget = false;
            for (Effect effect : nearbyCT.getEffects()) {
                if (!effect.isType(EffectType.INVIS) && !effect.isType(EffectType.SNEAK)) continue;
                isStealthyTarget = true;
                break;
            }
            if (isStealthyTarget || !Skill.damageCheck(summonerPlayer, nearbyLE) || !((distSquared = monsterEnt.getLocation().distanceSquared(nearbyLE.getLocation())) < closestDistanceSquared)) continue;
            closestEnemy = nearbyLE;
            closestDistanceSquared = distSquared;
        }
        if (closestEnemy != null) {
            monster.setTargetIfAble(closestEnemy);
        }
    }

    @Override
    public void removeFromMonster(Monster monster) {
        super.removeFromMonster(monster);
        LivingEntity creature = monster.getEntity();
        this.summoner.getSummons().remove(monster);
        if (!creature.getWorld().getChunkAt(creature.getLocation()).isLoaded()) {
            creature.getWorld().loadChunk(creature.getWorld().getChunkAt(creature.getLocation()));
        }
        creature.remove();
        for (Monster m : this.summoner.getSummons()) {
            if (!m.hasEffect(this.name)) continue;
            return;
        }
        this.summoner.removeEffect(this.summoner.getEffect("SummonLeash"));
    }

    @Override
    public Hero getSummoner() {
        return this.summoner;
    }

    public class SummonLeashEffect
    extends PeriodicEffect {
        public static final double DEFAULT_MAX_LEASH_DISTANCE = 75.0;
        private final double maxLeashDistance;
        private final double maxLeashDistanceSquared;

        public SummonLeashEffect(Skill skill, long period) {
            this(skill, period, 75.0);
        }

        public SummonLeashEffect(Skill skill, long period, double maxLeashDistance) {
            super(skill, "SummonLeash", null, period);
            this.setPersistent(true);
            this.maxLeashDistance = maxLeashDistance;
            this.maxLeashDistanceSquared = maxLeashDistance * maxLeashDistance;
        }

        @Override
        public void tickHero(Hero hero) {
            super.tickHero(hero);
            for (Monster monster : hero.getSummons()) {
                this.leashIfNecessary(monster, hero);
            }
        }

        private void leashIfNecessary(Monster monster, Hero hero) {
            Location loc = monster.getEntity().getLocation();
            Location heroLoc = hero.getPlayer().getLocation();
            if (!loc.getWorld().equals(heroLoc.getWorld()) || loc.distanceSquared(heroLoc) > this.maxLeashDistanceSquared) {
                monster.getEntity().teleport(heroLoc);
                monster.setTargetIfAble((LivingEntity)hero.getPlayer(), false);
            }
        }
    }
}

