/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class StunEffect
extends PeriodicExpirableEffect {
    private Location loc;

    public StunEffect(Skill skill, Player applier, long duration) {
        this(skill, "Stun", applier, duration, ChatComponents.GENERIC_SKILL + "$1 has been stunned!", ChatComponents.GENERIC_SKILL + "$1 is no longer stunned!");
    }

    public StunEffect(Skill skill, String name, Player applier, long duration) {
        this(skill, name, applier, duration, ChatComponents.GENERIC_SKILL + "$1 has been stunned!", ChatComponents.GENERIC_SKILL + "$1 is no longer stunned!");
    }

    public StunEffect(Skill skill, Player applier, long duration, String applyText, String expireText) {
        this(skill, "Stun", applier, duration, applyText, expireText);
    }

    public StunEffect(Skill skill, String name, Player applier, long duration, String applyText, String expireText) {
        super(skill, "Stun", applier, 100L, duration, applyText, expireText);
        this.types.add(EffectType.STUN);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.PHYSICAL);
        this.types.add(EffectType.DISABLE);
        this.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, (int)(20L * duration / 1000L), 127));
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        this.loc = hero.getPlayer().getLocation();
    }

    @Override
    public void tickHero(Hero hero) {
        Player player = hero.getPlayer();
        if (player.isDead() || player.getHealth() <= 0.0) {
            hero.removeEffect(this);
            return;
        }
        Location location = player.getLocation();
        if (location == null) {
            return;
        }
        if (location.getX() != this.loc.getX() || location.getY() != this.loc.getY() || location.getZ() != this.loc.getZ()) {
            this.loc.setYaw(location.getYaw());
            this.loc.setPitch(location.getPitch());
            hero.getPlayer().teleport(this.loc);
        }
    }

    @Override
    public void tickMonster(Monster monster) {
    }
}

