/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class SneakEffect
extends PeriodicExpirableEffect {
    private String applyText;
    private String expireText;
    private boolean vanillaSneaking;

    public SneakEffect(Skill skill, Player applier, int period, long duration, boolean vanillaSneaking) {
        this(skill, "Sneak", applier, period, duration, vanillaSneaking, ChatComponents.GENERIC_SKILL + "You are now sneaking", ChatComponents.GENERIC_SKILL + "You are no longer sneaking");
    }

    public SneakEffect(Skill skill, String name, Player applier, int period, long duration, boolean vanillaSneaking) {
        this(skill, name, applier, period, duration, vanillaSneaking, ChatComponents.GENERIC_SKILL + "You are now sneaking", ChatComponents.GENERIC_SKILL + "You are no longer sneaking");
    }

    public SneakEffect(Skill skill, Player applier, int period, int duration, boolean vanillaSneaking, String applyText, String expireText) {
        this(skill, "Sneak", applier, period, (long)duration, vanillaSneaking, applyText, expireText);
    }

    public SneakEffect(Skill skill, String name, Player applier, long period, long duration, boolean vanillaSneaking, String applyText, String expireText) {
        super(skill, name, applier, period, duration, null, null);
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.PHYSICAL);
        this.types.add(EffectType.SNEAK);
        this.types.add(EffectType.SILENT_ACTIONS);
        this.applyText = applyText;
        this.expireText = expireText;
        this.setVanillaSneaking(vanillaSneaking);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        player.setSneaking(true);
        if (this.applyText != null && this.applyText.length() > 0) {
            player.sendMessage(ChatColor.GRAY + "    " + this.applyText);
        }
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        player.setSneaking(this.vanillaSneaking);
        if (this.expireText != null && this.expireText.length() > 0) {
            player.sendMessage(ChatColor.GRAY + "    " + this.expireText);
        }
    }

    @Override
    public void tickHero(Hero hero) {
        Player player = hero.getPlayer();
        player.setSneaking(false);
        player.setSneaking(true);
    }

    @Override
    public void tickMonster(Monster monster) {
    }

    public boolean isVanillaSneaking() {
        return this.vanillaSneaking;
    }

    public void setVanillaSneaking(boolean vanillaSneaking) {
        this.vanillaSneaking = vanillaSneaking;
    }
}

