/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SlowEffect
extends ExpirableEffect {
    public static final String DEFAULT_APPLY_TEXT = ChatComponents.GENERIC_SKILL + "$1 has been slowed!";
    public static final String DEFAULT_EXPIRE_TEXT = ChatComponents.GENERIC_SKILL + "$1's speed returns to normal.";
    public static boolean DEFAULT_SHOW_PARTICLES = true;
    public static boolean DEFAULT_USE_NO_SPRINT = Heroes.properties.noSprintWhileSlowedDefault;
    private final boolean useNoSprint;
    private long noSprintRefreshPeriodTicks = 20L;

    public SlowEffect(Skill skill, Player applier, long duration, int amplifier) {
        this(skill, "Slow", applier, duration, amplifier, DEFAULT_SHOW_PARTICLES, DEFAULT_USE_NO_SPRINT);
    }

    public SlowEffect(Skill skill, String name, Player applier, long duration, int amplifier) {
        this(skill, name, applier, duration, amplifier, DEFAULT_SHOW_PARTICLES, DEFAULT_USE_NO_SPRINT);
    }

    @Deprecated
    public SlowEffect(Skill skill, String name, Player applier, long duration, int amplifier, boolean showParticles) {
        this(skill, name, applier, duration, amplifier, showParticles, DEFAULT_USE_NO_SPRINT);
    }

    public SlowEffect(Skill skill, String name, Player applier, long duration, int amplifier, boolean showParticles, boolean useNoSprint) {
        this(skill, name, applier, duration, amplifier, showParticles, DEFAULT_APPLY_TEXT, DEFAULT_EXPIRE_TEXT, useNoSprint);
    }

    public SlowEffect(Skill skill, Player applier, long duration, int amplifier, String applyText, String expireText) {
        this(skill, "Slow", applier, duration, amplifier, DEFAULT_SHOW_PARTICLES, applyText, expireText, DEFAULT_USE_NO_SPRINT);
    }

    @Deprecated
    public SlowEffect(Skill skill, String name, Player applier, long duration, int amplifier, String applyText, String expireText) {
        this(skill, name, applier, duration, amplifier, DEFAULT_SHOW_PARTICLES, applyText, expireText, true);
    }

    @Deprecated
    public SlowEffect(Skill skill, String name, Player applier, long duration, int amplifier, boolean showParticles, String applyText, String expireText) {
        this(skill, name, applier, duration, amplifier, showParticles, applyText, expireText, DEFAULT_USE_NO_SPRINT);
    }

    public SlowEffect(Skill skill, String name, Player applier, long duration, int amplifier, boolean showParticles, String applyText, String expireText, boolean useNoSprint) {
        super(skill, name, applier, duration, applyText, expireText);
        this.useNoSprint = useNoSprint;
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.SLOW);
        this.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, (int)(20L * duration / 1000L), amplifier, true, showParticles));
    }

    public void setNoSprintRefreshPeriodTicks(long ticks) {
        if (ticks < 1L) {
            ticks = 1L;
        }
        this.noSprintRefreshPeriodTicks = ticks;
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
    }

    public static void applyNoSprintForEffect(Plugin plugin, Hero hero, ExpirableEffect effect, long delayTicks, long noSprintRefreshPeriodTicks) {
        Player player = hero.getPlayer();
        String effectName = effect.getName();
    }
}

