/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.DelayedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.chat.ChatComponents;
import org.bukkit.entity.Player;

public class SilenceEffect
extends ExpirableEffect {
    public SilenceEffect(Skill skill, Player applier, long duration) {
        this(skill, "Silence", applier, duration, ChatComponents.GENERIC_SKILL + "$1 has been silenced!", ChatComponents.GENERIC_SKILL + "$1 is no longer silenced.");
    }

    public SilenceEffect(Skill skill, String name, Player applier, long duration) {
        this(skill, name, applier, duration, ChatComponents.GENERIC_SKILL + "$1 has been silenced!", ChatComponents.GENERIC_SKILL + "$1 is no longer silenced.");
    }

    public SilenceEffect(Skill skill, Player applier, long duration, String applyText, String expireText) {
        this(skill, "Silence", applier, duration, applyText, expireText);
    }

    public SilenceEffect(Skill skill, String name, Player applier, long duration, String applyText, String expireText) {
        super(skill, name, applier, duration, applyText, expireText);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.SILENCE);
    }

    @Override
    public void applyToHero(Hero hero) {
        Skill skill;
        super.applyToHero(hero);
        DelayedSkill dSkill = hero.getDelayedSkill();
        if (dSkill != null && (skill = dSkill.getSkill()).isType(SkillType.SILENCEABLE)) {
            hero.interruptDelayedSkill();
        }
    }
}

