/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class RootEffect
extends PeriodicExpirableEffect {
    private Location loc;

    public RootEffect(Skill skill, Player applier, int period, long duration) {
        this(skill, "Root", applier, period, duration, ChatComponents.GENERIC_SKILL + "$1 has been rooted!", ChatComponents.GENERIC_SKILL + "$1 has broken free from the root!");
    }

    public RootEffect(Skill skill, String name, Player applier, int period, long duration) {
        this(skill, name, applier, period, duration, ChatComponents.GENERIC_SKILL + "$1 has been rooted!", ChatComponents.GENERIC_SKILL + "$1 has broken free from the root!");
    }

    public RootEffect(Skill skill, Player applier, int period, long duration, String applyText, String expireText) {
        this(skill, "Root", applier, period, duration, applyText, expireText);
    }

    public RootEffect(Skill skill, String name, Player applier, int period, long duration, String applyText, String expireText) {
        super(skill, "Root", applier, period, duration, applyText, expireText);
        this.types.add(EffectType.ROOT);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.MAGIC);
        this.types.add(EffectType.DISPELLABLE);
        this.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, (int)(20L * duration / 1000L), 127));
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        final Player player = hero.getPlayer();
        this.loc = hero.getPlayer().getLocation();
        final int currentHunger = player.getFoodLevel();
        player.setFoodLevel(1);
        player.setSprinting(false);
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                player.setFoodLevel(currentHunger);
            }
        }, 0L);
    }

    @Override
    public void removeFromMonster(final Monster monster) {
        if (monster.getEntity().hasPotionEffect(PotionEffectType.POISON) || monster.getEntity().hasPotionEffect(PotionEffectType.WITHER) || monster.getEntity().hasPotionEffect(PotionEffectType.HARM)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    RootEffect.super.removeFromMonster(monster);
                }
            }, 1L);
        } else {
            super.removeFromMonster(monster);
        }
    }

    @Override
    public void removeFromHero(final Hero hero) {
        if (hero.getEntity().hasPotionEffect(PotionEffectType.POISON) || hero.getEntity().hasPotionEffect(PotionEffectType.WITHER) || hero.getEntity().hasPotionEffect(PotionEffectType.HARM)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    RootEffect.super.removeFromHero(hero);
                }
            }, 1L);
        } else {
            super.removeFromHero(hero);
        }
    }

    @Override
    public void tickHero(Hero hero) {
        Location location = hero.getPlayer().getLocation();
        if (location.getX() != this.loc.getX() || location.getZ() != this.loc.getZ()) {
            Player player = hero.getPlayer();
            player.setVelocity(new Vector(0, 0, 0));
            this.loc.setYaw(location.getYaw());
            this.loc.setPitch(location.getPitch());
            this.loc.setY(location.getY());
            player.teleport(this.loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
    }

    @Override
    public void tickMonster(Monster monster) {
    }
}

