/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class PeriodicManaDrainEffect
extends PeriodicEffect {
    private final int manaTick;
    private boolean isFirstTick = true;

    public PeriodicManaDrainEffect(Skill skill, String name, Player applier, int period, int manaDrainTick) {
        this(skill, name, applier, period, manaDrainTick, true);
    }

    public PeriodicManaDrainEffect(Skill skill, String name, Player applier, int period, int manaDrainTick, String applyText, String expireText) {
        this(skill, name, applier, period, manaDrainTick, true, applyText, expireText);
    }

    public PeriodicManaDrainEffect(Skill skill, String name, Player applier, int period, int manaDrainTick, boolean dontDrainOnFirstTick) {
        this(skill, name, applier, period, manaDrainTick, dontDrainOnFirstTick, null, null);
    }

    public PeriodicManaDrainEffect(Skill skill, String name, Player applier, int period, int manaDrainTick, boolean dontDrainOnFirstTick, String applyText, String expireText) {
        super(skill, name, applier, period, applyText, expireText);
        this.manaTick = manaDrainTick;
        this.types.add(EffectType.MANA_DECREASING);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
    }

    @Override
    public void tickHero(Hero hero) {
        super.tickHero(hero);
        if (this.isFirstTick) {
            this.isFirstTick = false;
        } else if (hero.getMana() < this.manaTick) {
            hero.removeEffect(this);
        } else {
            hero.setMana(hero.getMana() - this.manaTick);
        }
    }
}

