/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class PeriodicExpirableManaDrainEffect
extends PeriodicExpirableEffect {
    private final int manaTick;
    private boolean isFirstTick;

    public PeriodicExpirableManaDrainEffect(Skill skill, String name, Player applier, long period, long duration, int manaDrainTick) {
        this(skill, name, applier, period, duration, manaDrainTick, true, null, null);
    }

    public PeriodicExpirableManaDrainEffect(Skill skill, String name, Player applier, long period, long duration, int manaDrainTick, boolean dontDrainOnFirstTick) {
        this(skill, name, applier, period, duration, manaDrainTick, dontDrainOnFirstTick, null, null);
    }

    public PeriodicExpirableManaDrainEffect(Skill skill, String name, Player applier, long period, long duration, int manaDrainTick, String applyText, String expireText) {
        this(skill, name, applier, period, duration, manaDrainTick, true, applyText, expireText);
    }

    public PeriodicExpirableManaDrainEffect(Skill skill, String name, Player applier, long period, long duration, int manaDrainTick, boolean dontDrainOnFirstTick, String applyText, String expireText) {
        super(skill, name, applier, period, duration, applyText, expireText);
        this.manaTick = manaDrainTick;
        this.isFirstTick = dontDrainOnFirstTick;
        this.types.add(EffectType.MANA_DECREASING);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
    }

    @Override
    public void tickMonster(Monster monster) {
    }

    @Override
    public void tickHero(Hero hero) {
        if (this.isFirstTick) {
            this.isFirstTick = false;
        } else if (hero.getMana() < this.manaTick) {
            hero.removeEffect(this);
        } else {
            hero.setMana(hero.getMana() - this.manaTick);
        }
    }
}

