/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.util.Messaging;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class InvisibleEffect
extends ExpirableEffect {
    public static final Set<UUID> hiddenPlayers = new HashSet<UUID>();
    private final String applyText;
    private final String expireText;

    public InvisibleEffect(Skill skill, Player applier, long duration) {
        this(skill, "Invisible", applier, duration, ChatComponents.GENERIC_SKILL + "You become invisible.", ChatComponents.GENERIC_SKILL + "You are seen once more!");
    }

    public InvisibleEffect(Skill skill, String name, Player applier, long duration) {
        this(skill, name, applier, duration, ChatComponents.GENERIC_SKILL + "You become invisible.", ChatComponents.GENERIC_SKILL + "You are seen once more!");
    }

    public InvisibleEffect(Skill skill, Player applier, long duration, String applyText, String expireText) {
        this(skill, "Invisible", applier, duration, applyText, expireText);
    }

    public InvisibleEffect(Skill skill, String name, Player applier, long duration, String applyText, String expireText) {
        super(skill, name, applier, duration, null, null);
        this.applyText = applyText;
        this.expireText = expireText;
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.INVIS);
        this.types.add(EffectType.UNTARGETABLE);
        this.types.add(EffectType.SILENT_ACTIONS);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (onlinePlayer.equals(player) || onlinePlayer.hasPermission("heroes.admin.seeinvis")) continue;
            onlinePlayer.hidePlayer(player);
        }
        hiddenPlayers.add(player.getUniqueId());
        for (Entity entity : player.getNearbyEntities(50.0, 30.0, 50.0)) {
            NMSHandler.getInterface().hidePlayerFromEntity(player, entity);
        }
        if (this.applyText != null && this.applyText.length() > 0) {
            Messaging.send((CommandSender)player, "    " + this.applyText, player.getName(), this.getApplier().getName());
        }
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (onlinePlayer.equals(player)) continue;
            onlinePlayer.showPlayer(player);
        }
        hiddenPlayers.remove(player.getUniqueId());
        if (this.expireText != null && this.expireText.length() > 0) {
            Messaging.send((CommandSender)player, "    " + this.expireText, player.getName(), this.getApplier().getName());
        }
    }
}

