/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.chat.ChatComponents;
import org.bukkit.ChatColor;

public class ImbueEffect
extends Effect {
    private String description;

    public ImbueEffect(Skill skill, String name) {
        super(skill, name);
        this.types.add(EffectType.IMBUE);
        this.types.add(EffectType.BENEFICIAL);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        for (Effect effect : hero.getEffects()) {
            if (effect.equals(this) || !effect.isType(EffectType.IMBUE)) continue;
            hero.removeEffect(effect);
        }
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        hero.getPlayer().sendMessage(ChatComponents.GENERIC_SKILL + "Your weapon is no longer imbued with " + ChatColor.WHITE + this.description);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

