/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.CustomNameManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FormEffect
extends Effect {
    private String applyText;
    private String expireText;

    public FormEffect(Skill skill, String name) {
        this(skill, name, (String)null, (String)null);
    }

    public FormEffect(Skill skill, String name, String applyText, String expireText) {
        super(skill, name);
        this.types.add(EffectType.FORM);
        this.applyText = applyText;
        this.expireText = expireText;
    }

    @Override
    public void applyToMonster(Monster monster) {
        super.applyToMonster(monster);
        if (this.applyText != null && this.applyText.length() > 0 && !monster.hasEffectType(EffectType.SILENT_ACTIONS)) {
            this.broadcast(monster.getEntity().getLocation(), this.applyText, CustomNameManager.getName(monster));
        }
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        for (Effect effect : hero.getEffects()) {
            if (!effect.isType(EffectType.FORM) || effect.equals(this)) continue;
            hero.removeEffect(effect);
        }
        if (this.applyText != null && this.applyText.length() > 0) {
            Player player = hero.getPlayer();
            if (hero.hasEffectType(EffectType.SILENT_ACTIONS)) {
                Messaging.send((CommandSender)player, "    " + this.applyText, player.getName());
            } else {
                this.broadcast(player.getLocation(), "    " + this.applyText, player.getName());
            }
        }
    }

    @Override
    public String getApplyText() {
        return this.applyText;
    }

    @Override
    public void setApplyText(String applyText) {
        this.applyText = applyText;
    }

    public String getExpireText() {
        return this.expireText;
    }

    public void setExpireText(String expireText) {
        this.expireText = expireText;
    }

    @Override
    public void removeFromMonster(Monster monster) {
        super.removeFromMonster(monster);
        if (this.expireText != null && this.expireText.length() > 0 && !monster.hasEffectType(EffectType.SILENT_ACTIONS)) {
            this.broadcast(monster.getEntity().getLocation(), this.expireText, CustomNameManager.getName(monster));
        }
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        if (this.expireText != null && this.expireText.length() > 0) {
            Player player = hero.getPlayer();
            if (hero.hasEffectType(EffectType.SILENT_ACTIONS)) {
                Messaging.send((CommandSender)player, "    " + this.expireText, player.getName());
            } else {
                this.broadcast(player.getLocation(), "    " + this.expireText, player.getName());
            }
        }
    }
}

