/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class FireworkImmunityEffect
extends ExpirableEffect {
    public static String APPLY_TEXT = null;
    public static String EXPIRE_TEXT = "No longer immune to fireworks!";
    private final String applyText;
    private final String expireText;
    private static final double PROTECTION_RADIUS = 50.0;

    public FireworkImmunityEffect(Player applier, int flightPower) {
        this(applier, flightPower, (String)null, (String)null);
    }

    public FireworkImmunityEffect(Player applier, int flightPower, String applyText, String expireText) {
        this(applier, FireworkImmunityEffect.getDurationFromPower(flightPower), applyText, expireText);
    }

    public FireworkImmunityEffect(Player applier, long duration) {
        this(applier, duration, null, null);
    }

    public FireworkImmunityEffect(Player applier, long duration, String applyText, String expireText) {
        super(null, "FireworkImmunity", applier, duration, null, null);
        this.applyText = applyText;
        this.expireText = expireText;
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.SILENT_ACTIONS);
        this.types.add(EffectType.RESIST_FIREWORK_EXPLOSION);
    }

    public static long getDurationFromPower(int flightPower) {
        if (flightPower <= 0) {
            return 0L;
        }
        int extraTicks = 1;
        int ticks = 10 * (flightPower + 1) + 11 + extraTicks;
        return ticks * 1000 / 20;
    }

    public static void applyToUserAndAllies(Hero hero, int flightPower, @Nullable String applyText, @Nullable String expireText) {
        Player userPlayer = hero.getPlayer();
        hero.addEffect(new FireworkImmunityEffect(userPlayer, flightPower, applyText, expireText));
        if (hero.hasParty()) {
            double radiusSquared = 2500.0;
            for (Hero ally : hero.getParty().getMembers()) {
                if (hero.equals(ally)) continue;
                Player allyPlayer = ally.getPlayer();
                if (!userPlayer.getWorld().equals(allyPlayer.getWorld()) || !(userPlayer.getLocation().distanceSquared(allyPlayer.getLocation()) <= radiusSquared)) continue;
                ally.addEffect(new FireworkImmunityEffect(userPlayer, flightPower, applyText, expireText));
            }
        }
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        if (this.applyText != null && this.applyText.length() > 0) {
            hero.getPlayer().sendMessage(ChatColor.GRAY + this.applyText);
        }
    }

    @Override
    public void removeFromHero(Hero hero) {
        if (this.expireText != null && this.expireText.length() > 0) {
            hero.getPlayer().sendMessage(ChatColor.GRAY + this.expireText);
        }
    }
}

