/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class ExpBoostEffect
extends ExpirableEffect {
    private static final String effectName = "BoostedExp";
    private final String applyText;
    private final String expireText;
    private double expMultiplier = 1.0;
    private final boolean stacks;

    public ExpBoostEffect(Player applier, long duration, double expMultiplier) {
        this(applier, duration, expMultiplier, true);
    }

    public ExpBoostEffect(Player applier, long duration, double expMultiplier, boolean stacks) {
        this(applier, duration, expMultiplier, stacks, null, null);
    }

    public ExpBoostEffect(Player applier, long duration, double expMultiplier, boolean stacks, String applyText, String expireText) {
        super(null, effectName, applier, duration, applyText, expireText);
        this.applyText = applyText;
        this.expireText = expireText;
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.SILENT_ACTIONS);
        if (expMultiplier < 1.0) {
            expMultiplier = 1.0;
        }
        this.expMultiplier = expMultiplier;
        this.stacks = stacks;
    }

    public static String getEffectName() {
        return effectName;
    }

    public double getExpMultiplier() {
        return this.expMultiplier;
    }

    public boolean shouldStack() {
        return this.stacks;
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        if (this.applyText != null && this.applyText.length() > 0) {
            hero.getPlayer().sendMessage(ChatColor.GRAY + this.applyText);
        }
    }

    @Override
    public void removeFromHero(Hero hero) {
        if (this.expireText != null && this.expireText.length() > 0) {
            hero.getPlayer().sendMessage(ChatColor.GRAY + this.expireText);
        }
    }
}

