/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.util.Util;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class DisarmEffect
extends ExpirableEffect {
    private final HashMap<Hero, ItemStack[]> disarms = new HashMap();
    private ShutdownListener listener = new ShutdownListener();

    public DisarmEffect(Skill skill, Player applier, long duration) {
        super(skill, "Disarm", applier, duration, null, null);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.DISARM);
    }

    public DisarmEffect(Skill skill, Player applier, long duration, String applyText, String expireText) {
        super(skill, "Disarm", applier, duration, applyText, expireText);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.DISARM);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.listener, (Plugin)this.plugin);
        this.DisarmHero(hero);
    }

    private void DisarmHero(Hero hero) {
        Player player = hero.getPlayer();
        ItemStack[] inv = player.getInventory().getContents();
        for (int i = 0; i < 9; ++i) {
            ItemStack is = inv[i];
            if (is == null || !Util.isWeapon(is.getType()) && !Util.isAwkwardWeapon(is.getType())) continue;
            if (!this.disarms.containsKey(hero)) {
                ItemStack[] disarmedItems = new ItemStack[9];
                disarmedItems[i] = is.clone();
                this.disarms.put(hero, disarmedItems);
                player.getInventory().clear(i);
                continue;
            }
            ItemStack[] items = this.disarms.get(hero);
            items[i] = is;
            player.getInventory().clear(i);
        }
        Util.syncInventory(player, this.plugin);
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        this.rearmHero(hero);
        HandlerList.unregisterAll((Listener)this.listener);
    }

    public void rearmHero(Hero hero) {
        if (!this.disarms.containsKey(hero)) {
            return;
        }
        Player player = hero.getPlayer();
        PlayerInventory inv = player.getInventory();
        ItemStack[] contents = inv.getContents();
        ItemStack[] oldInv = this.disarms.get(hero);
        for (int i = 0; i < 9; ++i) {
            if (oldInv[i] == null) continue;
            if (contents[i] != null) {
                Util.moveItem(hero, i, contents[i]);
            }
            inv.setItem(i, oldInv[i]);
        }
        this.disarms.remove(hero);
        Util.syncInventory(player, this.plugin);
    }

    private class ShutdownListener
    implements Listener {
        private ShutdownListener() {
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent e) {
            if (e.getPlugin() != DisarmEffect.this.plugin) {
                return;
            }
            for (Hero hero : DisarmEffect.this.disarms.keySet()) {
                DisarmEffect.this.rearmHero(hero);
            }
            HandlerList.unregisterAll((Listener)DisarmEffect.this.listener);
        }
    }
}

